/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.RenderingHints;
import java.util.ConcurrentModificationException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.HeavyweightEdgeRenderer;
import org.jungrapht.visualization.renderers.HeavyweightVertexLabelRenderer;
import org.jungrapht.visualization.renderers.HeavyweightVertexRenderer;
import org.jungrapht.visualization.renderers.HeayweightEdgeLabelRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.spatial.Spatial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRenderer<V, E>
implements Renderer<V, E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRenderer.class);
    protected Renderer.Vertex<V, E> vertexRenderer = new HeavyweightVertexRenderer();
    protected Renderer.VertexLabel<V, E> vertexLabelRenderer = new HeavyweightVertexLabelRenderer();
    protected Renderer.Edge<V, E> edgeRenderer = new HeavyweightEdgeRenderer();
    protected Renderer.EdgeLabel<V, E> edgeLabelRenderer = new HeayweightEdgeLabelRenderer();

    DefaultRenderer() {
    }

    @Override
    public void render(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, Spatial<V> vertexSpatial, Spatial<E> edgeSpatial) {
        Graph graph;
        if (vertexSpatial == null) {
            this.render(renderContext, layoutModel);
            return;
        }
        renderContext.getGraphicsContext().getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Set<V> visibleVertices = null;
        Set<E> visibleEdges = null;
        try {
            visibleVertices = vertexSpatial.getVisibleElements(((VisualizationServer)((Object)renderContext.getScreenDevice())).viewOnLayout());
            if (edgeSpatial != null) {
                visibleEdges = edgeSpatial.getVisibleElements(((VisualizationServer)((Object)renderContext.getScreenDevice())).viewOnLayout());
            } else {
                graph = layoutModel.getGraph();
                visibleEdges = graph.edgeSet();
            }
        }
        catch (ConcurrentModificationException ex) {
            log.info("got {} so returning", (Object)ex.toString());
            log.info("layoutMode active: {}, edgeSpatial active {}, vertexSpatial active: {}", new Object[]{layoutModel.isRelaxing(), edgeSpatial != null && edgeSpatial.isActive(), vertexSpatial.isActive()});
            return;
        }
        try {
            graph = layoutModel.getGraph();
            log.trace("the visibleEdges are {}", visibleEdges);
            for (Object e : visibleEdges) {
                if (!graph.edgeSet().contains(e)) continue;
                this.renderEdge(renderContext, layoutModel, e);
                this.renderEdgeLabel(renderContext, layoutModel, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            log.trace("the visibleVertices are {}", visibleVertices);
            for (Object v : visibleVertices) {
                this.renderVertex(renderContext, layoutModel, v);
                this.renderVertexLabel(renderContext, layoutModel, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    @Override
    public void render(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel) {
        renderContext.getGraphicsContext().getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graph graph = layoutModel.getGraph();
        try {
            for (Object e : graph.edgeSet()) {
                this.renderEdge(renderContext, layoutModel, e);
                this.renderEdgeLabel(renderContext, layoutModel, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            for (Object v : graph.vertexSet()) {
                this.renderVertex(renderContext, layoutModel, v);
                this.renderVertexLabel(renderContext, layoutModel, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    @Override
    public void renderVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        this.vertexRenderer.paintVertex(renderContext, layoutModel, v);
    }

    @Override
    public void renderVertexLabel(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        this.vertexLabelRenderer.labelVertex(renderContext, layoutModel, v, renderContext.getVertexLabelFunction().apply(v));
    }

    @Override
    public void renderEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        this.edgeRenderer.paintEdge(renderContext, layoutModel, e);
    }

    @Override
    public void renderEdgeLabel(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        this.edgeLabelRenderer.labelEdge(renderContext, layoutModel, e, renderContext.getEdgeLabelFunction().apply(e));
    }

    @Override
    public void setVertexRenderer(Renderer.Vertex<V, E> r) {
        this.vertexRenderer = r;
    }

    @Override
    public void setEdgeRenderer(Renderer.Edge<V, E> r) {
        this.edgeRenderer = r;
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(Renderer.EdgeLabel<V, E> edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public Renderer.VertexLabel<V, E> getVertexLabelRenderer() {
        return this.vertexLabelRenderer;
    }

    @Override
    public void setVertexLabelRenderer(Renderer.VertexLabel<V, E> vertexLabelRenderer) {
        this.vertexLabelRenderer = vertexLabelRenderer;
    }

    @Override
    public Renderer.Edge<V, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    @Override
    public Renderer.Vertex<V, E> getVertexRenderer() {
        return this.vertexRenderer;
    }
}

