/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(TranslatingGraphMousePlugin.class);

    public TranslatingGraphMousePlugin() {
        this(1024);
    }

    public TranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
        log.trace("setModifiers({})", (Object)modifiers);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
        if (this.checkModifiers(e)) {
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            vv.setCursor(this.cursor);
            try {
                Point2D q = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(this.down);
                Point2D p = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(e.getPoint());
                float dx = (float)(p.getX() - q.getX());
                float dy = (float)(p.getY() - q.getY());
                modelTransformer.translate(dx, dy);
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            catch (RuntimeException ex) {
                log.error("down = {}, e = {}", (Object)this.down, (Object)e);
                throw ex;
            }
            e.consume();
            vv.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

