/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.transform.MutableTransformer;

public class ShearingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static int mask = 128;

    public ShearingGraphMousePlugin() {
        this(0x400 | mask);
    }

    public ShearingGraphMousePlugin(int modifiers) {
        super(modifiers);
        Dimension cd = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        BufferedImage cursorImage = new BufferedImage(cd.width, cd.height, 2);
        Graphics2D g = cursorImage.createGraphics();
        g.addRenderingHints(Collections.singletonMap(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, 16, 16);
        int left = 0;
        int top = 0;
        int right = 15;
        int bottom = 15;
        g.setColor(Color.white);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(left + 2, top + 5, right - 2, top + 5);
        g.drawLine(left + 2, bottom - 5, right - 2, bottom - 5);
        g.drawLine(left + 2, top + 5, left + 4, top + 3);
        g.drawLine(left + 2, top + 5, left + 4, top + 7);
        g.drawLine(right - 2, bottom - 5, right - 4, bottom - 3);
        g.drawLine(right - 2, bottom - 5, right - 4, bottom - 7);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(left + 2, top + 5, right - 2, top + 5);
        g.drawLine(left + 2, bottom - 5, right - 2, bottom - 5);
        g.drawLine(left + 2, top + 5, left + 4, top + 3);
        g.drawLine(left + 2, top + 5, left + 4, top + 7);
        g.drawLine(right - 2, bottom - 5, right - 4, bottom - 3);
        g.drawLine(right - 2, bottom - 5, right - 4, bottom - 7);
        g.dispose();
        this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "RotateCursor");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            vv.setCursor(this.cursor);
            Point q = this.down;
            Point p = e.getPoint();
            float dx = (float)(((Point2D)p).getX() - ((Point2D)q).getX());
            float dy = (float)(((Point2D)p).getY() - ((Point2D)q).getY());
            Dimension d = vv.getSize();
            float shx = 2.0f * dx / (float)d.height;
            float shy = 2.0f * dy / (float)d.width;
            Point2D center = vv.getCenter();
            if (((Point2D)p).getX() < center.getX()) {
                shy = -shy;
            }
            if (((Point2D)p).getY() < center.getY()) {
                shx = -shx;
            }
            modelTransformer.shear(shx, shy, center);
            this.down.x = e.getX();
            this.down.y = e.getY();
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    static {
        if (System.getProperty("os.name").startsWith("Mac")) {
            mask = 256;
        }
    }
}

