/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.DefaultModalGraphMouse;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.SatelliteAnimatedPickingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteRotatingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteShearingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteTranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;

public class ModalSatelliteGraphMouse<V, E>
extends DefaultModalGraphMouse<V, E>
implements ModalGraphMouse {
    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public ModalSatelliteGraphMouse() {
        this(new Builder());
    }

    ModalSatelliteGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly);
    }

    ModalSatelliteGraphMouse(float in, float out) {
        super(in, out);
    }

    ModalSatelliteGraphMouse(float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
    }

    @Override
    public void loadPlugins() {
        this.pickingPlugin = new SelectingGraphMousePlugin();
        this.animatedPickingPlugin = new SatelliteAnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new SatelliteTranslatingGraphMousePlugin(1024);
        this.scalingPlugin = new SatelliteScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new SatelliteRotatingGraphMousePlugin();
        this.shearingPlugin = new SatelliteShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }

    public static class Builder<V, E, T extends ModalSatelliteGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends DefaultModalGraphMouse.Builder<V, E, T, B> {
        @Override
        public T build() {
            return (T)new ModalSatelliteGraphMouse(this.in, this.out, this.vertexSelectionOnly);
        }
    }
}

