/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jungrapht.visualization.control.AbstractModalGraphMouse;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensKillingGraphMousePlugin;
import org.jungrapht.visualization.control.LensMagnificationGraphMousePlugin;
import org.jungrapht.visualization.control.LensSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.LensTranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;

public class ModalLensGraphMouse
extends AbstractModalGraphMouse
implements ModalGraphMouse,
LensGraphMouse {
    protected LensMagnificationGraphMousePlugin magnificationPlugin;
    protected LensSelectingGraphMousePlugin lensSelectingGraphMousePlugin;
    protected LensKillingGraphMousePlugin lensKillingGraphMousePlugin;

    public static <V, E> Builder<?, ?> builder() {
        return new Builder();
    }

    public ModalLensGraphMouse() {
        this(1.1f, 0.9090909f);
    }

    public ModalLensGraphMouse(float in, float out) {
        this(in, out, false, new LensMagnificationGraphMousePlugin());
    }

    public ModalLensGraphMouse(LensMagnificationGraphMousePlugin magnificationPlugin) {
        this(1.1f, 0.9090909f, false, magnificationPlugin);
    }

    public ModalLensGraphMouse(float in, float out, boolean vertexSelectionOnly, LensMagnificationGraphMousePlugin magnificationPlugin) {
        super(in, out, vertexSelectionOnly);
        this.in = in;
        this.out = out;
        this.magnificationPlugin = magnificationPlugin;
        this.lensSelectingGraphMousePlugin = new LensSelectingGraphMousePlugin(1024, 0, 64);
        this.lensKillingGraphMousePlugin = new LensKillingGraphMousePlugin();
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    public void setKillSwitch(Runnable killSwitch) {
        this.lensKillingGraphMousePlugin.setKillSwitch(killSwitch);
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.add(this.lensKillingGraphMousePlugin);
        this.pickingPlugin = this.lensSelectingGraphMousePlugin;
        this.translatingPlugin = new LensTranslatingGraphMousePlugin(1024);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.magnificationPlugin);
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            }
        }
    }

    public static class Builder<T extends ModalLensGraphMouse, B extends Builder<T, B>>
    extends AbstractModalGraphMouse.Builder<T, B> {
        protected LensMagnificationGraphMousePlugin magnificationPlugin;

        public B magnificationPlugin(LensMagnificationGraphMousePlugin magnificationPlugin) {
            this.magnificationPlugin = magnificationPlugin;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new ModalLensGraphMouse(this.in, this.out, this.vertexSelectionOnly, this.magnificationPlugin);
        }
    }
}

