/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JOptionPane;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.layout.model.LayoutModel;

public class LabelEditingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener {
    protected V vertex;
    protected E edge;
    protected Map<V, String> vertexLabelMap;
    protected Map<E, String> edgeLabelMap;

    public LabelEditingGraphMousePlugin(Map<V, String> vertexLabelMap, Map<E, String> edgeLabelMap) {
        this(vertexLabelMap, edgeLabelMap, 1024);
    }

    public LabelEditingGraphMousePlugin(Map<V, String> vertexLabelMap, Map<E, String> edgeLabelMap, int selectionModifiers) {
        super(selectionModifiers);
        this.vertexLabelMap = vertexLabelMap;
        this.edgeLabelMap = edgeLabelMap;
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiersEx() == this.modifiers && e.getClickCount() == 2) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Function vs = vv.getRenderContext().getVertexLabelFunction();
                Point p = e.getPoint();
                Object vertex = pickSupport.getVertex(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                if (vertex != null) {
                    String newLabel = vs.apply(vertex);
                    newLabel = JOptionPane.showInputDialog("New Vertex Label for " + vertex);
                    if (newLabel != null) {
                        this.vertexLabelMap.put((String)vertex, newLabel);
                        vv.repaint();
                    }
                    return;
                }
                Function es = vv.getRenderContext().getEdgeLabelFunction();
                p = e.getPoint();
                Point2D ip = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, p);
                Object edge = pickSupport.getEdge(layoutModel, ip.getX(), ip.getY());
                if (edge != null) {
                    String newLabel = JOptionPane.showInputDialog("New Edge Label for " + edge);
                    if (newLabel != null) {
                        this.edgeLabelMap.put(edge, newLabel);
                        vv.repaint();
                    }
                    return;
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

