/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractPopupGraphMousePlugin;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.selection.MutableSelectedState;

public class EditingPopupGraphMousePlugin<V, E>
extends AbstractPopupGraphMousePlugin {
    protected Supplier<V> vertexFactory;
    protected Supplier<E> edgeFactory;

    public EditingPopupGraphMousePlugin(Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    @Override
    protected void handlePopup(MouseEvent e) {
        final VisualizationViewer vv = (VisualizationViewer)e.getSource();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        final Graph graph = vv.getVisualizationModel().getGraph();
        final Point p = e.getPoint();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        if (pickSupport != null) {
            final Object vertex = pickSupport.getVertex(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
            final Object edge = pickSupport.getEdge(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
            final MutableSelectedState pickedVertexState = vv.getSelectedVertexState();
            final MutableSelectedState pickedEdgeState = vv.getSelectedEdgeState();
            JPopupMenu popup = new JPopupMenu();
            if (vertex != null) {
                Set picked = pickedVertexState.getSelected();
                if (picked.size() > 0) {
                    JMenu menu = new JMenu("Create " + (graph.getType().isDirected() ? "Directed" : "Undirected") + " Edge");
                    popup.add(menu);
                    for (final Object other : picked) {
                        menu.add(new AbstractAction("[" + other + "," + vertex + "]"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                graph.addEdge(other, vertex, EditingPopupGraphMousePlugin.this.edgeFactory.get());
                                vv.repaint();
                            }
                        });
                    }
                }
                popup.add(new AbstractAction("Delete Vertex"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pickedVertexState.deselect(vertex);
                        graph.removeVertex(vertex);
                        vv.getVertexSpatial().recalculate();
                        vv.repaint();
                    }
                });
            } else if (edge != null) {
                popup.add(new AbstractAction("Delete Edge"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pickedEdgeState.deselect(edge);
                        graph.removeEdge(edge);
                        vv.getEdgeSpatial().recalculate();
                        vv.repaint();
                    }
                });
            } else {
                popup.add(new AbstractAction("Create Vertex"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object newVertex = EditingPopupGraphMousePlugin.this.vertexFactory.get();
                        graph.addVertex(newVertex);
                        Point2D p2d = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(p);
                        vv.getVisualizationModel().getLayoutModel().set(newVertex, p2d.getX(), p2d.getY());
                        vv.repaint();
                    }
                });
            }
            if (popup.getComponentCount() > 0) {
                popup.show(vv.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

