/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicIconFactory;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.annotations.AnnotatingGraphMousePlugin;
import org.jungrapht.visualization.control.AbstractModalGraphMouse;
import org.jungrapht.visualization.control.AnimatedPickingGraphMousePlugin;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.EditingGraphMousePlugin;
import org.jungrapht.visualization.control.EditingPopupGraphMousePlugin;
import org.jungrapht.visualization.control.LabelEditingGraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditingModalGraphMouse<V, E>
extends AbstractModalGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    private static final Logger log = LoggerFactory.getLogger(EditingModalGraphMouse.class);
    protected Supplier<V> vertexFactory;
    protected Supplier<E> edgeFactory;
    protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
    protected Map<V, String> vertexLabelMap;
    protected Map<E, String> edgeLabelMap;
    protected EditingGraphMousePlugin<V, E> editingPlugin;
    protected LabelEditingGraphMousePlugin<V, E> labelEditingPlugin;
    protected EditingPopupGraphMousePlugin<V, E> popupEditingPlugin;
    protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;
    protected RenderContext<V, E> rc;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    EditingModalGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.renderContextSupplier.get(), builder.multiLayerTransformerSupplier, builder.vertexFactory, builder.edgeFactory, HashMap::new, HashMap::new, 0.1f, 0.9090909f, false);
    }

    EditingModalGraphMouse(RenderContext<V, E> rc, Supplier<MultiLayerTransformer> multiLayerTransformerSupplier, Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        this(rc, multiLayerTransformerSupplier, vertexFactory, edgeFactory, HashMap::new, HashMap::new, 0.1f, 0.9090909f, false);
    }

    EditingModalGraphMouse(RenderContext<V, E> rc, Supplier<MultiLayerTransformer> multiLayerTransformerSupplier, Supplier<V> vertexFactory, Supplier<E> edgeFactory, Supplier<Map<V, String>> vertexLabelMapSupplier, Supplier<Map<E, String>> edgeLabelMapSupplier) {
        this(rc, multiLayerTransformerSupplier, vertexFactory, edgeFactory, vertexLabelMapSupplier, edgeLabelMapSupplier, 1.1f, 0.9090909f, false);
    }

    EditingModalGraphMouse(RenderContext<V, E> rc, Supplier<MultiLayerTransformer> multiLayerTransformerSupplier, Supplier<V> vertexFactory, Supplier<E> edgeFactory, Supplier<Map<V, String>> vertexLabelMapSupplier, Supplier<Map<E, String>> edgeLabelMapSupplier, float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
        this.rc = rc;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.vertexLabelMap = vertexLabelMapSupplier.get();
        this.edgeLabelMap = edgeLabelMapSupplier.get();
        this.basicTransformer = multiLayerTransformerSupplier.get();
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.pickingPlugin = new SelectingGraphMousePlugin(1024, 0, 64);
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(1024);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.editingPlugin = new EditingGraphMousePlugin<V, E>(this.vertexFactory, this.edgeFactory);
        this.labelEditingPlugin = new LabelEditingGraphMousePlugin<V, E>(this.vertexLabelMap, this.edgeLabelMap);
        this.annotatingPlugin = new AnnotatingGraphMousePlugin<V, E>(this.rc);
        this.popupEditingPlugin = new EditingPopupGraphMousePlugin<V, E>(this.vertexFactory, this.edgeFactory);
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.EDITING);
    }

    @Override
    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            } else if (mode == ModalGraphMouse.Mode.EDITING) {
                this.setEditingMode();
            } else if (mode == ModalGraphMouse.Mode.ANNOTATING) {
                this.setAnnotatingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem((Object)mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)mode, 1));
        }
    }

    @Override
    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.editingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
        this.add(this.labelEditingPlugin);
        this.add(this.popupEditingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.editingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
        this.add(this.labelEditingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setEditingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.labelEditingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.editingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setAnnotatingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.labelEditingPlugin);
        this.remove(this.editingPlugin);
        this.remove(this.popupEditingPlugin);
        this.add(this.annotatingPlugin);
    }

    @Override
    public JComboBox<ModalGraphMouse.Mode> getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING, ModalGraphMouse.Mode.EDITING, ModalGraphMouse.Mode.ANNOTATING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem((Object)this.mode);
        return this.modeBox;
    }

    @Override
    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                }
            });
            JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.PICKING);
                }
            });
            JRadioButtonMenuItem editingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.EDITING.toString());
            editingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.EDITING);
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            radio.add(editingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.add(editingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                        transformingButton.setSelected(true);
                    } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                        pickingButton.setSelected(true);
                    } else if (e.getItem() == ModalGraphMouse.Mode.EDITING) {
                        editingButton.setSelected(true);
                    }
                }
            });
        }
        return this.modeMenu;
    }

    public AnnotatingGraphMousePlugin<V, E> getAnnotatingPlugin() {
        return this.annotatingPlugin;
    }

    public EditingGraphMousePlugin<V, E> getEditingPlugin() {
        return this.editingPlugin;
    }

    public LabelEditingGraphMousePlugin<V, E> getLabelEditingPlugin() {
        return this.labelEditingPlugin;
    }

    public EditingPopupGraphMousePlugin<V, E> getPopupEditingPlugin() {
        return this.popupEditingPlugin;
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        private char e = (char)101;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, char e, char a, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.e = e;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            } else if (keyChar == this.e) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(ModalGraphMouse.Mode.EDITING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(ModalGraphMouse.Mode.ANNOTATING);
            }
        }
    }

    public static class Builder<V, E, T extends EditingModalGraphMouse, B extends Builder<V, E, T, B>>
    extends AbstractModalGraphMouse.Builder<T, B> {
        protected Supplier<V> vertexFactory;
        protected Supplier<E> edgeFactory;
        protected Supplier<Map<V, String>> vertexLabelMapSupplier;
        protected Supplier<Map<E, String>> edgeLabelMapSupplier;
        protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
        protected Supplier<RenderContext<V, E>> renderContextSupplier;

        public B vertexFactory(Supplier<V> vertexFactory) {
            this.vertexFactory = vertexFactory;
            return (B)((Builder)this.self());
        }

        public B edgeFactory(Supplier<E> edgeFactory) {
            this.edgeFactory = edgeFactory;
            return (B)((Builder)this.self());
        }

        public B vertexLabelMapSupplier(Supplier<Map<V, String>> vertexLabelMapSupplier) {
            this.vertexLabelMapSupplier = vertexLabelMapSupplier;
            return (B)((Builder)this.self());
        }

        public B edgeLabelMapSupplier(Supplier<Map<E, String>> edgeLabelMapSupplier) {
            this.edgeLabelMapSupplier = edgeLabelMapSupplier;
            return (B)((Builder)this.self());
        }

        public B multiLayerTransformerSupplier(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier) {
            this.multiLayerTransformerSupplier = multiLayerTransformerSupplier;
            return (B)((Builder)this.self());
        }

        public B renderContextSupplier(Supplier<RenderContext<V, E>> renderContextSupplier) {
            this.renderContextSupplier = renderContextSupplier;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new EditingModalGraphMouse(this);
        }
    }
}

