/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.EdgeSupport;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.SimpleEdgeSupport;
import org.jungrapht.visualization.control.SimpleVertexSupport;
import org.jungrapht.visualization.control.VertexSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;

public class EditingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected VertexSupport<V, E> vertexSupport;
    protected EdgeSupport<V, E> edgeSupport;
    private Creating createMode = Creating.UNDETERMINED;

    public EditingGraphMousePlugin(Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        this(1024, vertexFactory, edgeFactory);
    }

    public EditingGraphMousePlugin(int modifiers, Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(1);
        this.vertexSupport = new SimpleVertexSupport(vertexFactory);
        this.edgeSupport = new SimpleEdgeSupport(edgeFactory);
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiersEx() & this.modifiers) == this.modifiers;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
            Point p = e.getPoint();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Object vertex = pickSupport.getVertex(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                if (vertex != null) {
                    this.createMode = Creating.EDGE;
                    this.edgeSupport.startEdgeCreate(vv, vertex, e.getPoint());
                } else {
                    this.createMode = Creating.VERTEX;
                    this.vertexSupport.startVertexCreate(vv, e.getPoint());
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        Point p = e.getPoint();
        if (this.createMode == Creating.EDGE) {
            GraphElementAccessor pickSupport = vv.getPickSupport();
            Object vertex = pickSupport.getVertex(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
            if (vertex != null) {
                this.edgeSupport.endEdgeCreate(vv, vertex);
                vv.getEdgeSpatial().recalculate();
            } else {
                this.edgeSupport.abort(vv);
            }
        } else if (this.createMode == Creating.VERTEX) {
            this.vertexSupport.endVertexCreate(vv, e.getPoint());
            vv.getVertexSpatial().recalculate();
        }
        this.createMode = Creating.UNDETERMINED;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.createMode == Creating.EDGE) {
                this.edgeSupport.midEdgeCreate(vv, e.getPoint());
            } else if (this.createMode == Creating.VERTEX) {
                this.vertexSupport.midVertexCreate(vv, e.getPoint());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public VertexSupport<V, E> getVertexSupport() {
        return this.vertexSupport;
    }

    public void setVertexSupport(VertexSupport<V, E> vertexSupport) {
        this.vertexSupport = vertexSupport;
    }

    public EdgeSupport<V, E> edgesupport() {
        return this.edgeSupport;
    }

    public void setEdgeSupport(EdgeSupport<V, E> edgeSupport) {
        this.edgeSupport = edgeSupport;
    }

    private static enum Creating {
        EDGE,
        VERTEX,
        UNDETERMINED;

    }
}

