/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jungrapht.visualization.control.AbstractModalGraphMouse;
import org.jungrapht.visualization.control.AnimatedPickingGraphMousePlugin;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;

public class DefaultModalGraphMouse<V, E>
extends AbstractModalGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public DefaultModalGraphMouse() {
        this(new Builder());
    }

    DefaultModalGraphMouse(float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    protected DefaultModalGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly);
    }

    protected DefaultModalGraphMouse(float in, float out) {
        this(in, out, false);
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.pickingPlugin = new SelectingGraphMousePlugin(1024, 0, 64);
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(1024);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            }
        }
    }

    public static class Builder<V, E, T extends DefaultModalGraphMouse, B extends Builder<V, E, T, B>>
    extends AbstractModalGraphMouse.Builder<T, B> {
        @Override
        public T build() {
            return (T)new DefaultModalGraphMouse(this.in, this.out, this.vertexSelectionOnly);
        }
    }
}

