/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.control.AbstractGraphMouse;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensKillingGraphMousePlugin;
import org.jungrapht.visualization.control.LensMagnificationGraphMousePlugin;
import org.jungrapht.visualization.control.LensSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.LensTranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;

public class DefaultLensGraphMouse<V, E>
extends AbstractGraphMouse
implements LensGraphMouse {
    protected LensMagnificationGraphMousePlugin magnificationPlugin;
    protected LensSelectingGraphMousePlugin<V, E> lensSelectingGraphMousePlugin;
    protected LensKillingGraphMousePlugin lensKillingGraphMousePlugin;

    public static <V, E> Builder<V, E, ?, ?> builder(LensMagnificationGraphMousePlugin magnificationPlugin) {
        return new Builder(magnificationPlugin);
    }

    public DefaultLensGraphMouse() {
        this(new Builder(new LensMagnificationGraphMousePlugin()));
    }

    DefaultLensGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly, builder.magnificationPlugin);
    }

    DefaultLensGraphMouse(float in, float out) {
        this(in, out, false, new LensMagnificationGraphMousePlugin());
    }

    public DefaultLensGraphMouse(LensMagnificationGraphMousePlugin magnificationPlugin) {
        this(1.1f, 0.9090909f, false, magnificationPlugin);
    }

    DefaultLensGraphMouse(float in, float out, boolean vertexSelectionOnly, LensMagnificationGraphMousePlugin magnificationPlugin) {
        super(in, out, vertexSelectionOnly);
        this.magnificationPlugin = magnificationPlugin;
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, in, out);
        this.lensSelectingGraphMousePlugin = new LensSelectingGraphMousePlugin();
        this.lensKillingGraphMousePlugin = new LensKillingGraphMousePlugin();
    }

    @Override
    public void setKillSwitch(Runnable killSwitch) {
        this.lensKillingGraphMousePlugin.setKillSwitch(killSwitch);
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.add(this.lensKillingGraphMousePlugin);
        this.add(new LensTranslatingGraphMousePlugin(1024));
        this.add(this.lensSelectingGraphMousePlugin);
        this.add(this.magnificationPlugin);
        this.add(this.scalingPlugin);
    }

    public static class Builder<V, E, T extends DefaultLensGraphMouse, B extends Builder<V, E, T, B>>
    extends AbstractGraphMouse.Builder<T, B> {
        protected LensMagnificationGraphMousePlugin magnificationPlugin;

        protected Builder(LensMagnificationGraphMousePlugin magnificationPlugin) {
            this.magnificationPlugin = magnificationPlugin;
        }

        public B magnificationPlugin(LensMagnificationGraphMousePlugin magnificationPlugin) {
            this.magnificationPlugin = magnificationPlugin;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new DefaultLensGraphMouse(this);
        }
    }
}

