/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.control.AbstractGraphMouse;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.VertexSelectingGraphMousePlugin;

public class DefaultGraphMouse<V, E>
extends AbstractGraphMouse {
    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected DefaultGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly);
    }

    public DefaultGraphMouse() {
        this(new Builder());
    }

    DefaultGraphMouse(float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
    }

    @Override
    public void loadPlugins() {
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.add(new TranslatingGraphMousePlugin(1024));
        this.pickingPlugin = this.vertexSelectionOnly ? new VertexSelectingGraphMousePlugin() : new SelectingGraphMousePlugin();
        this.add(this.pickingPlugin);
        this.add(this.scalingPlugin);
        this.setPluginsLoaded();
    }

    @Override
    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    public static class Builder<V, E, T extends DefaultGraphMouse, B extends Builder<V, E, T, B>>
    extends AbstractGraphMouse.Builder<T, B> {
        @Override
        public T build() {
            return (T)new DefaultGraphMouse(this.in, this.out, this.vertexSelectionOnly);
        }
    }
}

