/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossoverScalingControl
implements ScalingControl {
    private static final Logger log = LoggerFactory.getLogger(CrossoverScalingControl.class);
    protected double minScale;
    protected double maxScale;
    protected double crossover;

    public static Builder builder() {
        return new Builder();
    }

    CrossoverScalingControl(Builder builder) {
        this.minScale = builder.minScale;
        this.maxScale = builder.maxScale;
        this.crossover = builder.crossover;
    }

    public CrossoverScalingControl() {
        this(CrossoverScalingControl.builder());
    }

    public void setCrossover(double crossover) {
        this.crossover = crossover;
    }

    public double getCrossover() {
        return this.crossover;
    }

    @Override
    public void scale(VisualizationServer<?, ?> vv, double horizontalAmount, double verticalAmount, Point2D at) {
        ScalingControl.Axis axis = horizontalAmount == verticalAmount ? ScalingControl.Axis.XY : (verticalAmount == 1.0 ? ScalingControl.Axis.X : (horizontalAmount == 1.0 ? ScalingControl.Axis.Y : ScalingControl.Axis.XY));
        MutableTransformer layoutTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        double modelScaleX = layoutTransformer.getScaleX();
        double modelScaleY = layoutTransformer.getScaleY();
        double viewScaleX = viewTransformer.getScaleX();
        double viewScaleY = viewTransformer.getScaleY();
        double inverseModelScaleX = Math.sqrt(this.crossover) / modelScaleX;
        double inverseModelScaleY = Math.sqrt(this.crossover) / modelScaleY;
        double inverseViewScaleX = Math.sqrt(this.crossover) / viewScaleX;
        double inverseViewScaleY = Math.sqrt(this.crossover) / viewScaleY;
        double scaleX = modelScaleX * viewScaleX;
        double scaleY = modelScaleY * viewScaleY;
        if (scaleX > this.maxScale && horizontalAmount > 1.0) {
            return;
        }
        if (scaleX < this.minScale && horizontalAmount < 1.0) {
            return;
        }
        if (scaleY > this.maxScale && verticalAmount > 1.0) {
            return;
        }
        if (scaleY < this.minScale && verticalAmount < 1.0) {
            return;
        }
        Point2D transformedAt = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, at);
        double newX = scaleX * horizontalAmount;
        double newY = scaleY * verticalAmount;
        double minX = newX - this.crossover;
        double minY = newY - this.crossover;
        switch (axis) {
            case X: {
                this.adjustTransformers(horizontalAmount, verticalAmount, at, layoutTransformer, viewTransformer, inverseModelScaleX, inverseModelScaleY, inverseViewScaleX, inverseViewScaleY, transformedAt, minX * minX < 0.001, newX < this.crossover);
                break;
            }
            case Y: {
                this.adjustTransformers(horizontalAmount, verticalAmount, at, layoutTransformer, viewTransformer, inverseModelScaleX, inverseModelScaleY, inverseViewScaleX, inverseViewScaleY, transformedAt, minY * minY < 0.001, newY < this.crossover);
                break;
            }
            default: {
                this.adjustTransformers(horizontalAmount, verticalAmount, at, layoutTransformer, viewTransformer, inverseModelScaleX, inverseModelScaleY, inverseViewScaleX, inverseViewScaleY, transformedAt, minX * minX < 0.001 || minY * minY < 0.001, newX < this.crossover || newY < this.crossover);
            }
        }
        vv.repaint();
    }

    protected void adjustTransformers(double horizontalAmount, double verticalAmount, Point2D at, MutableTransformer layoutTransformer, MutableTransformer viewTransformer, double inverseModelScaleX, double inverseModelScaleY, double inverseViewScaleX, double inverseViewScaleY, Point2D transformedAt, boolean closeToControlPoint, boolean adjustViewTransform) {
        if (closeToControlPoint) {
            layoutTransformer.scale(inverseModelScaleX, inverseModelScaleY, transformedAt);
            viewTransformer.scale(inverseViewScaleX, inverseViewScaleY, at);
        } else if (adjustViewTransform) {
            viewTransformer.scale(horizontalAmount, verticalAmount, at);
        } else {
            log.trace("layout transform scale by {}  {}", (Object)horizontalAmount, (Object)verticalAmount);
            layoutTransformer.scale(horizontalAmount, verticalAmount, transformedAt);
        }
    }

    public static class Builder {
        double minScale = Double.parseDouble(System.getProperty("jungrapht.minScale", "0.2"));
        double maxScale = Double.parseDouble(System.getProperty("jungrapht.maxScale", "5.0"));
        double crossover = Double.parseDouble(System.getProperty("jungrapht.crossover", "1.0"));

        public Builder minScale(double minScale) {
            this.minScale = minScale;
            return this;
        }

        public Builder maxScale(double maxScale) {
            this.maxScale = maxScale;
            return this;
        }

        public Builder crossover(double crossover) {
            this.crossover = crossover;
            return this;
        }

        public ScalingControl build() {
            return new CrossoverScalingControl(this);
        }
    }
}

