/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicIconFactory;
import org.jungrapht.visualization.control.AbstractGraphMouse;
import org.jungrapht.visualization.control.GraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;

public abstract class AbstractModalGraphMouse
extends AbstractGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    protected ItemListener modeListener;
    protected JComboBox<ModalGraphMouse.Mode> modeBox;
    protected JMenu modeMenu;
    protected ModalGraphMouse.Mode mode;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphMousePlugin translatingPlugin;
    protected GraphMousePlugin animatedPickingPlugin;
    protected GraphMousePlugin rotatingPlugin;
    protected GraphMousePlugin shearingPlugin;
    protected KeyListener modeKeyListener;

    protected AbstractModalGraphMouse(Builder<?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly);
    }

    protected AbstractModalGraphMouse(float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
    }

    @Override
    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem((Object)mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)mode, 1));
        }
    }

    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    @Override
    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    @Override
    public ItemListener getModeListener() {
        if (this.modeListener == null) {
            this.modeListener = new ModeListener();
        }
        return this.modeListener;
    }

    @Override
    public KeyListener getModeKeyListener() {
        return this.modeKeyListener;
    }

    public void setModeKeyListener(KeyListener modeKeyListener) {
        this.modeKeyListener = modeKeyListener;
    }

    public JComboBox<ModalGraphMouse.Mode> getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem((Object)this.mode);
        return this.modeBox;
    }

    public JMenu getModeMenu() {
        return this.getModeMenu(null);
    }

    public JMenu getModeMenu(String text) {
        if (this.modeMenu == null) {
            if (text != null) {
                this.modeMenu = new JMenu(text);
            } else {
                this.modeMenu = new JMenu();
                Icon icon = BasicIconFactory.getMenuArrowIcon();
                this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
                this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            }
            JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                }
            });
            JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.PICKING);
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                        transformingButton.setSelected(true);
                    } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                        pickingButton.setSelected(true);
                    }
                }
            });
        }
        return this.modeMenu;
    }

    @Override
    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    @Override
    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.mode == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{this.mode};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    class ModeListener
    implements ItemListener {
        ModeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AbstractModalGraphMouse.this.setMode((ModalGraphMouse.Mode)((Object)e.getItem()));
        }
    }

    public static abstract class Builder<T extends AbstractModalGraphMouse, B extends Builder<T, B>>
    extends AbstractGraphMouse.Builder<T, B> {
        @Override
        public abstract T build();
    }
}

