/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.annotations;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicIconFactory;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.annotations.AnnotatingGraphMousePlugin;
import org.jungrapht.visualization.control.AbstractModalGraphMouse;
import org.jungrapht.visualization.control.AnimatedPickingGraphMousePlugin;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;

public class AnnotatingModalGraphMouse<V, E>
extends AbstractModalGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    AnnotatingModalGraphMouse(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.basicTransformer = builder.multiLayerTransformerSupplier.get();
        this.annotatingPlugin = builder.annotatingPlugin;
    }

    AnnotatingModalGraphMouse(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier, AnnotatingGraphMousePlugin<V, E> annotatingPlugin) {
        this(multiLayerTransformerSupplier, annotatingPlugin, 1.1f, 0.9090909f, false);
    }

    AnnotatingModalGraphMouse(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier, AnnotatingGraphMousePlugin<V, E> annotatingPlugin, float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
        this.basicTransformer = multiLayerTransformerSupplier.get();
        this.annotatingPlugin = annotatingPlugin;
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.pickingPlugin = new SelectingGraphMousePlugin(1024, 0, 64);
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(1024);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }

    @Override
    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            } else if (mode == ModalGraphMouse.Mode.ANNOTATING) {
                this.setAnnotatingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem((Object)mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)mode, 1));
        }
    }

    @Override
    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    protected void setEditingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.annotatingPlugin);
    }

    protected void setAnnotatingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.add(this.annotatingPlugin);
    }

    @Override
    public JComboBox<ModalGraphMouse.Mode> getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING, ModalGraphMouse.Mode.ANNOTATING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem((Object)this.mode);
        return this.modeBox;
    }

    @Override
    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                }
            });
            JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.PICKING);
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                        transformingButton.setSelected(true);
                    } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                        pickingButton.setSelected(true);
                    }
                }
            });
        }
        return this.modeMenu;
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, char a, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(ModalGraphMouse.Mode.ANNOTATING);
            }
        }
    }

    public static class Builder<V, E, T extends AnnotatingModalGraphMouse, B extends Builder<V, E, T, B>>
    extends AbstractModalGraphMouse.Builder<T, B> {
        protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
        protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;

        public B multiLayerTransformerSupplier(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier) {
            this.multiLayerTransformerSupplier = multiLayerTransformerSupplier;
            return (B)((Builder)this.self());
        }

        public B annotatingPlugin(AnnotatingGraphMousePlugin annotatingGraphMousePlugin) {
            this.annotatingPlugin = annotatingGraphMousePlugin;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new AnnotatingModalGraphMouse(this);
        }
    }
}

