/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.function.Function;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jgrapht.Graph;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.DefaultVisualizationServer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.RenderContextStateChange;
import org.jungrapht.visualization.VisualizationComponent;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.renderers.ModalRenderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.spatial.Spatial;

public interface VisualizationServer<V, E>
extends VisualizationComponent,
ViewChange.Listener,
ModelChange.Listener,
ChangeListener,
LayoutStateChange.Listener,
LayoutSizeChange.Listener,
RenderContextStateChange.Listener {
    public static final String PREFIX = "jungrapht.";

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public static <V, E> Builder<V, E, ?, ?> builder(Graph<V, E> graph) {
        return new Builder(graph);
    }

    public static <V, E> Builder<V, E, ?, ?> builder(VisualizationModel<V, E> visualizationModel) {
        return new Builder(visualizationModel);
    }

    public void setDoubleBuffered(boolean var1);

    public void reset();

    public boolean isDoubleBuffered();

    public Shape viewOnLayout();

    public Spatial<V> getVertexSpatial();

    public void setVertexSpatial(Spatial<V> var1);

    public Spatial<E> getEdgeSpatial();

    public void setEdgeSpatial(Spatial<E> var1);

    public TransformSupport<V, E> getTransformSupport();

    public void setTransformSupport(TransformSupport<V, E> var1);

    public VisualizationModel<V, E> getVisualizationModel();

    public void setVisualizationModel(VisualizationModel<V, E> var1);

    @Override
    public void stateChanged(ChangeEvent var1);

    public ModalRenderer<V, E> getRenderer();

    public void setVisible(boolean var1);

    public Map<RenderingHints.Key, Object> getRenderingHints();

    public void setRenderingHints(Map<RenderingHints.Key, Object> var1);

    public void prependPreRenderPaintable(Paintable var1);

    public void addPreRenderPaintable(Paintable var1);

    public void removePreRenderPaintable(Paintable var1);

    public void addPostRenderPaintable(Paintable var1);

    public void removePostRenderPaintable(Paintable var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public ChangeListener[] getChangeListeners();

    public void fireStateChanged();

    public MutableSelectedState<V> getSelectedVertexState();

    public MutableSelectedState<E> getSelectedEdgeState();

    public void setSelectedVertexState(MutableSelectedState<V> var1);

    public void setSelectedEdgeState(MutableSelectedState<E> var1);

    public GraphElementAccessor<V, E> getPickSupport();

    public void setPickSupport(GraphElementAccessor<V, E> var1);

    public Point2D getCenter();

    public RenderContext<V, E> getRenderContext();

    public void setRenderContext(RenderContext<V, E> var1);

    public void repaint();

    public void scaleToLayout(ScalingControl var1);

    public void scaleToLayout();

    @Deprecated
    public void resizeToLayout();

    public void scaleToLayout(ScalingControl var1, boolean var2);

    public void scaleToLayout(boolean var1);

    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> var1);

    public static interface Paintable {
        public void paint(Graphics var1);

        public boolean useTransform();
    }

    public static class Builder<V, E, T extends DefaultVisualizationServer<V, E>, B extends Builder<V, E, T, B>> {
        protected Graph<V, E> graph = GraphTypeBuilder.directed().buildGraph();
        protected Dimension layoutSize = new Dimension(600, 600);
        protected Dimension viewSize = new Dimension(600, 600);
        protected LayoutAlgorithm<V> layoutAlgorithm = new LayoutAlgorithm.NoOp();
        protected VisualizationModel<V, E> visualizationModel;
        protected Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction;

        protected Builder() {
        }

        protected Builder(Graph<V, E> graph) {
            this.graph = graph;
        }

        protected Builder(VisualizationModel<V, E> visualizationModel) {
            this.visualizationModel = visualizationModel;
        }

        protected B self() {
            return (B)this;
        }

        public B layoutSize(Dimension layoutSize) {
            this.layoutSize = layoutSize;
            return this.self();
        }

        public B viewSize(Dimension viewSize) {
            this.viewSize = viewSize;
            return this.self();
        }

        public B layoutAlgorithm(LayoutAlgorithm<V> layoutAlgorithm) {
            this.layoutAlgorithm = layoutAlgorithm;
            return this.self();
        }

        public B initialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
            this.initialDimensionFunction = initialDimensionFunction;
            return (B)this;
        }

        public T build() {
            return (T)new DefaultVisualizationServer(this);
        }
    }
}

