/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Dimension;
import java.util.Objects;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.RandomLocationTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultVisualizationModel<V, E>
implements VisualizationModel<V, E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultVisualizationModel.class);
    protected LayoutModel<V> layoutModel;
    protected LayoutAlgorithm<V> layoutAlgorithm;
    protected Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction;
    protected ModelChange.Support modelChangeSupport = ModelChange.Support.create();
    protected ViewChange.Support viewChangeSupport = ViewChange.Support.create();
    protected LayoutSizeChange.Support layoutSizeChangeSupport = LayoutSizeChange.Support.create();

    protected DefaultVisualizationModel(VisualizationModel.Builder<V, E, ?, ?> builder) {
        this(builder.graph, builder.layoutAlgorithm, builder.layoutModel, builder.initialDimensionFunction, builder.layoutSize, builder.initializer);
    }

    private DefaultVisualizationModel(Graph<V, E> graph, LayoutAlgorithm<V> layoutAlgorithm, LayoutModel<V> layoutModel, Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction, Dimension layoutSize, Function<V, Point> initializer) {
        if (layoutModel == null) {
            Objects.requireNonNull(graph);
            Objects.requireNonNull(layoutSize);
            if (layoutSize.width <= 0 || layoutSize.height <= 0) {
                throw new IllegalArgumentException("width and height must be > 0");
            }
            if (initializer == null) {
                initializer = new RandomLocationTransformer((double)layoutSize.width, (double)layoutSize.height, System.currentTimeMillis());
            }
            layoutModel = ((LayoutModel.Builder)((LayoutModel.Builder)((LayoutModel.Builder)LayoutModel.builder().graph(graph)).initialDimensionFunction(initialDimensionFunction)).size(layoutSize.width, layoutSize.height)).initializer((Function)initializer).build();
        }
        this.setLayoutModel((LayoutModel<V>)layoutModel);
        this.layoutModel.accept(layoutAlgorithm);
        this.layoutAlgorithm = layoutAlgorithm;
    }

    protected DefaultVisualizationModel(VisualizationModel<V, E> other) {
        this(other.getGraph(), other.getLayoutAlgorithm(), other.getLayoutModel(), other.getInitialDimensionFunction(), other.getLayoutSize(), null);
    }

    @Override
    public LayoutModel<V> getLayoutModel() {
        log.trace("getting a layourModel " + this.layoutModel);
        return this.layoutModel;
    }

    @Override
    public void setLayoutModel(LayoutModel<V> layoutModel) {
        if (this.layoutModel != null) {
            this.layoutModel.stop();
            this.layoutModel.getModelChangeSupport().getModelChangeListeners().remove(this);
            this.layoutModel.getViewChangeSupport().getViewChangeListeners().remove(this);
            this.layoutModel.getLayoutStateChangeSupport().getLayoutStateChangeListeners().remove(this);
        }
        this.layoutModel = layoutModel;
        this.layoutModel.getModelChangeSupport().addModelChangeListener((ModelChange.Listener)this);
        this.layoutModel.getViewChangeSupport().addViewChangeListener((ViewChange.Listener)this);
        this.layoutModel.getLayoutSizeChangeSupport().addLayoutSizeChangeListener((LayoutSizeChange.Listener)this);
        if (this.layoutAlgorithm != null) {
            layoutModel.accept(this.layoutAlgorithm);
        }
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm<V> layoutAlgorithm) {
        this.layoutAlgorithm = layoutAlgorithm;
        log.trace("setLayoutAlgorithm to " + layoutAlgorithm);
        this.layoutModel.accept(layoutAlgorithm);
    }

    @Override
    public Dimension getLayoutSize() {
        return new Dimension(this.layoutModel.getWidth(), this.layoutModel.getHeight());
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.setGraph(graph, true);
    }

    @Override
    public void setGraph(Graph<V, E> graph, boolean forceUpdate) {
        this.layoutModel.setGraph(graph);
        if (forceUpdate && this.layoutAlgorithm != null) {
            log.trace("will accept {}", this.layoutAlgorithm);
            this.layoutModel.accept(this.layoutAlgorithm);
            log.trace("will fire fireModelChanged");
            this.modelChangeSupport.fireModelChanged();
            log.trace("fired fireModelChanged");
        }
    }

    @Override
    public Function<Graph<V, ?>, Pair<Integer>> getInitialDimensionFunction() {
        return this.initialDimensionFunction;
    }

    @Override
    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
        this.layoutModel.setInitialDimensionFunction(initialDimensionFunction);
    }

    @Override
    public LayoutAlgorithm<V> getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.layoutModel.getGraph();
    }

    public ViewChange.Support getViewChangeSupport() {
        return this.viewChangeSupport;
    }

    public void viewChanged() {
        this.getViewChangeSupport().fireViewChanged();
    }

    public ModelChange.Support getModelChangeSupport() {
        return this.modelChangeSupport;
    }

    public void modelChanged() {
        this.getModelChangeSupport().fireModelChanged();
    }

    public LayoutSizeChange.Support<V> getLayoutSizeChangeSupport() {
        return this.layoutSizeChangeSupport;
    }

    public void layoutSizeChanged(LayoutSizeChange.Event<V> evt) {
        this.getLayoutSizeChangeSupport().fireLayoutSizeChanged(evt.layoutModel, evt.width, evt.height);
    }
}

