/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.tour.HamiltonianCycleAlgorithmBase;

public class PalmerHamiltonianCycle<V, E>
extends HamiltonianCycleAlgorithmBase<V, E> {
    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        boolean changed;
        if (!GraphTests.hasOreProperty(graph)) {
            throw new IllegalArgumentException("Graph doesn't have Ore's property");
        }
        ArrayList<V> indexList = new ArrayList<V>(graph.vertexSet());
        int n = indexList.size();
        int[] L = new int[n];
        int[] R = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            L[i + 1] = i;
            R[i] = i + 1;
        }
        L[0] = n - 1;
        R[n - 1] = 0;
        block1: do {
            changed = false;
            int x = 0;
            do {
                if (PalmerHamiltonianCycle.containsEdge(x, R[x], graph, indexList)) continue;
                changed = true;
                int y = 0;
                do {
                    int u = x;
                    int v = R[x];
                    int p = y;
                    int q = R[y];
                    if (v == p || u == p || u == q || !PalmerHamiltonianCycle.containsEdge(u, p, graph, indexList) || !PalmerHamiltonianCycle.containsEdge(v, q, graph, indexList)) continue;
                    R[u] = L[u];
                    L[u] = p;
                    R[v] = R[v];
                    L[v] = q;
                    L[p] = L[p];
                    R[p] = u;
                    L[q] = R[q];
                    R[q] = v;
                    int z = R[u];
                    while (z != q) {
                        int tmp = R[z];
                        R[z] = L[z];
                        L[z] = tmp;
                        z = R[z];
                    }
                    continue block1;
                } while ((y = R[y]) != 0);
            } while ((x = R[x]) != 0);
        } while (changed);
        return this.buildTour(R, indexList, graph);
    }

    private static <V, E> boolean containsEdge(int u, int v, Graph<V, E> graph, List<V> indexList) {
        return graph.containsEdge(indexList.get(u), indexList.get(v));
    }

    private GraphPath<V, E> buildTour(int[] R, List<V> indexList, Graph<V, E> graph) {
        ArrayList<V> vertexList = new ArrayList<V>(indexList.size() + 1);
        int x = 0;
        do {
            vertexList.add(indexList.get(x));
        } while ((x = R[x]) != 0);
        return this.vertexListToTour(vertexList, graph);
    }
}

