/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.app.util.AddEditDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.VertexGraphActionContext;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BlockModelGraphDisplayListener
extends AddressBasedGraphDisplayListener {
    private CodeBlockModel blockModel;

    public BlockModelGraphDisplayListener(PluginTool tool, CodeBlockModel blockModel, GraphDisplay display) {
        super(tool, blockModel.getProgram(), display);
        this.blockModel = blockModel;
        this.addActions(display);
    }

    private void addActions(GraphDisplay display) {
        display.addAction((DockingAction)((ActionBuilder)new ActionBuilder("Rename Vertex", "Block Graph").popupMenuPath(new String[]{"Rename Vertex"})).withContext(VertexGraphActionContext.class).helpLocation(new HelpLocation("ProgramGraphPlugin", "Rename Vertex")).enabledWhen(c -> this.getAddress(c.getClickedVertex().getId()) != null).onAction(this::updateVertexName).build());
    }

    protected String getVertexId(Address address) {
        try {
            CodeBlock[] blocks = this.blockModel.getCodeBlocksContaining(address, TaskMonitor.DUMMY);
            if (blocks != null && blocks.length > 0) {
                return super.getVertexId(blocks[0].getFirstStartAddress());
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return super.getVertexId(address);
    }

    protected Set<AttributedVertex> getVertices(AddressSetView addrSet) {
        if (addrSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AttributedVertex> vertices = new HashSet<AttributedVertex>();
        try {
            SymbolTable symTable = this.program.getSymbolTable();
            CodeBlockIterator cbIter = this.blockModel.getCodeBlocksContaining(addrSet, TaskMonitor.DUMMY);
            while (cbIter.hasNext()) {
                AttributedVertex vertex;
                String addrString;
                CodeBlock block = cbIter.next();
                Address addr = block.getFirstStartAddress();
                if (addr.isExternalAddress()) {
                    Symbol s = symTable.getPrimarySymbol(addr);
                    addrString = s.getName(true);
                } else {
                    addrString = addr.toString();
                }
                if ((vertex = this.graphDisplay.getGraph().getVertex(addrString)) == null) continue;
                vertices.add(vertex);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return vertices;
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertices) {
        AddressSet addrSet = new AddressSet();
        try {
            for (AttributedVertex vertex : vertices) {
                Address blockAddr = this.getAddress(vertex);
                if (!this.isValidAddress(blockAddr)) continue;
                CodeBlock[] blocks = null;
                if (this.blockModel != null) {
                    CodeBlock block = this.blockModel.getCodeBlockAt(blockAddr, TaskMonitor.DUMMY);
                    blocks = block != null ? new CodeBlock[]{block} : this.blockModel.getCodeBlocksContaining(blockAddr, TaskMonitor.DUMMY);
                }
                if (blocks != null && blocks.length > 0) {
                    for (CodeBlock block : blocks) {
                        addrSet.add((AddressSetView)block);
                    }
                    continue;
                }
                addrSet.addRange(blockAddr, blockAddr);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return addrSet;
    }

    protected boolean isValidAddress(Address addr) {
        if (addr == null || this.program == null) {
            return false;
        }
        return this.program.getMemory().contains(addr) || addr.isExternalAddress();
    }

    private void updateVertexName(VertexGraphActionContext context) {
        AttributedVertex vertex = context.getClickedVertex();
        Address address = this.getAddress(vertex);
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (symbol == null) {
            AddEditDialog dialog = new AddEditDialog("Create Label", this.tool);
            dialog.addLabel(address, this.program, context.getComponentProvider());
        } else {
            AddEditDialog dialog = new AddEditDialog("Edit Label", this.tool);
            dialog.editLabel(symbol, this.program, context.getComponentProvider());
        }
    }

    public GraphDisplayListener cloneWith(GraphDisplay newGraphDisplay) {
        return new BlockModelGraphDisplayListener(this.tool, this.blockModel, newGraphDisplay);
    }
}

