/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Iterator;
import java.util.List;

public interface SymbolTable {
    public Symbol createLabel(Address var1, String var2, SourceType var3) throws InvalidInputException;

    @Deprecated
    public Symbol createSymbol(Address var1, String var2, SourceType var3) throws InvalidInputException;

    public Symbol createLabel(Address var1, String var2, Namespace var3, SourceType var4) throws InvalidInputException;

    @Deprecated
    public Symbol createSymbol(Address var1, String var2, Namespace var3, SourceType var4) throws DuplicateNameException, InvalidInputException;

    public boolean removeSymbolSpecial(Symbol var1);

    public Symbol getSymbol(long var1);

    public Symbol getSymbol(String var1, Address var2, Namespace var3);

    public Symbol getGlobalSymbol(String var1, Address var2);

    @Deprecated
    public Symbol getSymbol(String var1, Namespace var2);

    @Deprecated
    public Symbol getSymbol(String var1);

    public List<Symbol> getGlobalSymbols(String var1);

    public List<Symbol> getLabelOrFunctionSymbols(String var1, Namespace var2);

    public Symbol getNamespaceSymbol(String var1, Namespace var2);

    public Symbol getLibrarySymbol(String var1);

    public Symbol getClassSymbol(String var1, Namespace var2);

    public Symbol getParameterSymbol(String var1, Namespace var2);

    public Symbol getLocalVariableSymbol(String var1, Namespace var2);

    public List<Symbol> getSymbols(String var1, Namespace var2);

    public Symbol getVariableSymbol(String var1, Function var2);

    public Namespace getNamespace(String var1, Namespace var2);

    public SymbolIterator getSymbols(String var1);

    public SymbolIterator getAllSymbols(boolean var1);

    public Symbol getSymbol(Reference var1);

    public Symbol getPrimarySymbol(Address var1);

    public Symbol[] getSymbols(Address var1);

    public Symbol[] getUserSymbols(Address var1);

    public SymbolIterator getSymbols(Namespace var1);

    public SymbolIterator getSymbols(long var1);

    public boolean hasSymbol(Address var1);

    public long getDynamicSymbolID(Address var1);

    public SymbolIterator getSymbolIterator(String var1, boolean var2);

    public SymbolIterator getSymbols(AddressSetView var1, SymbolType var2, boolean var3);

    public int getNumSymbols();

    public SymbolIterator getSymbolIterator();

    public SymbolIterator getDefinedSymbols();

    public Symbol getExternalSymbol(String var1);

    public SymbolIterator getExternalSymbols(String var1);

    public SymbolIterator getExternalSymbols();

    public SymbolIterator getSymbolIterator(boolean var1);

    public SymbolIterator getSymbolIterator(Address var1, boolean var2);

    public SymbolIterator getPrimarySymbolIterator(boolean var1);

    public SymbolIterator getPrimarySymbolIterator(Address var1, boolean var2);

    public SymbolIterator getPrimarySymbolIterator(AddressSetView var1, boolean var2);

    public void addExternalEntryPoint(Address var1);

    public void removeExternalEntryPoint(Address var1);

    public boolean isExternalEntryPoint(Address var1);

    public AddressIterator getExternalEntryPointIterator();

    public LabelHistory[] getLabelHistory(Address var1);

    public Iterator<LabelHistory> getLabelHistory();

    public boolean hasLabelHistory(Address var1);

    public Namespace getNamespace(Address var1);

    public Iterator<GhidraClass> getClassNamespaces();

    public GhidraClass createClass(Namespace var1, String var2, SourceType var3) throws DuplicateNameException, InvalidInputException;

    public SymbolIterator getChildren(Symbol var1);

    public Library createExternalLibrary(String var1, SourceType var2) throws DuplicateNameException, InvalidInputException;

    public Namespace createNameSpace(Namespace var1, String var2, SourceType var3) throws DuplicateNameException, InvalidInputException;

    public Symbol createSymbolPlaceholder(Address var1, long var2);
}

