/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class MappedEntry
extends SymbolEntry {
    protected VariableStorage storage;

    public MappedEntry(HighSymbol sym) {
        super(sym);
    }

    public MappedEntry(HighSymbol sym, VariableStorage store, Address addr) {
        super(sym);
        this.storage = store;
        this.pcaddr = addr;
    }

    @Override
    public void restoreXML(XmlPullParser parser) throws PcodeXMLException {
        HighFunction function = this.symbol.function;
        Program program = function.getFunction().getProgram();
        AddressFactory addrFactory = function.getAddressFactory();
        XmlElement addrel = parser.start(new String[]{"addr"});
        int sz = this.symbol.type.getLength();
        if (sz == 0) {
            throw new PcodeXMLException("Invalid symbol 0-sized data-type: " + this.symbol.type.getName());
        }
        try {
            Address varAddr = Varnode.readXMLAddress(addrel, addrFactory);
            AddressSpace spc = varAddr.getAddressSpace();
            this.storage = spc == null || spc.getType() != 11 ? new VariableStorage(program, varAddr, sz) : function.readXMLVarnodePieces(addrel, varAddr);
        }
        catch (InvalidInputException e) {
            throw new PcodeXMLException("Invalid storage: " + e.getMessage());
        }
        parser.end(addrel);
        this.parseRangeList(parser);
    }

    @Override
    public void saveXml(StringBuilder buf) {
        int logicalsize = 0;
        int typeLength = this.symbol.type.getLength();
        if (typeLength != this.storage.size() && this.symbol.type instanceof AbstractFloatDataType) {
            logicalsize = typeLength;
        }
        String addrRes = Varnode.buildXMLAddress(this.storage.getVarnodes(), logicalsize);
        buf.append(addrRes);
        this.buildRangelistXML(buf);
    }

    @Override
    public VariableStorage getStorage() {
        return this.storage;
    }

    @Override
    public int getSize() {
        return this.storage.size();
    }

    @Override
    public boolean isReadOnly() {
        Address addr = this.storage.getMinAddress();
        if (addr == null) {
            return false;
        }
        boolean readonly = false;
        Program program = this.symbol.getProgram();
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block != null) {
            boolean bl = readonly = !block.isWrite();
            if (readonly) {
                ReferenceIterator refIter = program.getReferenceManager().getReferencesTo(addr);
                for (int count = 0; refIter.hasNext() && count < 100; ++count) {
                    Reference ref = refIter.next();
                    if (ref.getReferenceType().isWrite()) {
                        readonly = false;
                        break;
                    }
                    if (!ref.getReferenceType().isRead()) continue;
                }
            }
        }
        return readonly;
    }

    @Override
    public boolean isVolatile() {
        Address addr = this.storage.getMinAddress();
        if (addr == null) {
            return false;
        }
        Program program = this.symbol.getProgram();
        if (program.getLanguage().isVolatile(addr)) {
            return true;
        }
        MemoryBlock block = program.getMemory().getBlock(addr);
        return block != null && block.isVolatile();
    }
}

