/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;

public class HighFunctionShellSymbol
extends HighSymbol {
    public HighFunctionShellSymbol(long id, String nm, Address addr, PcodeDataTypeManager manage) {
        super(id, nm, DataType.DEFAULT, true, true, manage);
        VariableStorage store;
        try {
            store = new VariableStorage(this.getProgram(), addr, 1);
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedEntry entry = new MappedEntry(this, store, null);
        this.addMapEntry(entry);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public void saveXML(StringBuilder buf) {
        buf.append("<function");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.getId());
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"size", (long)1L);
        buf.append(">\n");
        buf.append(Varnode.buildXMLAddress(this.getStorage().getMinAddress()));
        buf.append("</function>\n");
    }
}

