/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class EquateSymbol
extends HighSymbol {
    public static final int FORMAT_DEFAULT = 0;
    public static final int FORMAT_HEX = 1;
    public static final int FORMAT_DEC = 2;
    public static final int FORMAT_OCT = 3;
    public static final int FORMAT_BIN = 4;
    public static final int FORMAT_CHAR = 5;
    private long value;
    private int convert;

    public EquateSymbol(HighFunction func) {
        super(func);
    }

    public EquateSymbol(long uniqueId, String nm, long val, HighFunction func, Address addr, long hash) {
        super(uniqueId, nm, DataType.DEFAULT, func);
        this.category = 1;
        this.value = val;
        this.convert = 0;
        DynamicEntry entry = new DynamicEntry(this, addr, hash);
        this.addMapEntry(entry);
    }

    public EquateSymbol(long uniqueId, int conv, long val, HighFunction func, Address addr, long hash) {
        super(uniqueId, "", DataType.DEFAULT, func);
        this.category = 1;
        this.value = val;
        this.convert = conv;
        DynamicEntry entry = new DynamicEntry(this, addr, hash);
        this.addMapEntry(entry);
    }

    public long getValue() {
        return this.value;
    }

    public int getConvert() {
        return this.convert;
    }

    @Override
    public void restoreXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement symel = parser.start(new String[]{"equatesymbol"});
        this.restoreXMLHeader(symel);
        this.type = DataType.DEFAULT;
        this.convert = 0;
        String formString = symel.getAttribute("format");
        if (formString != null) {
            if (formString.equals("hex")) {
                this.convert = 1;
            } else if (formString.equals("dec")) {
                this.convert = 2;
            } else if (formString.equals("char")) {
                this.convert = 5;
            } else if (formString.equals("oct")) {
                this.convert = 3;
            } else if (formString.equals("bin")) {
                this.convert = 4;
            }
        }
        parser.start(new String[]{"value"});
        this.value = SpecXmlUtils.decodeLong((String)parser.end().getText());
        parser.end(symel);
    }

    @Override
    public void saveXML(StringBuilder buf) {
        buf.append("<equatesymbol");
        this.saveXMLHeader(buf);
        if (this.convert != 0) {
            String formString = "hex";
            if (this.convert != 1) {
                if (this.convert == 2) {
                    formString = "dec";
                } else if (this.convert == 3) {
                    formString = "oct";
                } else if (this.convert == 4) {
                    formString = "bin";
                } else if (this.convert == 5) {
                    formString = "char";
                }
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"format", (String)formString);
        }
        buf.append(">\n");
        buf.append("  <value>0x");
        buf.append(Long.toHexString(this.value));
        buf.append("</value>\n");
        buf.append("</equatesymbol>\n");
    }

    public static int convertName(String nm, long val) {
        char firstChar;
        int pos = 0;
        if ((firstChar = nm.charAt(pos++)) == '-') {
            if (nm.length() > pos) {
                firstChar = nm.charAt(pos++);
            } else {
                return 0;
            }
        }
        if (firstChar == '\'') {
            return 5;
        }
        if (firstChar == '\"') {
            return 2;
        }
        if (firstChar < '0' || firstChar > '9') {
            return -1;
        }
        char lastChar = nm.charAt(nm.length() - 1);
        if (lastChar == 'b') {
            return 4;
        }
        if (lastChar == 'o') {
            return 3;
        }
        int format = 2;
        if (firstChar == '0') {
            char c;
            format = 2;
            if (nm.length() >= pos + 1 && (c = nm.charAt(pos)) == 'x') {
                format = 1;
            }
        }
        return format;
    }
}

