/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.generic.MemoryBlockDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.AddressLabelInfo;
import ghidra.util.ManualEntry;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public interface Language {
    public LanguageID getLanguageID();

    public LanguageDescription getLanguageDescription();

    public ParallelInstructionLanguageHelper getParallelInstructionHelper();

    public Processor getProcessor();

    public int getVersion();

    public int getMinorVersion();

    public AddressFactory getAddressFactory();

    public AddressSpace getDefaultSpace();

    public AddressSpace getDefaultDataSpace();

    public boolean isBigEndian();

    public int getInstructionAlignment();

    public boolean supportsPcode();

    public boolean isVolatile(Address var1);

    public InstructionPrototype parse(MemBuffer var1, ProcessorContext var2, boolean var3) throws InsufficientBytesException, UnknownInstructionException;

    public int getNumberOfUserDefinedOpNames();

    public String getUserDefinedOpName(int var1);

    public Register[] getRegisters(Address var1);

    public Register getRegister(AddressSpace var1, long var2, int var4);

    public List<Register> getRegisters();

    public List<String> getRegisterNames();

    public Register getRegister(String var1);

    public Register getRegister(Address var1, int var2);

    public Register getProgramCounter();

    public Register getContextBaseRegister();

    public List<Register> getContextRegisters();

    public MemoryBlockDefinition[] getDefaultMemoryBlocks();

    public List<AddressLabelInfo> getDefaultSymbols();

    public String getSegmentedSpace();

    public AddressSetView getVolatileAddresses();

    public void applyContextSettings(DefaultProgramContext var1);

    public void reloadLanguage(TaskMonitor var1) throws IOException;

    public List<CompilerSpecDescription> getCompatibleCompilerSpecDescriptions();

    public CompilerSpec getCompilerSpecByID(CompilerSpecID var1) throws CompilerSpecNotFoundException;

    public CompilerSpec getDefaultCompilerSpec();

    public boolean hasProperty(String var1);

    public int getPropertyAsInt(String var1, int var2);

    public boolean getPropertyAsBoolean(String var1, boolean var2);

    public String getProperty(String var1, String var2);

    public String getProperty(String var1);

    public Set<String> getPropertyKeys();

    public boolean hasManual();

    public ManualEntry getManualEntry(String var1);

    public Set<String> getManualInstructionMnemonicKeys();

    public Exception getManualException();

    public List<Register> getSortedVectorRegisters();
}

