/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;

public enum MetaDataType {
    VOID,
    UNKNOWN,
    INT,
    UINT,
    BOOL,
    CODE,
    FLOAT,
    PTR,
    ARRAY,
    STRUCT;


    public static MetaDataType getMeta(DataType dt) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof DefaultDataType || dt instanceof Undefined) {
            return UNKNOWN;
        }
        if (dt instanceof AbstractIntegerDataType) {
            if (dt instanceof BooleanDataType) {
                return BOOL;
            }
            if (((AbstractIntegerDataType)dt).isSigned()) {
                return INT;
            }
            return UINT;
        }
        if (dt instanceof Pointer) {
            return PTR;
        }
        if (dt instanceof Array) {
            return ARRAY;
        }
        if (dt instanceof Structure) {
            return STRUCT;
        }
        if (dt instanceof AbstractFloatDataType) {
            return FLOAT;
        }
        if (dt instanceof ArrayStringable) {
            return INT;
        }
        if (dt instanceof FunctionDefinition) {
            return CODE;
        }
        if (dt instanceof Enum) {
            return UINT;
        }
        if (dt instanceof AbstractStringDataType) {
            return ARRAY;
        }
        return STRUCT;
    }

    public static DataType getMostSpecificDataType(DataType a, DataType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        DataType aCopy = a;
        DataType bCopy = b;
        while (true) {
            MetaDataType bMeta;
            MetaDataType aMeta;
            int compare;
            if ((compare = (aMeta = MetaDataType.getMeta(a)).compareTo(bMeta = MetaDataType.getMeta(b))) < 0) {
                return bCopy;
            }
            if (compare > 0) {
                return aCopy;
            }
            if (aMeta == PTR) {
                if (a instanceof TypeDef) {
                    a = ((TypeDef)a).getBaseDataType();
                }
                if (b instanceof TypeDef) {
                    b = ((TypeDef)b).getBaseDataType();
                }
                a = ((Pointer)a).getDataType();
                b = ((Pointer)b).getDataType();
                continue;
            }
            if (aMeta != ARRAY) break;
            if (a instanceof TypeDef) {
                a = ((TypeDef)a).getBaseDataType();
            }
            if (b instanceof TypeDef) {
                b = ((TypeDef)b).getBaseDataType();
            }
            if (!(a instanceof Array) || !(b instanceof Array)) break;
            a = ((Array)a).getDataType();
            b = ((Array)b).getDataType();
        }
        return aCopy;
    }
}

