/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;

public class ArrayDataType
extends DataTypeImpl
implements Array {
    private static final long serialVersionUID = 1L;
    private int numElements;
    private DataType dataType;
    private int elementLength;
    private boolean deleted = false;

    public ArrayDataType(DataType dataType, int numElements, int elementLength) {
        this(dataType, numElements, elementLength, null);
    }

    public ArrayDataType(DataType dataType, int numElements, int elementLength, DataTypeManager dtm) {
        super(dataType.getCategoryPath(), "array", dtm);
        int dtLen;
        this.validate(dataType);
        if (dataType.getDataTypeManager() != dtm) {
            dataType = dataType.clone(dtm);
        }
        if ((dtLen = dataType.getLength()) < 0 && elementLength < 0) {
            throw new IllegalArgumentException("Array DataType must be Fixed length");
        }
        if (numElements <= 0) {
            throw new IllegalArgumentException("number of array elements must be positive, not " + numElements);
        }
        this.dataType = dataType;
        this.elementLength = dtLen < 0 ? elementLength : -1;
        this.numElements = numElements;
        this.name = DataTypeUtilities.getName(this, true);
        dataType.addParent(this);
    }

    private void validate(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            throw new IllegalArgumentException("Array data-type may not be a bitfield: " + dt.getName());
        }
        if (dt instanceof FactoryDataType) {
            throw new IllegalArgumentException("Array data-type may not be a Factory data-type: " + dt.getName());
        }
        if (dt instanceof Dynamic && !((Dynamic)dt).canSpecifyLength()) {
            throw new IllegalArgumentException("Array data-type may not be a non-sizable Dynamic data-type: " + dt.getName());
        }
    }

    @Override
    public boolean isDynamicallySized() {
        return this.dataType.isDynamicallySized();
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.getDataType().getSettingsDefinitions();
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Array)) {
            return false;
        }
        Array array = (Array)obj;
        if (this.numElements != array.getNumElements()) {
            return false;
        }
        if (!this.dataType.isEquivalent(array.getDataType())) {
            return false;
        }
        return !(this.dataType instanceof Dynamic) || this.getElementLength() == array.getElementLength();
    }

    @Override
    public int getNumElements() {
        return this.numElements;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return DataTypeUtilities.getMnemonic(this, false, settings);
    }

    @Override
    public int getLength() {
        return this.numElements * this.getElementLength();
    }

    @Override
    public String getDescription() {
        return "Array of " + this.dataType.getDisplayName();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new ArrayDataType(this.dataType.clone(dtm), this.numElements, this.getElementLength(), dtm);
    }

    @Override
    public final DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt.equals(this.dataType)) {
            this.notifySizeChanged();
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.getArrayValueClass(settings);
    }

    @Override
    public void setName(String name) throws InvalidNameException {
    }

    @Override
    public int getElementLength() {
        return this.elementLength < 0 ? this.dataType.getLength() : this.elementLength;
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.dataType == dt) {
            this.notifyDeleted();
            this.deleted = true;
        }
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (newDt.getLength() < 0) {
            newDt = DataType.DEFAULT;
        }
        if (this.dataType == oldDt) {
            String oldName = this.getName();
            int oldElementLength = this.getElementLength();
            this.dataType.removeParent(this);
            this.dataType = newDt;
            this.dataType.addParent(this);
            this.elementLength = newDt.getLength() < 0 ? oldElementLength : -1;
            this.notifyNameChanged(oldName);
            if (oldElementLength != this.getElementLength()) {
                this.notifySizeChanged();
            }
        }
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public CategoryPath getCategoryPath() {
        DataType dt = this.getDataType();
        return dt.getCategoryPath();
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        if (this.dataType == dt) {
            this.notifyNameChanged(oldName);
        }
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String getDefaultLabelPrefix() {
        DataType dt = this.getDataType();
        if (dt == DataType.DEFAULT) {
            return "ARRAY";
        }
        return dt.getDefaultLabelPrefix() + "_ARRAY";
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return this.getArrayDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        return this.getArrayDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getArrayValue(buf, settings, length);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getArrayRepresentation(buf, settings, length);
    }
}

