/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;

public interface Array
extends DataType {
    public static final String ARRAY_LABEL_PREFIX = "ARRAY";

    public int getNumElements();

    public int getElementLength();

    public DataType getDataType();

    default public String getArrayDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        ArrayStringable stringableElementType = ArrayStringable.getArrayStringable(this.getDataType());
        String prefix = stringableElementType != null ? stringableElementType.getArrayDefaultLabelPrefix(buf, settings, len, options) : null;
        return prefix != null ? prefix : this.getDefaultLabelPrefix();
    }

    default public String getArrayDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        ArrayStringable stringableElementType = ArrayStringable.getArrayStringable(this.getDataType());
        String prefix = stringableElementType != null ? stringableElementType.getArrayDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength) : null;
        return prefix != null ? prefix : this.getDefaultLabelPrefix(buf, settings, len, options);
    }

    default public String getArrayRepresentation(MemBuffer buf, Settings settings, int length) {
        if (!buf.isInitializedMemory()) {
            return "??";
        }
        ArrayStringable stringableElementType = ArrayStringable.getArrayStringable(this.getDataType());
        String value = stringableElementType != null && stringableElementType.hasStringValue(settings) ? new StringDataInstance(stringableElementType, settings, buf, length, true).getStringRepresentation() : null;
        return value != null ? value : "";
    }

    default public Object getArrayValue(MemBuffer buf, Settings settings, int length) {
        if (!buf.getMemory().getAllInitializedAddressSet().contains(buf.getAddress())) {
            return null;
        }
        ArrayStringable as = ArrayStringable.getArrayStringable(this.getDataType());
        String value = as != null ? as.getArrayString(buf, settings, length) : null;
        return value;
    }

    default public Class<?> getArrayValueClass(Settings settings) {
        DataType dt = this.getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof ArrayStringable && ((ArrayStringable)dt).hasStringValue(settings)) {
            return String.class;
        }
        Class<?> valueClass = dt.getValueClass(settings);
        return valueClass != null ? Array.class : null;
    }
}

