/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.disassemble;

import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.RepeatInstructionByteTracker;
import ghidra.framework.options.Options;
import ghidra.program.database.register.AddressRangeObjectMap;
import ghidra.program.disassemble.DisassemblerConflictHandler;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.disassemble.DisassemblerQueue;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionBlockFlow;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.NestedDelaySlotException;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.AbstractProgramContext;
import ghidra.program.util.ProgramContextImpl;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Disassembler
implements DisassemblerConflictHandler {
    private static final int DISASSEMBLE_MEMORY_CACHE_SIZE = 8;
    public static final String MARK_BAD_INSTRUCTION_PROPERTY = "Mark Bad Disassembly";
    public static final String MARK_UNIMPL_PCODE_PROPERTY = "Mark Unimplemented Pcode";
    public static final String RESTRICT_DISASSEMBLY_TO_EXECUTE_MEMORY_PROPERTY = "Restrict Disassembly to Executable Memory";
    public static final String ERROR_BOOKMARK_CATEGORY = "Bad Instruction";
    public static final String UNIMPL_BOOKMARK_CATEGORY = "Unimplemented Pcode";
    public static final int MAX_REPEAT_PATTERN_LENGTH = 16;
    private static final int NUM_ADDRS_FOR_NOTIFICATION = 1024;
    private static final int INSTRUCTION_SET_SIZE_LIMIT = 2048;
    protected final Language language;
    protected final AddressFactory addrFactory;
    protected final Register baseContextRegister;
    protected final ParallelInstructionLanguageHelper parallelHelper;
    private Program program;
    private DisassemblerContextImpl seedContext;
    private DisassemblerMessageListener listener;
    private AddressSetView restrictedAddressSet;
    private AddressSetView initializedAddressSet;
    private TaskMonitor monitor;
    private ProgramContext realProgramContext;
    private ProgramContextImpl defaultLanguageContext;
    protected DisassemblerProgramContext disassemblerProgramContext;
    protected DisassemblerContextImpl disassemblerContext;
    int instAlignment;
    private DisassemblerQueue disassemblerQueue;
    private Listing listing;
    private int disassembleCount;
    private int totalCount;
    private RepeatInstructionByteTracker repeatInstructionByteTracker = new RepeatInstructionByteTracker(16, null);
    protected BookmarkManager bmMgr;
    protected boolean doMarkBadInstructions = true;
    private boolean doMarkUnimplPcode = true;
    private int instructionSetSizeLimit = 2048;
    private boolean followFlow = false;

    public static Disassembler getDisassembler(Program program, TaskMonitor monitor, DisassemblerMessageListener listener) {
        Class<? extends Disassembler> disassemblerClass = Disassembler.getLanguageSpecificDisassembler(program.getLanguage());
        if (disassemblerClass != null) {
            try {
                Constructor<? extends Disassembler> constructor = disassemblerClass.getConstructor(Program.class, TaskMonitor.class, DisassemblerMessageListener.class);
                return constructor.newInstance(program, monitor, listener);
            }
            catch (Exception e) {
                throw new RuntimeException("Disassembler instantiation failure customDisassemblerClass (" + disassemblerClass.getName() + "): " + program.getLanguage().getLanguageDescription().getLanguageID(), e);
            }
        }
        return new Disassembler(program, monitor, listener);
    }

    public static Disassembler getDisassembler(Language language, AddressFactory addrFactory, TaskMonitor monitor, DisassemblerMessageListener listener) {
        Class<? extends Disassembler> disassemblerClass = Disassembler.getLanguageSpecificDisassembler(language);
        if (disassemblerClass != null) {
            try {
                Constructor<? extends Disassembler> constructor = disassemblerClass.getConstructor(Language.class, AddressFactory.class, TaskMonitor.class, DisassemblerMessageListener.class);
                return constructor.newInstance(language, addrFactory, monitor, listener);
            }
            catch (Exception e) {
                throw new RuntimeException("Disassembler instantiation failure customDisassemblerClass (" + disassemblerClass.getName() + "): " + language.getLanguageDescription().getLanguageID(), e);
            }
        }
        return new Disassembler(language, addrFactory, monitor, listener);
    }

    public static Disassembler getDisassembler(Program program, boolean markBadInstructions, boolean markUnimplementedPcode, boolean restrictToExecuteMemory, TaskMonitor monitor, DisassemblerMessageListener listener) {
        Class<? extends Disassembler> disassemblerClass = Disassembler.getLanguageSpecificDisassembler(program.getLanguage());
        if (disassemblerClass != null) {
            try {
                Constructor<? extends Disassembler> constructor = disassemblerClass.getConstructor(Program.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, TaskMonitor.class, DisassemblerMessageListener.class);
                return constructor.newInstance(program, markBadInstructions, markUnimplementedPcode, restrictToExecuteMemory, monitor, listener);
            }
            catch (Exception e) {
                throw new RuntimeException("Disassembler instantiation failure customDisassemblerClass (" + disassemblerClass.getName() + "): " + program.getLanguage().getLanguageDescription().getLanguageID(), e);
            }
        }
        return new Disassembler(program, markBadInstructions, markUnimplementedPcode, restrictToExecuteMemory, monitor, listener);
    }

    protected Disassembler(Program program, TaskMonitor monitor, DisassemblerMessageListener listener) {
        this(program, Disassembler.isMarkBadDisassemblyOptionEnabled(program), Disassembler.isMarkUnimplementedPcodeOptionEnabled(program), Disassembler.isRestrictToExecuteMemory(program), monitor, listener);
    }

    protected Disassembler(Language language, AddressFactory addrFactory, TaskMonitor monitor, DisassemblerMessageListener listener) {
        this(null, language, addrFactory, false, false, false, monitor, listener);
    }

    protected Disassembler(Program program, boolean markBadInstructions, boolean markUnimplementedPcode, boolean restrictToExecuteMemory, TaskMonitor monitor, DisassemblerMessageListener listener) {
        this(program, program.getLanguage(), program.getAddressFactory(), markBadInstructions, markUnimplementedPcode, restrictToExecuteMemory, monitor, listener);
    }

    private Disassembler(Program program, Language language, AddressFactory addrFactory, boolean markBadInstructions, boolean markUnimplementedPcode, boolean restrictToExecuteMemory, TaskMonitor monitor, DisassemblerMessageListener listener) {
        this.program = program;
        this.language = language;
        this.addrFactory = addrFactory;
        this.parallelHelper = language.getParallelInstructionHelper();
        this.monitor = monitor;
        this.listener = listener;
        this.baseContextRegister = language.getContextBaseRegister();
        this.instAlignment = language.getInstructionAlignment();
        if (program != null) {
            this.listing = program.getListing();
            this.realProgramContext = program.getProgramContext();
            this.bmMgr = program.getBookmarkManager();
        } else {
            this.defaultLanguageContext = new ProgramContextImpl(language);
            language.applyContextSettings(this.defaultLanguageContext);
        }
        this.doMarkBadInstructions = markBadInstructions;
        this.doMarkUnimplPcode = markUnimplementedPcode;
        this.initializedAddressSet = Disassembler.getInitializedMemory(program, restrictToExecuteMemory);
        this.resetDisassemblerContext();
    }

    public void setSeedContext(DisassemblerContextImpl seedContext) {
        if (seedContext != null && seedContext.getBaseContextRegister() != this.baseContextRegister) {
            throw new IllegalArgumentException("Seed context register does not match disassembler's context register: " + this.baseContextRegister);
        }
        this.seedContext = seedContext;
    }

    void setInstructionSetSizeLimit(int limit) {
        this.instructionSetSizeLimit = limit;
    }

    public void setRepeatPatternLimit(int maxInstructions) {
        this.repeatInstructionByteTracker.setRepeatPatternLimit(maxInstructions);
    }

    public void setRepeatPatternLimitIgnored(AddressSetView set) {
        this.repeatInstructionByteTracker.setRepeatPatternLimitIgnored(set);
    }

    public static boolean isMarkBadDisassemblyOptionEnabled(Program program) {
        Options options = program.getOptions("Disassembler");
        return options.getBoolean(MARK_BAD_INSTRUCTION_PROPERTY, true);
    }

    public static boolean isMarkUnimplementedPcodeOptionEnabled(Program program) {
        Options options = program.getOptions("Disassembler");
        return options.getBoolean(MARK_UNIMPL_PCODE_PROPERTY, true);
    }

    public static boolean isRestrictToExecuteMemory(Program program) {
        Options options = program.getOptions("Disassembler");
        return options.getBoolean(RESTRICT_DISASSEMBLY_TO_EXECUTE_MEMORY_PROPERTY, false);
    }

    private static AddressSetView getInitializedMemory(Program program, boolean exectuableMemoryOnly) {
        AddressSet set;
        if (program == null) {
            return null;
        }
        Memory memory = program.getMemory();
        MemoryBlock externalBlock = memory.getBlock("EXTERNAL");
        if (externalBlock != null && !externalBlock.isInitialized()) {
            externalBlock = null;
        }
        if (!exectuableMemoryOnly) {
            if (externalBlock == null) {
                return memory.getLoadedAndInitializedAddressSet();
            }
            set = new AddressSet(memory.getLoadedAndInitializedAddressSet());
        } else {
            set = new AddressSet();
            for (MemoryBlock block : memory.getBlocks()) {
                if (!block.isInitialized() || !block.isExecute()) continue;
                set.add(block.getStart(), block.getEnd());
            }
        }
        if (externalBlock != null) {
            set.delete(externalBlock.getStart(), externalBlock.getEnd());
        }
        return set;
    }

    public AddressSet disassemble(AddressSetView startSet, AddressSetView restrictedSet, boolean doFollowFlow) {
        return this.disassemble(startSet, restrictedSet, null, doFollowFlow);
    }

    public AddressSet disassemble(AddressSetView startSet, AddressSetView restrictedSet, RegisterValue initialContextValue, boolean doFollowFlow) {
        AddressSet disassembledAddrs = new AddressSet();
        int alignment = this.language.getInstructionAlignment();
        AddressRangeIterator addressRanges = startSet.getAddressRanges();
        block2: for (AddressRange addressRange : addressRanges) {
            if (this.monitor.isCancelled()) break;
            if (disassembledAddrs.contains(addressRange.getMinAddress(), addressRange.getMaxAddress())) continue;
            AddressSet todoSubset = new AddressSet(addressRange);
            while (!todoSubset.isEmpty() && !this.monitor.isCancelled()) {
                block7: {
                    Address nextAddr = todoSubset.getMinAddress();
                    if (disassembledAddrs.contains(nextAddr)) {
                        AddressRange doneRange = disassembledAddrs.getRangeContaining(nextAddr);
                        todoSubset.delete(doneRange);
                        continue;
                    }
                    todoSubset.delete(nextAddr, nextAddr);
                    if (nextAddr.getOffset() % (long)alignment != 0L) continue;
                    Data data = this.listing.getUndefinedDataAt(nextAddr);
                    if (data == null) {
                        AddressSetView undefinedRanges = null;
                        try {
                            undefinedRanges = this.program.getListing().getUndefinedRanges(todoSubset, true, this.monitor);
                            todoSubset = new AddressSet(undefinedRanges);
                            break block7;
                        }
                        catch (CancelledException e) {
                            continue block2;
                        }
                    }
                    AddressSet currentSet = this.disassemble(nextAddr, restrictedSet, initialContextValue, doFollowFlow);
                    if (!currentSet.isEmpty()) {
                        todoSubset.delete(currentSet);
                        disassembledAddrs.add(currentSet);
                    }
                }
                if (!this.monitor.isCancelled()) continue;
                continue block2;
            }
        }
        return disassembledAddrs;
    }

    public AddressSet disassemble(Address startAddr, AddressSetView restrictedSet) {
        return this.disassemble(startAddr, restrictedSet, true);
    }

    public AddressSet disassemble(Address startAddr, AddressSetView restrictedSet, boolean doFollowFlow) {
        return this.disassemble(startAddr, restrictedSet, null, doFollowFlow);
    }

    public AddressSet disassemble(Address startAddr, AddressSetView restrictedSet, RegisterValue initialContextValue, boolean doFollowFlow) {
        RegisterValue initialValue;
        RegisterValue seedValue;
        if (this.program == null) {
            throw new UnsupportedOperationException("Method requires instantiation with a Program object");
        }
        this.followFlow = doFollowFlow;
        this.restrictedAddressSet = restrictedSet;
        if (initialContextValue != null && initialContextValue.getRegister().getBaseRegister() != this.baseContextRegister) {
            throw new IllegalArgumentException("Invalid initialContextValue");
        }
        AddressSet disassembledAddrs = new AddressSet();
        AddressSet reallyDisassembledAddrs = new AddressSet();
        int addressableUnitSize = startAddr.getAddressSpace().getAddressableUnitSize();
        if (this.instAlignment % addressableUnitSize != 0 || startAddr.getOffset() % (long)this.instAlignment != 0L) {
            this.reportMessage("Disassembly address " + startAddr + " violates " + this.instAlignment + "-byte instruction alignment");
            return reallyDisassembledAddrs;
        }
        this.disassemblerQueue = new DisassemblerQueue(startAddr, restrictedSet);
        DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.program.getMemory(), startAddr);
        DisassemblerContextImpl seed = this.seedContext;
        if (seed != null && (seedValue = seed.getFlowContextValue(startAddr, false)) != null) {
            this.disassemblerContext.setFutureRegisterValue(startAddr, seedValue);
        }
        if (initialContextValue != null && (initialValue = this.disassemblerContext.getFlowContextValue(startAddr, false)) != null) {
            initialValue = initialValue.combineValues(initialContextValue);
            this.disassemblerContext.setFutureRegisterValue(startAddr, initialValue);
        }
        while (this.disassemblerQueue.continueProducingInstructionSets(this.monitor)) {
            try {
                InstructionSet instructionSet;
                InstructionBlock nextBlock = this.disassemblerQueue.getNextBlockToBeDisassembled(null, this.program.getMemory(), null);
                if (nextBlock == null) break;
                Address blockAddr = nextBlock.getStartAddress();
                CodeUnit cu = this.listing.getCodeUnitAt(blockAddr);
                if (cu instanceof Instruction) continue;
                if (!(cu instanceof Data) || ((Data)cu).isDefined()) {
                    if (cu == null) {
                        cu = this.listing.getCodeUnitContaining(blockAddr);
                    }
                    if (cu != null) {
                        this.markCallConflict(blockAddr, blockAddr, cu);
                        continue;
                    }
                }
                if ((instructionSet = this.disassembleNextInstructionSet(nextBlock, memBuffer, disassembledAddrs)) == null) continue;
                if (instructionSet.getInstructionCount() != 0) {
                    AddressSetView newDisassembledAddrs = this.listing.addInstructions(instructionSet, false);
                    if (newDisassembledAddrs != null) {
                        if (this.doMarkUnimplPcode && !newDisassembledAddrs.isEmpty()) {
                            Disassembler.markUnimplementedPcode(this.program, newDisassembledAddrs, this.monitor);
                        }
                        reallyDisassembledAddrs.add(newDisassembledAddrs);
                    }
                    disassembledAddrs.add(instructionSet.getAddressSet());
                }
                this.disassemblerProgramContext.clearTemporaryContext();
                this.disassembleCount += this.disassemblerQueue.instructionSetAddedToProgram(instructionSet, this);
                if (this.disassembleCount < 1024) continue;
                this.totalCount += this.disassembleCount;
                this.monitor.setMessage("Disassembled  " + this.totalCount / 1024 + " K");
                this.disassembleCount = 0;
            }
            catch (CancelledException e) {
                break;
            }
            catch (CodeUnitInsertionException e) {
                Msg.error((Object)this, (Object)e.getMessage());
            }
        }
        return reallyDisassembledAddrs;
    }

    private InstructionSet disassembleNextInstructionSet(InstructionBlock firstBlock, DumbMemBufferImpl programMemBuffer, AddressSetView previouslyDisassembled) {
        InstructionBlock nextBlock;
        InstructionSet instructionSet = new InstructionSet(this.program.getAddressFactory());
        Address fallThruAddr = firstBlock.getStartAddress();
        while ((nextBlock = this.disassemblerQueue.getNextBlockToBeDisassembled(fallThruAddr, programMemBuffer.getMemory(), this.monitor)) != null) {
            Address blockAddr = this.disassemblerQueue.getDisassemblyAddress();
            if (!this.disassemblerContext.isFlowActive()) {
                this.disassemblerContext.flowStart(blockAddr);
            }
            programMemBuffer.setPosition(blockAddr);
            this.disassembleInstructionBlock(nextBlock, programMemBuffer, nextBlock.getFlowFromAddress(), this.instructionSetSizeLimit - instructionSet.getInstructionCount(), instructionSet, true);
            if (this.monitor.isCancelled()) break;
            if (nextBlock.isEmpty()) {
                if (nextBlock.hasInstructionError()) {
                    instructionSet.addBlock(nextBlock);
                }
                this.disassemblerContext.flowEnd(blockAddr);
                fallThruAddr = null;
            } else {
                instructionSet.addBlock(nextBlock);
                fallThruAddr = nextBlock.getFallThrough();
                if (fallThruAddr == null) {
                    this.disassemblerContext.flowEnd(nextBlock.getMaxAddress());
                }
            }
            if (instructionSet.getInstructionCount() < this.instructionSetSizeLimit) continue;
            break;
        }
        if (this.disassemblerContext.isFlowActive()) {
            this.disassemblerContext.flowAbort();
        }
        return instructionSet;
    }

    public void resetDisassemblerContext() {
        this.disassemblerProgramContext = new DisassemblerProgramContext();
        this.disassemblerContext = new DisassemblerContextImpl(this.disassemblerProgramContext);
    }

    public InstructionBlock pseudoDisassembleBlock(Address addr, RegisterValue defaultContextValue, int limit) {
        if (this.program == null) {
            throw new UnsupportedOperationException("Method requires instantiation with a Program object");
        }
        return this.pseudoDisassembleBlock(new DumbMemBufferImpl(this.program.getMemory(), addr), defaultContextValue, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstructionBlock pseudoDisassembleBlock(MemBuffer blockMemBuffer, RegisterValue defaultContextValue, int limit) {
        RegisterValue seedValue;
        Address startAddr = blockMemBuffer.getAddress();
        this.followFlow = false;
        int addressableUnitSize = startAddr.getAddressSpace().getAddressableUnitSize();
        if (this.instAlignment % addressableUnitSize != 0 || startAddr.getOffset() % (long)this.instAlignment != 0L) {
            this.reportMessage("Disassembly address " + startAddr + " violates " + this.instAlignment + "-byte instruction alignment");
            return null;
        }
        DisassemblerContextImpl seed = this.seedContext;
        if (seed != null && (seedValue = seed.getFlowContextValue(startAddr, false)) != null) {
            this.disassemblerContext.setFutureRegisterValue(startAddr, seedValue);
        }
        if (this.baseContextRegister != null && defaultContextValue != null) {
            RegisterValue defaultValue;
            RegisterValue registerValue = this.disassemblerContext.getRegisterValue(this.baseContextRegister, startAddr);
            if (registerValue != null && !registerValue.hasAnyValue()) {
                registerValue = null;
            }
            if ((defaultValue = this.disassemblerProgramContext.getDefaultValue(this.baseContextRegister, startAddr)) != null && !defaultValue.hasAnyValue()) {
                defaultValue = null;
            }
            if (SystemUtilities.isEqual((Object)registerValue, (Object)defaultValue)) {
                this.disassemblerContext.setFutureRegisterValue(startAddr, defaultContextValue);
            }
        }
        this.disassemblerContext.flowStart(startAddr);
        InstructionBlock block = new InstructionBlock(startAddr);
        boolean oldMarkBadInstructions = this.doMarkBadInstructions;
        boolean oldMarkUnimplementedPcode = this.doMarkUnimplPcode;
        this.doMarkBadInstructions = false;
        this.doMarkUnimplPcode = false;
        try {
            this.disassembleInstructionBlock(block, blockMemBuffer, null, limit, null, false);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Pseudo block disassembly failure at " + blockMemBuffer.getAddress() + ": " + e.getMessage()), (Throwable)e);
        }
        finally {
            Address fallThruAddr;
            this.doMarkBadInstructions = oldMarkBadInstructions;
            this.doMarkUnimplPcode = oldMarkUnimplementedPcode;
            if (block.isEmpty()) {
                this.disassemblerContext.flowAbort();
                return block;
            }
            if (this.baseContextRegister != null && (fallThruAddr = block.getFallThrough()) != null) {
                this.disassemblerContext.copyToFutureFlowState(fallThruAddr);
            }
            this.disassemblerContext.flowEnd(block.getMaxAddress());
        }
        return block;
    }

    private boolean delaySlottedInstructionHasFallthrough(Instruction dsInstr, InstructionBlock existingBlock) {
        while (dsInstr != null && dsInstr.isInDelaySlot()) {
            dsInstr = existingBlock.getInstructionAt(dsInstr.getMaxAddress().next());
        }
        return dsInstr != null;
    }

    private void setMemoryConstraintError(InstructionBlock block, Address flowFrom) {
        Address startAddr = block.getStartAddress();
        MemoryBlock memBlock = this.program.getMemory().getBlock(startAddr);
        if (memBlock != null) {
            if ("EXTERNAL".equals(memBlock.getName())) {
                return;
            }
            String reason = !memBlock.isLoaded() ? "non-loaded" : (memBlock.isInitialized() ? "non-execute" : (memBlock.isMapped() ? "mapped" : "uninitialized"));
            String message = "Disassembly not permitted within " + reason + " memory block";
            block.setInstructionMemoryError(startAddr, flowFrom, message);
        } else {
            block.setInstructionMemoryError(startAddr, flowFrom, "Could not follow disassembly flow into non-existing memory at " + startAddr);
        }
    }

    protected void disassembleInstructionBlock(InstructionBlock block, MemBuffer blockMemBuffer, Address flowFrom, int limit, InstructionSet instructionSet, boolean skipIfBlockAlreadyDisassembled) {
        InstructionBlock existingBlock;
        Address addr = blockMemBuffer.getAddress();
        this.repeatInstructionByteTracker.reset();
        if (this.initializedAddressSet != null && !this.initializedAddressSet.contains(addr)) {
            this.setMemoryConstraintError(block, flowFrom);
            return;
        }
        Instruction existingBlockStartInstr = null;
        if (skipIfBlockAlreadyDisassembled && (existingBlock = instructionSet.getInstructionBlockContaining(addr)) != null && !existingBlock.isEmpty()) {
            existingBlockStartInstr = existingBlock.getInstructionAt(addr);
            if (existingBlockStartInstr == null) {
                existingBlockStartInstr = existingBlock.findFirstIntersectingInstruction(addr, addr);
                block.setCodeUnitConflict(existingBlockStartInstr.getAddress(), addr, flowFrom, true, true);
                return;
            }
            if (existingBlockStartInstr.isInDelaySlot() && !this.delaySlottedInstructionHasFallthrough(existingBlockStartInstr, existingBlock)) {
                block = existingBlock;
                addr = existingBlock.getMaxAddress().next();
                existingBlockStartInstr = null;
            }
        }
        try {
            while (!this.monitor.isCancelled() && addr != null) {
                PseudoInstruction badInst;
                InstructionPrototype existingProto;
                if (this.restrictedAddressSet != null && !this.restrictedAddressSet.contains(addr)) {
                    return;
                }
                this.disassemblerContext.flowToAddress(addr);
                WrappedMemBuffer instrMemBuffer = new WrappedMemBuffer(blockMemBuffer, 8, (int)addr.subtract(blockMemBuffer.getAddress()));
                this.adjustPreParseContext(instrMemBuffer);
                RegisterValue contextValue = null;
                if (this.baseContextRegister != null) {
                    contextValue = this.disassemblerContext.getRegisterValue(this.baseContextRegister);
                }
                InstructionPrototype prototype = this.language.parse(instrMemBuffer, this.disassemblerContext, false);
                if (!block.isEmpty() && instructionSet != null && instructionSet.containsBlockAt(addr) && (existingBlockStartInstr = instructionSet.getInstructionAt(addr)) != null) {
                    existingProto = existingBlockStartInstr.getPrototype();
                    if (!existingProto.equals(prototype)) {
                        badInst = this.getPseudoInstruction(addr, prototype, instrMemBuffer, contextValue, block);
                        InstructionError.dumpInstructionDifference(badInst, existingBlockStartInstr);
                        block.setInconsistentPrototypeConflict(addr, flowFrom);
                    }
                    return;
                }
                if (skipIfBlockAlreadyDisassembled && block.isEmpty()) {
                    if (existingBlockStartInstr == null) {
                        existingBlockStartInstr = this.listing.getInstructionAt(addr);
                    }
                    if (existingBlockStartInstr != null) {
                        existingProto = existingBlockStartInstr.getPrototype();
                        if (existingProto.isInDelaySlot()) {
                            prototype = this.language.parse(instrMemBuffer, this.disassemblerContext, true);
                            if (existingProto.equals(prototype)) {
                                this.disassemblerContext.copyToFutureFlowState(addr);
                                if (this.disassemblerQueue != null) {
                                    this.disassemblerQueue.queueDelaySlotFallthrough(existingBlockStartInstr);
                                }
                                return;
                            }
                        } else if (existingProto.equals(prototype)) {
                            return;
                        }
                        badInst = this.getPseudoInstruction(addr, prototype, instrMemBuffer, contextValue, block);
                        InstructionError.dumpInstructionDifference(badInst, existingBlockStartInstr);
                        block.setInconsistentPrototypeConflict(addr, flowFrom);
                    }
                }
                PseudoInstruction inst = this.getPseudoInstruction(addr, prototype, instrMemBuffer, contextValue, block);
                Address maxAddr = inst.getMaxAddress();
                if (instructionSet != null && instructionSet.intersects(addr, maxAddr)) {
                    InstructionBlock existingBlock2 = instructionSet.getInstructionBlockContaining(addr);
                    Instruction existingInstr = null;
                    if (existingBlock2 != null) {
                        existingInstr = existingBlock2.getInstructionAt(addr);
                    }
                    if (existingInstr == null) {
                        if (existingBlock2 == null) {
                            existingBlock2 = instructionSet.findFirstIntersectingBlock(addr, maxAddr);
                        }
                        existingInstr = existingBlock2.findFirstIntersectingInstruction(addr, maxAddr);
                        block.setCodeUnitConflict(existingInstr.getAddress(), addr, flowFrom, true, true);
                    } else {
                        InstructionPrototype existingProto2 = existingInstr.getPrototype();
                        if (existingInstr.isInDelaySlot()) {
                            prototype = this.language.parse(instrMemBuffer, this.disassemblerContext, true);
                        }
                        if (!existingProto2.equals(prototype)) {
                            PseudoInstruction badInst2 = this.getPseudoInstruction(addr, prototype, instrMemBuffer, contextValue, block);
                            InstructionError.dumpInstructionDifference(badInst2, existingBlockStartInstr);
                            block.setInconsistentPrototypeConflict(addr, flowFrom);
                        }
                    }
                    return;
                }
                if (this.repeatInstructionByteTracker.exceedsRepeatBytePattern(inst)) {
                    block.setParseConflict(addr, contextValue, flowFrom, "Maximum run of repeated byte instructions exceeded");
                }
                if ((addr = this.processInstruction(inst, blockMemBuffer, block, instructionSet)) == null || block.hasInstructionError()) {
                    return;
                }
                if (this.endBlockEarly(inst, addr, limit, block) || this.endBlockOnCall(inst, addr, block)) {
                    this.disassemblerContext.copyToFutureFlowState(addr);
                    return;
                }
                flowFrom = inst.getMinAddress();
            }
        }
        catch (AddressOutOfBoundsException | AddressOverflowException e) {
            block.setInstructionMemoryError(addr, flowFrom, "Instruction does not fit within address space constraint");
        }
        catch (InsufficientBytesException e) {
            block.setInstructionMemoryError(addr, flowFrom, e.getMessage());
        }
        catch (UnknownInstructionException e) {
            block.setParseConflict(addr, this.disassemblerContext.getRegisterValue(this.disassemblerContext.getBaseContextRegister()), flowFrom, e.getMessage());
        }
    }

    private boolean endBlockEarly(Instruction inst, Address fallThruAddr, int limit, InstructionBlock block) {
        if (fallThruAddr == null) {
            return false;
        }
        if (block.getInstructionCount() >= limit && this.isBlockTerminationOK(inst) || this.initializedAddressSet != null && !this.initializedAddressSet.contains(fallThruAddr)) {
            this.disassemblerContext.copyToFutureFlowState(fallThruAddr);
            block.addBlockFlow(new InstructionBlockFlow(fallThruAddr, inst.getAddress(), InstructionBlockFlow.Type.PRIORITY));
            return true;
        }
        return false;
    }

    private boolean endBlockOnCall(Instruction inst, Address fallThruAddr, InstructionBlock block) {
        if (fallThruAddr == null || !inst.getFlowType().isCall() || !this.isBlockTerminationOK(inst)) {
            return false;
        }
        this.disassemblerContext.copyToFutureFlowState(fallThruAddr);
        InstructionBlockFlow fallThrough = new InstructionBlockFlow(fallThruAddr, inst.getAddress(), InstructionBlockFlow.Type.CALL_FALLTHROUGH);
        if (this.disassemblerQueue != null) {
            this.disassemblerQueue.queueCurrentFlow(fallThrough);
        }
        block.addBlockFlow(fallThrough);
        block.addBranchFlow(fallThruAddr);
        return true;
    }

    protected void adjustPreParseContext(MemBuffer instrMemBuffer) throws UnknownInstructionException {
    }

    protected PseudoInstruction getPseudoInstruction(Address addr, InstructionPrototype prototype, MemBuffer memBuffer, RegisterValue contextValue, InstructionBlock block) throws AddressOverflowException {
        PseudoInstruction instr = this.program != null ? new PseudoInstruction(this.program, addr, prototype, memBuffer, this.disassemblerProgramContext.getInstructionContext(contextValue, addr, prototype.getLength())) : new PseudoInstruction(this.addrFactory, addr, prototype, memBuffer, this.disassemblerProgramContext.getInstructionContext(contextValue, addr, prototype.getLength()));
        instr.setInstructionBlock(block);
        return instr;
    }

    protected boolean isBlockTerminationOK(Instruction instr) {
        return this.parallelHelper == null || this.parallelHelper.isEndOfParallelInstructionGroup(instr);
    }

    protected Address processInstruction(PseudoInstruction inst, MemBuffer blockMemBuffer, InstructionBlock block, InstructionSet instructionSet) throws InsufficientBytesException, UnknownInstructionException, AddressOverflowException, NestedDelaySlotException {
        List<PseudoInstruction> delaySlotList = this.parseDelaySlots(inst, blockMemBuffer, block);
        if (this.followFlow) {
            this.processInstructionFlows(inst, block);
        }
        block.addInstruction(inst);
        if (delaySlotList != null) {
            for (PseudoInstruction dsInstr : delaySlotList) {
                block.addInstruction(dsInstr);
                dsInstr.setInstructionBlock(block);
            }
        }
        if (!inst.hasFallthrough()) {
            return null;
        }
        return block.getMaxAddress().next();
    }

    private void processInstructionFlows(PseudoInstruction inst, InstructionBlock block) {
        Address[] flowAddrs = inst.getFlows();
        FlowType flowType = inst.getFlowType();
        Address instAddr = inst.getMinAddress();
        if (flowAddrs.length == 0 && flowType.isCall()) {
            this.checkForIndirectCallFlow(inst, flowType);
        }
        for (Address flowAddr : flowAddrs) {
            if (flowAddrs.length == 1 && flowType.isCall() && this.isNoReturnCall(inst, flowAddr)) {
                inst.setFlowOverride(FlowOverride.CALL_RETURN);
                continue;
            }
            if (flowAddr.getOffset() % (long)this.instAlignment != 0L) {
                block.setInstructionError(InstructionError.InstructionErrorType.FLOW_ALIGNMENT, instAddr, null, null, "Flow destination address " + flowAddr + " from " + instAddr + " violates " + this.instAlignment + "-byte instruction alignment");
                continue;
            }
            this.disassemblerContext.copyToFutureFlowState(flowAddr);
            if (flowType.isCall()) {
                block.addBlockFlow(new InstructionBlockFlow(flowAddr, instAddr, InstructionBlockFlow.Type.CALL));
                continue;
            }
            InstructionBlockFlow branchFlow = new InstructionBlockFlow(flowAddr, instAddr, InstructionBlockFlow.Type.BRANCH);
            if (this.disassemblerQueue != null) {
                this.disassemblerQueue.queueCurrentFlow(branchFlow);
            }
            block.addBlockFlow(branchFlow);
            block.addBranchFlow(flowAddr);
        }
    }

    private void checkForIndirectCallFlow(PseudoInstruction inst, FlowType flowType) {
        if (!flowType.isComputed() || flowType.isConditional()) {
            return;
        }
        for (int opIndex = 0; opIndex < inst.getNumOperands(); ++opIndex) {
            Function refFunc;
            Address addr;
            RefType operandRefType = inst.getOperandRefType(opIndex);
            if (!operandRefType.isIndirect() || (addr = inst.getAddress(opIndex)) == null || (refFunc = this.program.getFunctionManager().getReferencedFunction(addr)) == null || !refFunc.hasNoReturn()) continue;
            inst.setFlowOverride(FlowOverride.CALL_RETURN);
            break;
        }
    }

    private List<PseudoInstruction> parseDelaySlots(Instruction inst, MemBuffer blockMemBuffer, InstructionBlock block) throws NestedDelaySlotException {
        Address instAddr;
        int minDelaySlotBytes = inst.getPrototype().getDelaySlotByteCount();
        if (minDelaySlotBytes == 0) {
            return null;
        }
        if (inst.isInDelaySlot()) {
            throw new NestedDelaySlotException();
        }
        Address addr = instAddr = inst.getMinAddress();
        int length = inst.getLength();
        ArrayList<PseudoInstruction> instrList = new ArrayList<PseudoInstruction>();
        try {
            while (minDelaySlotBytes > 0) {
                PseudoInstruction dsInstr;
                try {
                    addr = addr.addNoWrap(length);
                }
                catch (AddressOverflowException e) {
                    block.setInstructionMemoryError(addr, inst.getAddress(), "Failed to properly process delay slot at end of address space");
                    break;
                }
                this.disassemblerContext.flowToAddress(addr);
                WrappedMemBuffer dsInstrMemBuffer = new WrappedMemBuffer(blockMemBuffer, (int)addr.subtract(blockMemBuffer.getAddress()));
                InstructionPrototype prototype = this.language.parse(dsInstrMemBuffer, this.disassemblerContext, true);
                RegisterValue contextValue = null;
                if (this.baseContextRegister != null) {
                    contextValue = this.disassemblerContext.getRegisterValue(this.baseContextRegister);
                }
                if (this.repeatInstructionByteTracker.exceedsRepeatBytePattern(dsInstr = this.getPseudoInstruction(addr, prototype, dsInstrMemBuffer, contextValue, block))) {
                    block.setParseConflict(addr, contextValue, instAddr, "Maximum run of repeated byte instructions exceeded");
                }
                instrList.add(dsInstr);
                length = dsInstr.getLength();
                minDelaySlotBytes -= length;
            }
            return instrList;
        }
        catch (NestedDelaySlotException e) {
            throw e;
        }
        catch (AddressOutOfBoundsException | AddressOverflowException e) {
            block.setInstructionMemoryError(addr, instAddr, "Instruction does not fit within address space constraint");
        }
        catch (InsufficientBytesException e) {
            block.setInstructionMemoryError(addr, instAddr, e.getMessage());
        }
        catch (UnknownInstructionException e) {
            block.setParseConflict(addr, this.disassemblerContext.getRegisterValue(this.disassemblerContext.getBaseContextRegister()), instAddr, e.getMessage());
        }
        return null;
    }

    private boolean isNoReturnCall(Instruction instr, Address target) {
        if (this.program == null) {
            return false;
        }
        Function func = this.program.getFunctionManager().getFunctionAt(target);
        if (func == null) {
            return false;
        }
        if (func.hasNoReturn()) {
            return true;
        }
        String callFixupStr = func.getCallFixup();
        if (callFixupStr == null || callFixupStr.length() == 0) {
            return false;
        }
        PcodeInjectLibrary pcodeInjectLibrary = this.program.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload callFixup = pcodeInjectLibrary.getPayload(1, callFixupStr, this.program, null);
        if (callFixup == null) {
            return false;
        }
        return !callFixup.isFallThru();
    }

    @Override
    public void markInstructionError(InstructionError conflict) {
        RegisterValue contextValue;
        Address address = conflict.getInstructionAddress();
        if (conflict.getInstructionErrorType() == InstructionError.InstructionErrorType.PARSE && (contextValue = conflict.getParseContextValue()) != null) {
            try {
                this.program.getProgramContext().setRegisterValue(address, address, contextValue);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
        if (!this.doMarkBadInstructions || conflict.getInstructionErrorType() == InstructionError.InstructionErrorType.DUPLICATE) {
            return;
        }
        Address flowFrom = conflict.getFlowFromAddress();
        Object flowMsg = flowFrom != null ? " (flow from " + flowFrom + ")" : "";
        Address markAddr = address;
        if (!this.isBookmarkAllowed(markAddr)) {
            if (flowFrom != null) {
                markAddr = flowFrom;
            } else {
                return;
            }
        }
        this.bmMgr.setBookmark(markAddr, "Error", ERROR_BOOKMARK_CATEGORY, conflict.getConflictMessage() + (String)flowMsg);
    }

    private boolean isBookmarkAllowed(Address addr) {
        MemoryBlock memBlock = this.program.getMemory().getBlock(addr);
        if (memBlock != null) {
            return memBlock.isInitialized();
        }
        return false;
    }

    private void markCallConflict(Address address, Address flowFrom, CodeUnit conflictCodeUnit) {
        if (!this.doMarkBadInstructions) {
            return;
        }
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block != null && !block.isInitialized()) {
            return;
        }
        Object flowMsg = flowFrom != null ? " (flow from " + flowFrom + ")" : "";
        this.bmMgr.setBookmark(address, "Error", ERROR_BOOKMARK_CATEGORY, "Failed to disassemble at " + address + " due to conflicting " + (conflictCodeUnit instanceof Instruction ? "instruction" : "data") + (String)flowMsg);
    }

    private static void markUnimplementedPcode(Instruction instr) {
        BookmarkManager bmMgr = instr.getProgram().getBookmarkManager();
        bmMgr.setBookmark(instr.getAddress(), "Warning", UNIMPL_BOOKMARK_CATEGORY, "Instruction pcode is unimplemented: " + instr.getMnemonicString());
    }

    public static void markUnimplementedPcode(Program program, AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        InstructionIterator instructions;
        Listing listing = program.getListing();
        InstructionIterator instructionIterator = instructions = addressSet == null ? listing.getInstructions(true) : listing.getInstructions(addressSet, true);
        while (instructions.hasNext()) {
            Instruction instr = instructions.next();
            PcodeOp[] pcode = instr.getPcode();
            if (pcode == null || pcode.length != 1 || pcode[0].getOpcode() != 0) continue;
            Disassembler.markUnimplementedPcode(instr);
        }
    }

    public static void clearUnimplementedPcodeWarnings(Program program, AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        BookmarkManager bmMgr = program.getBookmarkManager();
        if (addressSet == null) {
            bmMgr.removeBookmarks("Warning", UNIMPL_BOOKMARK_CATEGORY, monitor);
        } else {
            bmMgr.removeBookmarks(addressSet, "Warning", UNIMPL_BOOKMARK_CATEGORY, monitor);
        }
    }

    public static void clearBadInstructionErrors(Program program, AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        BookmarkManager bmMgr = program.getBookmarkManager();
        if (addressSet == null) {
            bmMgr.removeBookmarks("Error", ERROR_BOOKMARK_CATEGORY, monitor);
        } else {
            bmMgr.removeBookmarks(addressSet, "Error", ERROR_BOOKMARK_CATEGORY, monitor);
        }
    }

    private void reportMessage(String msg) {
        if (this.listener != null) {
            this.listener.disassembleMessageReported(msg);
        }
    }

    private static Class<? extends Disassembler> getLanguageSpecificDisassembler(Language parser) {
        String className = parser.getProperty("customDisassemblerClass");
        if (className == null) {
            return null;
        }
        try {
            Class<?> disassemblerClass = Class.forName(className);
            if (!Disassembler.class.isAssignableFrom(disassemblerClass)) {
                Msg.error(Disassembler.class, (Object)("Invalid Class specified for customDisassemblerClass (" + disassemblerClass.getName() + "): " + parser.getLanguageDescription().getLanguageID()));
                return null;
            }
            return disassemblerClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid Class specified for customDisassemblerClass (" + className + "): " + parser.getLanguageDescription().getLanguageID(), e);
        }
    }

    private static class InstructionContext
    implements ProcessorContext {
        private RegisterValue contextValue;
        private Language langauge;

        InstructionContext(Language language, RegisterValue contextValue) {
            this.langauge = language;
            this.contextValue = contextValue;
        }

        RegisterValue getContextValue() {
            return this.contextValue;
        }

        @Override
        public Register getBaseContextRegister() {
            return this.contextValue != null ? this.contextValue.getRegister().getBaseRegister() : null;
        }

        @Override
        public List<Register> getRegisters() {
            return this.langauge.getRegisters();
        }

        @Override
        public Register getRegister(String name) {
            return this.langauge.getRegister(name);
        }

        @Override
        public BigInteger getValue(Register register, boolean signed) {
            if (this.contextValue != null && register.isProcessorContext()) {
                return this.contextValue.getRegisterValue(register).getUnsignedValue();
            }
            return null;
        }

        @Override
        public RegisterValue getRegisterValue(Register register) {
            if (this.contextValue != null && register.isProcessorContext()) {
                return this.contextValue.getRegisterValue(register);
            }
            return null;
        }

        @Override
        public boolean hasValue(Register register) {
            return this.getRegisterValue(register).hasValue();
        }

        @Override
        public void setValue(Register register, BigInteger value) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRegisterValue(RegisterValue value) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearRegister(Register register) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }
    }

    protected class DisassemblerProgramContext
    extends AbstractProgramContext {
        private AddressRangeObjectMap<RegisterValue> temporaryContextMap;
        private InstructionContext instructionContextCache;

        DisassemblerProgramContext() {
            super(Disassembler.this.language);
            this.temporaryContextMap = new AddressRangeObjectMap();
            this.instructionContextCache = null;
            if (Disassembler.this.realProgramContext != null) {
                this.setDefaultDisassemblyContext(Disassembler.this.realProgramContext.getDefaultDisassemblyContext());
            }
        }

        ProcessorContext getInstructionContext(RegisterValue value, Address instrAddr, int instrLength) {
            if (value == null) {
                if (this.instructionContextCache == null) {
                    this.instructionContextCache = new InstructionContext(Disassembler.this.language, null);
                }
                return this.instructionContextCache;
            }
            if (this.instructionContextCache == null || !SystemUtilities.isEqual((Object)value, (Object)this.instructionContextCache.getContextValue())) {
                this.instructionContextCache = new InstructionContext(Disassembler.this.language, value);
            }
            Address maxAddr = instrAddr.add(instrLength - 1);
            this.temporaryContextMap.setObject(instrAddr, maxAddr, value);
            return this.instructionContextCache;
        }

        void clearTemporaryContext() {
            this.temporaryContextMap.clearAll();
        }

        @Override
        public Register[] getRegistersWithValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getValue(Register register, Address address, boolean signed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RegisterValue getRegisterValue(Register register, Address address) {
            RegisterValue value = this.temporaryContextMap.getObject(address);
            if (value == null) {
                value = Disassembler.this.realProgramContext != null ? Disassembler.this.realProgramContext.getRegisterValue(register, address) : Disassembler.this.defaultLanguageContext.getDefaultValue(register, address);
            }
            return value;
        }

        @Override
        public void setRegisterValue(Address start, Address end, RegisterValue value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RegisterValue getNonDefaultValue(Register register, Address address) {
            RegisterValue value = this.temporaryContextMap.getObject(address);
            if (value == null && Disassembler.this.realProgramContext != null) {
                value = Disassembler.this.realProgramContext.getNonDefaultValue(register, address);
            }
            return value;
        }

        @Override
        public void setValue(Register register, Address start, Address end, BigInteger value) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public AddressRangeIterator getRegisterValueAddressRanges(Register register) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AddressRangeIterator getRegisterValueAddressRanges(Register register, Address start, Address end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AddressRange getRegisterValueRangeContaining(Register register, Address addr) {
            AddressRange tempValueRange = this.temporaryContextMap.getAddressRangeContaining(addr);
            if (Disassembler.this.realProgramContext == null) {
                return tempValueRange;
            }
            AddressRange realValueRange = Disassembler.this.realProgramContext.getRegisterValueRangeContaining(register, addr);
            if (tempValueRange.getMaxAddress().compareTo(realValueRange.getMaxAddress()) < 0) {
                return tempValueRange;
            }
            return realValueRange;
        }

        @Override
        public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register, Address start, Address end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Address start, Address end, Register register) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasValueOverRange(Register reg, BigInteger value, AddressSetView addrSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RegisterValue getDefaultValue(Register register, Address address) {
            if (Disassembler.this.realProgramContext != null) {
                return Disassembler.this.realProgramContext.getDefaultValue(register, address);
            }
            return Disassembler.this.defaultLanguageContext.getDefaultValue(register, address);
        }

        @Override
        public RegisterValue getDisassemblyContext(Address address) {
            RegisterValue value = this.temporaryContextMap.getObject(address);
            if (value == null) {
                if (Disassembler.this.realProgramContext != null) {
                    value = Disassembler.this.realProgramContext.getDisassemblyContext(address);
                } else if (this.baseContextRegister != null) {
                    value = Disassembler.this.defaultLanguageContext.getDefaultValue(this.baseContextRegister, address);
                }
            }
            return value;
        }
    }
}

