/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.external.ExternalLocationDB;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Lock;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class SymbolDB
extends DatabaseObject
implements Symbol {
    private Record record;
    private boolean isDeleting = false;
    protected Address address;
    protected SymbolManager symbolMgr;
    protected Lock lock;
    private volatile String cachedName;
    private volatile long cachedNameModCount;

    static SymbolDB createSymbolPlaceholder(SymbolManager manager, Address address, long id) {
        return new PlaceholderSymbolDB(manager, address, id);
    }

    SymbolDB(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, Address address, Record record) {
        super(cache, record.getKey());
        this.symbolMgr = symbolMgr;
        this.address = address;
        this.record = record;
        this.lock = symbolMgr.getLock();
    }

    SymbolDB(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, Address address, long key) {
        super(cache, key);
        this.symbolMgr = symbolMgr;
        this.address = address;
        this.lock = symbolMgr.getLock();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(Record rec) {
        if (this.record != null) {
            if (rec == null) {
                rec = this.symbolMgr.getSymbolRecord(this.key);
            }
            if (rec == null || this.record.getByteValue(3) != rec.getByteValue(3)) {
                return false;
            }
            this.record = rec;
            this.address = this.symbolMgr.getAddressMap().decodeAddress(rec.getLongValue(1));
            return true;
        }
        return false;
    }

    @Override
    public Address getAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.address;
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    protected void setAddress(Address addr) {
        if (!(this instanceof VariableSymbolDB)) {
            throw new IllegalArgumentException("Address setable for variables only");
        }
        ProgramDB program = this.symbolMgr.getProgram();
        this.record.setLongValue(1, program.getAddressMap().getKey(addr, true));
        this.updateRecord();
        Address oldAddr = this.address;
        this.address = addr;
        program.symbolChanged(this, 53, oldAddr, this, oldAddr, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(Address oldBase, Address newBase) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (!oldBase.getAddressSpace().equals(this.address.getAddressSpace())) {
                return;
            }
            ProgramDB program = this.symbolMgr.getProgram();
            Address oldAddress = this.address;
            long diff = this.address.subtract(oldBase);
            this.address = newBase.addWrap(diff);
            this.record.setLongValue(1, program.getAddressMap().getKey(this.address, true));
            this.updateRecord();
            this.symbolMgr.moveLabelHistory(oldAddress, this.address);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public final String getName() {
        String name = this.cachedName;
        if (this.hasValidCachedName(name)) {
            return name;
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.cachedName = this.doGetName();
            this.cachedNameModCount = this.symbolMgr.getProgram().getModificationNumber();
            String string = this.cachedName;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    private boolean hasValidCachedName(String name) {
        if (name == null) {
            return false;
        }
        return this.symbolMgr.getProgram().getModificationNumber() == this.cachedNameModCount;
    }

    protected String doGetName() {
        if (this.record != null) {
            return this.record.getString(0);
        }
        return SymbolUtilities.getDynamicName(this.symbolMgr.getProgram(), this.address);
    }

    @Override
    public Program getProgram() {
        return this.symbolMgr.getProgram();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(boolean includeNamespace) {
        this.lock.acquire();
        try {
            Namespace ns;
            this.checkIsValid();
            Object symName = this.getName();
            if (includeNamespace && !((ns = this.getParentNamespace()) instanceof GlobalNamespace)) {
                String nsPath = ns.getName(true);
                symName = nsPath + "::" + (String)symName;
            }
            String string = symName;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    private void fillListWithNamespacePath(Namespace namespace, ArrayList<String> list) {
        Namespace parentNamespace = namespace.getParentNamespace();
        if (parentNamespace != null && parentNamespace.getID() != 0L) {
            this.fillListWithNamespacePath(parentNamespace, list);
        }
        list.add(namespace.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPath() {
        this.lock.acquire();
        try {
            String[] path;
            this.checkIsValid();
            ArrayList<String> list = new ArrayList<String>();
            this.fillListWithNamespacePath(this.getParentNamespace(), list);
            list.add(this.getName());
            String[] stringArray = path = list.toArray(new String[list.size()]);
            return stringArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReferenceCount() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            boolean isPrimary = this.isPrimary();
            Symbol[] symbols = this.symbolMgr.getSymbols(this.address);
            if (symbols.length == 1) {
                int n = rm.getReferenceCountTo(this.address);
                return n;
            }
            int count = 0;
            while (iter.hasNext()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L)) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference[] getReferences(TaskMonitor monitor) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (monitor == null) {
                monitor = TaskMonitor.DUMMY;
            }
            if (monitor.getMaximum() == 0L) {
                monitor = new UnknownProgressWrappingTaskMonitor(monitor, 20L);
            }
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            boolean isPrimary = this.isPrimary();
            ArrayList<Reference> list = new ArrayList<Reference>();
            int cnt = 0;
            while (iter.hasNext() && !monitor.isCancelled()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L)) continue;
                list.add(ref);
                monitor.setProgress((long)cnt++);
            }
            Reference[] refs = new Reference[list.size()];
            Reference[] referenceArray = list.toArray(refs);
            return referenceArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Reference[] getReferences() {
        return this.getReferences(TaskMonitor.DUMMY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMultipleReferences() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            boolean isPrimary = this.isPrimary();
            int count = 0;
            while (iter.hasNext()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L) || ++count <= 1) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasReferences() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            boolean isPrimary = this.isPrimary();
            while (iter.hasNext()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isDynamic() {
        return this.record == null;
    }

    @Override
    public boolean isExternalEntryPoint() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.symbolMgr.isExternalEntryPoint(this.address);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public abstract boolean isPrimary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSource(SourceType newSource) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.symbolMgr.validateSource(this.getName(), this.getAddress(), this.getSymbolType(), newSource);
            SourceType oldSource = this.getSource();
            if (newSource == oldSource) {
                return;
            }
            if (newSource == SourceType.DEFAULT || oldSource == SourceType.DEFAULT) {
                String msg = "Can't change between DEFAULT and non-default symbol. Symbol is " + this.getName() + " @ " + this.getAddress().toString() + ".";
                throw new IllegalArgumentException(msg);
            }
            if (this.record != null) {
                byte flags = this.record.getByteValue(7);
                int clearBits = 3;
                byte setBits = (byte)newSource.ordinal();
                flags = (byte)(flags & ~clearBits);
                flags = (byte)(flags | setBits);
                this.record.setByteValue(7, flags);
                this.updateRecord();
                this.symbolMgr.symbolSourceChanged(this);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceType getSource() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                SourceType sourceType = SourceType.DEFAULT;
                return sourceType;
            }
            int sourceBits = 3;
            byte flags = this.record.getByteValue(7);
            byte adapterSource = (byte)(flags & sourceBits);
            SourceType sourceType = SourceType.values()[adapterSource];
            return sourceType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isPinned() {
        return false;
    }

    protected boolean doIsPinned() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                boolean bl = false;
                return bl;
            }
            byte flags = this.record.getByteValue(7);
            boolean bl = (flags & 4) != 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setPinned(boolean pinned) {
        throw new UnsupportedOperationException("Only Code Symbols may be pinned.");
    }

    protected void doSetPinned(boolean pinned) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (pinned == this.isPinned()) {
                return;
            }
            if (this.record != null) {
                byte flags = this.record.getByteValue(7);
                flags = pinned ? (byte)(flags | 4) : (byte)(flags & 0xFFFFFFFB);
                this.record.setByteValue(7, flags);
                this.updateRecord();
                this.symbolMgr.symbolAnchoredFlagChanged(this);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setName(String newName, SourceType source) throws DuplicateNameException, InvalidInputException {
        try {
            this.setNameAndNamespace(newName, this.getParentNamespace(), source);
        }
        catch (CircularDependencyException circularDependencyException) {
            // empty catch block
        }
    }

    @Override
    public void setNamespace(Namespace newNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.setNameAndNamespace(this.getName(), newNamespace, this.getSource());
    }

    protected SourceType validateNameSource(String newName, SourceType source) {
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNameAndNamespace(String newName, Namespace newNamespace, SourceType source) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.lock.acquire();
        try {
            boolean namespaceChange;
            this.checkDeleted();
            this.checkEditOK();
            source = this.validateNameSource(newName, source);
            this.symbolMgr.validateSource(newName, this.getAddress(), this.getSymbolType(), source);
            Namespace oldNamespace = this.getParentNamespace();
            boolean bl = namespaceChange = !oldNamespace.equals(newNamespace);
            if (namespaceChange) {
                if (!this.isValidParent(newNamespace)) {
                    throw new InvalidInputException("Namespace \"" + newNamespace.getName(true) + "\" is not valid for symbol " + this.getName());
                }
                if (this.isDescendant(newNamespace)) {
                    throw new CircularDependencyException("Namespace \"" + newNamespace.getName(true) + "\" is a descendant of symbol " + this.getName());
                }
            }
            boolean nameChange = true;
            String oldName = this.getName();
            SourceType oldSource = this.getSource();
            if (source == SourceType.DEFAULT) {
                if (this.getSource() == SourceType.DEFAULT && !namespaceChange) {
                    return;
                }
                newName = "";
            } else {
                SymbolUtilities.validateName(newName);
                boolean bl2 = nameChange = !oldName.equals(newName);
                if (!namespaceChange && !nameChange) {
                    return;
                }
                this.symbolMgr.checkDuplicateSymbolName(this.address, newName, newNamespace, this.getSymbolType());
            }
            if (this.record != null) {
                List<SymbolDB> dynamicallyRenamedSymbols = this.getSymbolsDynamicallyRenamedByMyRename();
                ArrayList<String> oldDynamicallyRenamedSymbolNames = null;
                if (dynamicallyRenamedSymbols != null) {
                    oldDynamicallyRenamedSymbolNames = new ArrayList<String>(dynamicallyRenamedSymbols.size());
                    for (Symbol symbol : dynamicallyRenamedSymbols) {
                        oldDynamicallyRenamedSymbolNames.add(symbol.getName());
                    }
                }
                this.record.setLongValue(2, newNamespace.getID());
                this.record.setString(0, newName);
                this.updateSymbolSource(this.record, source);
                this.updateRecord();
                this.cachedName = null;
                if (namespaceChange) {
                    this.symbolMgr.symbolNamespaceChanged(this, oldNamespace);
                }
                if (nameChange) {
                    SymbolType symbolType = this.getSymbolType();
                    if (this.isExternal() && (symbolType == SymbolType.FUNCTION || symbolType == SymbolType.LABEL)) {
                        ExternalManagerDB externalManagerDB = this.symbolMgr.getExternalManager();
                        ExternalLocationDB externalLocation = (ExternalLocationDB)externalManagerDB.getExternalLocation(this);
                        externalLocation.saveOriginalNameIfNeeded(oldNamespace, oldName, oldSource);
                    }
                    this.symbolMgr.symbolRenamed(this, oldName);
                    if (dynamicallyRenamedSymbols != null) {
                        ProgramDB programDB = this.symbolMgr.getProgram();
                        for (int i = 0; i < dynamicallyRenamedSymbols.size(); ++i) {
                            Symbol s = dynamicallyRenamedSymbols.get(i);
                            programDB.symbolChanged(s, 46, s.getAddress(), s, oldDynamicallyRenamedSymbolNames.get(i), s.getName());
                        }
                    }
                }
            } else {
                this.symbolMgr.convertDynamicSymbol(this, newName, newNamespace.getID(), source);
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected List<SymbolDB> getSymbolsDynamicallyRenamedByMyRename() {
        return null;
    }

    private void checkEditOK() throws InvalidInputException {
        if (this.getSymbolType() == SymbolType.LABEL) {
            for (Register reg : this.symbolMgr.getProgram().getRegisters(this.getAddress())) {
                if (!reg.getName().equals(this.getName())) continue;
                throw new InvalidInputException("Register symbol may not be renamed");
            }
        }
    }

    private void updateSymbolSource(Record symbolRecord, SourceType source) {
        byte flags = this.record.getByteValue(7);
        flags = (byte)(flags & 0xFFFFFFFC);
        flags = (byte)(flags | (byte)source.ordinal());
        symbolRecord.setByteValue(7, flags);
    }

    @Override
    public boolean setPrimary() {
        return false;
    }

    @Override
    public long getID() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Symbol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Symbol s = (Symbol)obj;
        if (this.hasSameId(s)) {
            return true;
        }
        if (!this.getName().equals(s.getName())) {
            return false;
        }
        if (!this.getAddress().equals(s.getAddress())) {
            return false;
        }
        if (!this.getSymbolType().equals(s.getSymbolType())) {
            return false;
        }
        Symbol myParent = this.getParentSymbol();
        Symbol otherParent = s.getParentSymbol();
        return SystemUtilities.isEqual((Object)myParent, (Object)otherParent);
    }

    private boolean hasSameId(Symbol s) {
        if (this.getID() == s.getID()) {
            return this.getProgram() == s.getProgram();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.key;
    }

    private void updateRecord() {
        try {
            this.symbolMgr.getDatabaseAdapter().updateSymbolRecord(this.record);
        }
        catch (IOException e) {
            this.symbolMgr.dbError(e);
        }
    }

    @Override
    public Namespace getParentNamespace() {
        Symbol parent = this.getParentSymbol();
        if (parent != null) {
            return (Namespace)parent.getObject();
        }
        return this.symbolMgr.getProgram().getGlobalNamespace();
    }

    @Override
    public Symbol getParentSymbol() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                Symbol symbol = null;
                return symbol;
            }
            Symbol symbol = this.symbolMgr.getSymbol(this.record.getLongValue(2));
            return symbol;
        }
        finally {
            this.lock.release();
        }
    }

    long getParentID() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                long l = 0L;
                return l;
            }
            long l = this.record.getLongValue(2);
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isGlobal() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.record.getLongValue(2) == 0L;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    public String getSymbolData3() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                String string = null;
                return string;
            }
            String string = this.record.getString(6);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    public void setSymbolData3(String data3) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.record == null) {
                return;
            }
            String oldData = this.record.getString(6);
            if (SystemUtilities.isEqual((Object)data3, (Object)oldData)) {
                return;
            }
            this.record.setString(6, data3);
            this.updateRecord();
            this.symbolMgr.symbolDataChanged(this);
        }
        finally {
            this.lock.release();
        }
    }

    protected void removeAllReferencesTo() {
        ReferenceDBManager refMgr = this.symbolMgr.getReferenceManager();
        ReferenceIterator it = refMgr.getReferencesTo(this.address);
        while (it.hasNext()) {
            Reference ref = it.next();
            refMgr.delete(ref);
        }
    }

    public long getSymbolData1() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record != null) {
                long l = this.record.getLongValue(4);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    public void setSymbolData1(long value) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.record != null) {
                this.record.setLongValue(4, value);
                this.updateRecord();
                this.symbolMgr.symbolDataChanged(this);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public int getSymbolData2() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record != null) {
                int n = this.record.getIntValue(5);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    public void setSymbolData2(int value) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.record != null) {
                this.record.setIntValue(5, value);
                this.updateRecord();
                this.symbolMgr.symbolDataChanged(this);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean delete() {
        this.lock.acquire();
        this.isDeleting = true;
        try {
            if (this.checkIsValid() && this.record != null) {
                boolean bl = this.symbolMgr.doRemoveSymbol(this);
                return bl;
            }
        }
        finally {
            this.isDeleting = false;
            this.lock.release();
        }
        return false;
    }

    public boolean isDeleting() {
        return this.isDeleting;
    }

    @Override
    public boolean isDescendant(Namespace namespace) {
        if (this == namespace.getSymbol()) {
            return true;
        }
        for (Namespace parent = namespace.getParentNamespace(); parent != null; parent = parent.getParentNamespace()) {
            Symbol s = parent.getSymbol();
            if (!this.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean isValidParent(Namespace var1);

    void setRecord(Record record) {
        this.record = record;
        this.keyChanged(record.getKey());
    }

    private static class PlaceholderSymbolDB
    extends SymbolDB {
        PlaceholderSymbolDB(SymbolManager symbolMgr, Address address, long key) {
            super(symbolMgr, null, address, key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Symbol)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Symbol s = (Symbol)obj;
            return this.getID() == s.getID();
        }

        @Override
        public SymbolType getSymbolType() {
            throw new IllegalArgumentException();
        }

        @Override
        public ProgramLocation getProgramLocation() {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isExternal() {
            throw new IllegalArgumentException();
        }

        @Override
        public Object getObject() {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isPrimary() {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isValidParent(Namespace parent) {
            throw new IllegalArgumentException();
        }
    }
}

