/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBHandle;
import db.Record;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.BitMappedSubMemoryBlock;
import ghidra.program.database.mem.BufferSubMemoryBlock;
import ghidra.program.database.mem.ByteMappedSubMemoryBlock;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.database.mem.UninitializedSubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class MemoryMapDBAdapterV0
extends MemoryMapDBAdapter {
    static final String V0_TABLE_NAME = "Memory Block";
    private static final int VERSION = 0;
    protected static final int V0_NAME_COL = 0;
    protected static final int V0_BUFFER_ID_COL = 1;
    protected static final int V0_COMMENTS_COL = 2;
    protected static final int V0_DESCRIPTION_COL = 3;
    protected static final int V0_SOURCE_NAME_COL = 4;
    protected static final int V0_SOURCE_OFFSET_COL = 5;
    protected static final int V0_IS_READ_COL = 6;
    protected static final int V0_IS_WRITE_COL = 7;
    protected static final int V0_IS_EXECUTE_COL = 8;
    protected static final int V0_START_ADDR_COL = 9;
    protected static final int V0_LENGTH_COL = 10;
    protected static final int V0_TYPE_COL = 11;
    protected static final int V0_BASE_ADDR_COL = 12;
    protected static final int V0_SOURCE_BLOCK_ID_COL = 13;
    protected static final int V0_SEGMENT_COL = 14;
    private List<MemoryBlockDB> blocks;
    private DBHandle handle;
    private MemoryMapDB memMap;

    MemoryMapDBAdapterV0(DBHandle handle, MemoryMapDB memMap) throws VersionException, IOException {
        this(handle, memMap, 0);
    }

    protected MemoryMapDBAdapterV0(DBHandle handle, MemoryMapDB memMap, int expectedVersion) throws VersionException, IOException {
        this.handle = handle;
        this.memMap = memMap;
        AddressMapDB addrMap = memMap.getAddressMap();
        Table table = handle.getTable(V0_TABLE_NAME);
        if (table == null) {
            throw new VersionException("Memory Block table not found");
        }
        int versionNumber = table.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new VersionException("Memory Block table: Expected Version " + expectedVersion + ", got " + versionNumber);
        }
        int recCount = table.getRecordCount();
        this.blocks = new ArrayList<MemoryBlockDB>(recCount);
        AddressFactory addrFactory = memMap.getAddressFactory();
        int key = 0;
        for (Record rec : table) {
            int permissions = 0;
            if (rec.getBooleanValue(6)) {
                permissions |= 4;
            }
            if (rec.getBooleanValue(7)) {
                permissions |= 2;
            }
            if (rec.getBooleanValue(8)) {
                permissions |= 1;
            }
            Address start = addrFactory.oldGetAddressFromLong(rec.getLongValue(9));
            long startAddr = addrMap.getKey(start, false);
            long length = rec.getLongValue(10);
            long bufID = rec.getIntValue(1);
            int segment = 0;
            if (expectedVersion == 1 && start instanceof SegmentedAddress) {
                segment = rec.getIntValue(14);
            }
            Record blockRecord = BLOCK_SCHEMA.createRecord((long)key);
            Record subBlockRecord = SUB_BLOCK_SCHEMA.createRecord((long)key);
            blockRecord.setString(0, rec.getString(0));
            blockRecord.setString(1, rec.getString(2));
            blockRecord.setString(2, rec.getString(4));
            blockRecord.setByteValue(3, (byte)permissions);
            blockRecord.setLongValue(4, startAddr);
            blockRecord.setLongValue(5, length);
            blockRecord.setIntValue(6, segment);
            subBlockRecord.setLongValue(0, (long)key);
            subBlockRecord.setLongValue(2, length);
            subBlockRecord.setLongValue(3, 0L);
            short type = rec.getShortValue(11);
            long overlayAddr = rec.getLongValue(12);
            overlayAddr = this.updateOverlayAddr(addrMap, addrFactory, overlayAddr, type);
            SubMemoryBlock subBlock = this.getSubBlock(memMap, bufID, subBlockRecord, type, overlayAddr);
            this.blocks.add(new MemoryBlockDB(this, blockRecord, Arrays.asList(subBlock)));
        }
        Collections.sort(this.blocks);
    }

    private SubMemoryBlock getSubBlock(MemoryMapDB memMap, long bufID, Record record, int type, long overlayAddr) throws IOException {
        switch (type) {
            case 2: {
                record.setByteValue(1, (byte)0);
                record.setLongValue(6, overlayAddr);
                return new BitMappedSubMemoryBlock(this, record);
            }
            case 4: {
                record.setByteValue(1, (byte)1);
                record.setLongValue(6, overlayAddr);
                return new ByteMappedSubMemoryBlock(this, record);
            }
            case 0: {
                record.setByteValue(1, (byte)2);
                record.setLongValue(5, bufID);
                return new BufferSubMemoryBlock(this, record);
            }
            case 1: {
                record.setByteValue(1, (byte)3);
                return new UninitializedSubMemoryBlock(this, record);
            }
        }
        throw new IOException("Unknown memory block type: " + type);
    }

    private long updateOverlayAddr(AddressMap addrMap, AddressFactory addrFactory, long overlayAddr, int type) {
        if (type == 2 || type == 4) {
            Address ov = addrFactory.oldGetAddressFromLong(overlayAddr);
            overlayAddr = addrMap.getKey(ov, false);
        }
        return overlayAddr;
    }

    @Override
    void refreshMemory() throws IOException {
    }

    @Override
    List<MemoryBlockDB> getMemoryBlocks() {
        return this.blocks;
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, InputStream is, long length, int permissions) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, DBBuffer buf, int permissions) throws IOException {
        throw new UnsupportedOperationException();
    }

    void setBlockSize(MemoryBlockDB block, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteMemoryBlock(long key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteTable(DBHandle dbHandle) throws IOException {
        dbHandle.deleteTable(V0_TABLE_NAME);
    }

    @Override
    void updateBlockRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBBuffer createBuffer(int length, byte initialValue) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createBlock(MemoryBlockType blockType, String name, Address startAddr, long length, Address overlayAddr, boolean initializeBytes, int permissions, int mappingScheme) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBBuffer getBuffer(int bufferID) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID);
        }
        return null;
    }

    @Override
    MemoryMapDB getMemoryMap() {
        return null;
    }

    @Override
    void deleteSubBlock(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void updateSubBlockRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Record createSubBlockRecord(long memBlockId, long startingOffset, long length, byte subType, int data1, long data2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MemoryBlockDB createBlock(String name, Address addr, long length, int permissions, List<SubMemoryBlock> splitBlocks) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MemoryBlockDB createFileBytesBlock(String name, Address startAddress, long length, FileBytes fileBytes, long offset, int permissions) throws IOException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }
}

