/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Record;
import db.Schema;
import ghidra.program.database.data.SourceArchiveAdapterNoTable;
import ghidra.program.database.data.SourceArchiveAdapterV0;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

abstract class SourceArchiveAdapter {
    static final String TABLE_NAME = "Data Type Archive IDs";
    static final Schema SCHEMA = SourceArchiveAdapterV0.V0_SCHEMA;
    static final int ARCHIVE_ID_DOMAIN_FILE_ID_COL = 0;
    static final int ARCHIVE_ID_NAME_COL = 1;
    static final int ARCHIVE_ID_TYPE_COL = 2;
    static final int ARCHIVE_ID_LAST_SYNC_TIME_COL = 3;
    static final int ARCHIVE_ID_DIRTY_FLAG_COL = 4;

    SourceArchiveAdapter() {
    }

    static SourceArchiveAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new SourceArchiveAdapterV0(handle, true);
        }
        try {
            return new SourceArchiveAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            SourceArchiveAdapter adapter = SourceArchiveAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = SourceArchiveAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static SourceArchiveAdapter findReadOnlyAdapter(DBHandle handle) {
        return new SourceArchiveAdapterNoTable(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SourceArchiveAdapter upgrade(DBHandle handle, SourceArchiveAdapter oldAdapter) throws VersionException, IOException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        SourceArchiveAdapterV0 tmpAdapter = null;
        try {
            tmpAdapter = new SourceArchiveAdapterV0(tmpHandle, true);
            for (Record rec : oldAdapter.getRecords()) {
                ((SourceArchiveAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            SourceArchiveAdapterV0 newAdapter = new SourceArchiveAdapterV0(handle, true);
            for (Record rec : ((SourceArchiveAdapter)tmpAdapter).getRecords()) {
                ((SourceArchiveAdapter)newAdapter).updateRecord(rec);
            }
            SourceArchiveAdapterV0 sourceArchiveAdapterV0 = newAdapter;
            return sourceArchiveAdapterV0;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Record createRecord(SourceArchive var1) throws IOException;

    abstract List<Record> getRecords() throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract void updateRecord(Record var1) throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void deleteRecord(UniversalID var1) throws IOException;
}

