/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.SettingsDBManager;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

class DataTypeComponentDB
implements InternalDataTypeComponent {
    private final DataTypeManagerDB dataMgr;
    private final ComponentDBAdapter adapter;
    private final Record record;
    private final Composite parent;
    private DataType cachedDataType;
    private boolean isFlexibleArrayComponent = false;
    private int ordinal;
    private int offset;
    private int length;
    private SettingsDBManager defaultSettings;

    DataTypeComponentDB(DataTypeManagerDB dataMgr, ComponentDBAdapter adapter, Composite parent, long parentID, int ordinal, int offset) {
        this.dataMgr = dataMgr;
        this.adapter = adapter;
        this.parent = parent;
        this.ordinal = ordinal;
        this.offset = offset;
        this.length = 1;
        this.record = null;
    }

    DataTypeComponentDB(DataTypeManagerDB dataMgr, ComponentDBAdapter adapter, Composite parent, Record record) {
        this.dataMgr = dataMgr;
        this.adapter = adapter;
        this.record = record;
        this.parent = parent;
        this.ordinal = record.getIntValue(6);
        this.offset = record.getIntValue(1);
        this.length = record.getIntValue(5);
        this.initFlexibleArrayComponent();
    }

    private void initFlexibleArrayComponent() {
        this.isFlexibleArrayComponent = this.length == 0 && this.offset < 0 && this.ordinal < 0 && this.parent instanceof Structure;
    }

    @Override
    public boolean isFlexibleArrayComponent() {
        return this.isFlexibleArrayComponent;
    }

    @Override
    public boolean isBitFieldComponent() {
        if (this.record == null) {
            return false;
        }
        long id = this.record.getLongValue(2);
        return DataTypeManagerDB.getTableID(id) == 9;
    }

    @Override
    public boolean isZeroBitFieldComponent() {
        if (this.isBitFieldComponent()) {
            BitFieldDataType bitField = (BitFieldDataType)this.getDataType();
            return bitField.getBitSize() == 0;
        }
        return false;
    }

    public long getKey() {
        return this.record != null ? this.record.getKey() : -1L;
    }

    @Override
    public DataType getDataType() {
        if (this.record == null) {
            return DataType.DEFAULT;
        }
        if (this.cachedDataType != null) {
            return this.cachedDataType;
        }
        long id = this.record.getLongValue(2);
        if (id == -1L) {
            return DataType.DEFAULT;
        }
        return this.dataMgr.getDataType(id);
    }

    @Override
    public Composite getParent() {
        return this.parent;
    }

    @Override
    public int getOffset() {
        if (this.isFlexibleArrayComponent) {
            if (this.parent.isNotYetDefined()) {
                return 0;
            }
            return this.parent.getLength();
        }
        return this.offset;
    }

    boolean containsOffset(int off) {
        if (this.isFlexibleArrayComponent) {
            return false;
        }
        return off >= this.offset && off <= this.offset + this.length - 1;
    }

    @Override
    public int getOrdinal() {
        if (this.isFlexibleArrayComponent) {
            return this.parent.getNumComponents();
        }
        return this.ordinal;
    }

    @Override
    public int getEndOffset() {
        if (this.isFlexibleArrayComponent) {
            return -1;
        }
        return this.offset + this.length - 1;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getComment() {
        if (this.record != null) {
            return this.record.getString(4);
        }
        return null;
    }

    @Override
    public Settings getDefaultSettings() {
        if (this.defaultSettings == null) {
            if (this.record != null) {
                this.defaultSettings = new SettingsDBManager(this.dataMgr, this, this.record.getKey());
            } else {
                return this.getDataType().getDefaultSettings();
            }
        }
        return this.defaultSettings;
    }

    @Override
    public void setDefaultSettings(Settings settings) {
        if (this.record != null) {
            if (this.defaultSettings == null) {
                this.defaultSettings = new SettingsDBManager(this.dataMgr, this, this.record.getKey());
            }
            this.defaultSettings.update(settings);
        }
    }

    @Override
    public void setComment(String comment) {
        try {
            if (this.record != null) {
                this.record.setString(4, comment);
                this.adapter.updateRecord(this.record);
                this.notifyChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    public String getFieldName() {
        if (this.isZeroBitFieldComponent()) {
            return "";
        }
        if (this.record != null) {
            return this.record.getString(3);
        }
        return null;
    }

    @Override
    public String getDefaultFieldName() {
        if (this.isZeroBitFieldComponent()) {
            return "";
        }
        if (this.parent instanceof Structure) {
            return "field_0x" + Integer.toHexString(this.getOffset());
        }
        return "field" + this.ordinal;
    }

    @Override
    public void setFieldName(String name) throws DuplicateNameException {
        try {
            if (this.record != null) {
                if (name != null) {
                    if ((name = name.trim()).length() == 0 || name.equals(this.getDefaultFieldName())) {
                        name = null;
                    } else {
                        this.checkDuplicateName(name);
                    }
                }
                this.record.setString(3, name);
                this.adapter.updateRecord(this.record);
                this.notifyChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    private void checkDuplicateName(String name) throws DuplicateNameException {
        DataTypeComponentImpl.checkDefaultFieldName(name);
        for (DataTypeComponent comp : this.parent.getComponents()) {
            if (comp == this || !name.equals(comp.getFieldName())) continue;
            throw new DuplicateNameException("Duplicate field name: " + name);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataTypeComponent)) {
            return false;
        }
        DataTypeComponent dtc = (DataTypeComponent)obj;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        if (this.getOffset() != dtc.getOffset() || this.getLength() != dtc.getLength() || this.getOrdinal() != dtc.getOrdinal() || !SystemUtilities.isEqual((Object)this.getFieldName(), (Object)dtc.getFieldName()) || !SystemUtilities.isEqual((Object)this.getComment(), (Object)dtc.getComment())) {
            return false;
        }
        if (!(myDt instanceof Pointer) && !myDt.getPathName().equals(otherDt.getPathName())) {
            return false;
        }
        if (myDt instanceof Structure) {
            return otherDt instanceof Structure;
        }
        if (myDt instanceof Union) {
            return otherDt instanceof Union;
        }
        if (myDt instanceof Array) {
            return otherDt instanceof Array;
        }
        if (myDt instanceof Pointer) {
            return otherDt instanceof Pointer;
        }
        if (myDt instanceof TypeDef) {
            return otherDt instanceof TypeDef;
        }
        return myDt.getClass() == otherDt.getClass();
    }

    @Override
    public boolean isEquivalent(DataTypeComponent dtc) {
        boolean aligned;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        if (myDt == null || otherDt == null) {
            return false;
        }
        Composite myParent = this.getParent();
        boolean bl = aligned = myParent instanceof Composite ? myParent.isInternallyAligned() : false;
        if (!aligned && this.getOffset() != dtc.getOffset() || !SystemUtilities.isEqual((Object)this.getFieldName(), (Object)dtc.getFieldName()) || !SystemUtilities.isEqual((Object)this.getComment(), (Object)dtc.getComment())) {
            return false;
        }
        if (this.getLength() != dtc.getLength() && myDt instanceof Dynamic) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(myDt, otherDt);
    }

    @Override
    public void update(int newOrdinal, int newOffset, int newLength) {
        if (this.isFlexibleArrayComponent) {
            return;
        }
        if (this.length < 0) {
            throw new IllegalArgumentException("Cannot set data type component length to " + this.length + ".");
        }
        this.ordinal = newOrdinal;
        this.offset = newOffset;
        this.length = newLength;
        if (this.record != null) {
            this.record.setIntValue(6, this.ordinal);
            this.record.setIntValue(1, this.offset);
            this.record.setIntValue(5, this.length);
            this.updateRecord();
        }
    }

    void setOffset(int newOffset, boolean updateRecord) {
        if (this.isFlexibleArrayComponent) {
            return;
        }
        this.offset = newOffset;
        if (this.record != null) {
            this.record.setIntValue(1, this.offset);
        }
        if (updateRecord) {
            this.updateRecord();
        }
    }

    void setOrdinal(int ordinal, boolean updateRecord) {
        if (this.isFlexibleArrayComponent) {
            return;
        }
        this.ordinal = ordinal;
        if (this.record != null) {
            this.record.setIntValue(6, ordinal);
        }
        if (updateRecord) {
            this.updateRecord();
        }
    }

    void setLength(int length, boolean updateRecord) {
        if (this.isFlexibleArrayComponent || length == this.length) {
            return;
        }
        this.length = length;
        if (length < 0) {
            throw new IllegalArgumentException("Cannot set data type component length to " + length + ".");
        }
        if (this.record != null) {
            this.record.setIntValue(5, length);
        }
        if (updateRecord) {
            this.updateRecord();
        }
    }

    void updateRecord() {
        if (this.record != null) {
            try {
                this.adapter.updateRecord(this.record);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
    }

    Record getRecord() {
        return this.record;
    }

    @Override
    public void setDataType(DataType newDt) {
        if (this.record != null) {
            this.record.setLongValue(2, this.dataMgr.getResolvedID(newDt));
            this.updateRecord();
        }
    }

    private void notifyChanged() {
        Composite dt = this.getParent();
        this.dataMgr.dataTypeChanged(dt);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  " + this.getOrdinal());
        buffer.append("  " + this.getOffset());
        DataType dt = this.getDataType();
        buffer.append("  " + dt.getName());
        if (this.isFlexibleArrayComponent) {
            buffer.append("[0]");
        } else if (dt instanceof BitFieldDataType) {
            buffer.append("(" + ((BitFieldDataType)dt).getBitOffset() + ")");
        }
        buffer.append("  " + this.getLength());
        buffer.append("  " + this.getFieldName());
        String comment = this.getComment();
        buffer.append("  " + (String)(comment != null ? "\"" + comment + "\"" : comment));
        return buffer.toString();
    }
}

