/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.GhidraBigEndianDataConverter;
import ghidra.util.GhidraLittleEndianDataConverter;
import ghidra.util.Lock;
import ghidra.util.Saveable;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

abstract class CodeUnitDB
extends DatabaseObject
implements CodeUnit,
ProcessorContext {
    protected CodeManager codeMgr;
    protected Address address;
    protected long addr;
    protected Address endAddr;
    protected int length;
    protected ReferenceManager refMgr;
    protected ProgramDB program;
    private Record commentRec;
    private boolean checkedComments;
    protected byte[] bytes;
    private ProgramContext programContext;
    protected ChangeManager changeMgr;
    protected Lock lock;

    public CodeUnitDB(CodeManager codeMgr, DBObjectCache<? extends CodeUnitDB> cache, long cacheKey, Address address, long addr, int length) {
        super(cache, cacheKey);
        this.codeMgr = codeMgr;
        this.address = address;
        this.addr = addr;
        this.length = length;
        this.lock = codeMgr.lock;
        this.program = (ProgramDB)codeMgr.getProgram();
        this.refMgr = this.program.getReferenceManager();
        this.programContext = this.program.getProgramContext();
        this.changeMgr = this.program;
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(Record record) {
        this.address = this.codeMgr.getAddressMap().decodeAddress(this.addr);
        this.endAddr = null;
        this.commentRec = null;
        this.checkedComments = false;
        this.bytes = null;
        return !this.hasBeenDeleted(record);
    }

    protected void refreshIfNeeded() {
        if (this.isInvalid()) {
            this.lock.acquire();
            try {
                this.refresh();
            }
            finally {
                this.lock.release();
            }
        }
    }

    protected abstract boolean hasBeenDeleted(Record var1);

    @Override
    public void addMnemonicReference(Address refAddr, RefType refType, SourceType sourceType) {
        this.refreshIfNeeded();
        this.refMgr.addMemoryReference(this.address, refAddr, refType, sourceType, -1);
    }

    @Override
    public void addOperandReference(int opIndex, Address refAddr, RefType type, SourceType sourceType) {
        this.refreshIfNeeded();
        this.refMgr.addMemoryReference(this.address, refAddr, type, sourceType, opIndex);
    }

    @Override
    public int compareTo(Address a) {
        this.refreshIfNeeded();
        if (this.contains(a)) {
            return 0;
        }
        return this.address.compareTo(a);
    }

    @Override
    public boolean contains(Address testAddr) {
        this.refreshIfNeeded();
        return this.address.compareTo(testAddr) <= 0 && testAddr.compareTo(this.getMaxAddress()) <= 0;
    }

    @Override
    public String getAddressString(boolean showBlockName, boolean pad) {
        MemoryBlock block;
        this.refreshIfNeeded();
        Address cuAddress = this.address;
        String addressString = cuAddress.toString(false, pad);
        if (showBlockName && (block = this.program.getMemory().getBlock(cuAddress)) != null) {
            return block.getName() + ":" + addressString;
        }
        return addressString;
    }

    @Override
    public boolean isBigEndian() {
        return this.program.getMemory().isBigEndian();
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        if (this.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getShort(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        if (this.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getInt(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        if (this.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getLong(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        if (this.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
    }

    @Override
    public String getComment(int commentType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (!this.checkedComments) {
                this.readComments();
            }
            if (this.commentRec == null) {
                String string = null;
                return string;
            }
            String string = this.commentRec.getString(commentType);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String[] getCommentAsArray(int commentType) {
        String comment = this.getComment(commentType);
        return StringUtilities.toLines((String)comment);
    }

    @Override
    public ExternalReference getExternalReference(int opIndex) {
        Reference[] refs;
        this.refreshIfNeeded();
        for (Reference element : refs = this.refMgr.getReferencesFrom(this.address, opIndex)) {
            if (!element.isExternalReference()) continue;
            return (ExternalReference)element;
        }
        return null;
    }

    @Override
    public int getIntProperty(String name) throws NoValueException {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        IntPropertyMap pm = upm.getIntPropertyMap(name);
        if (pm == null) {
            throw NoValueException.noValueException;
        }
        try {
            this.refreshIfNeeded();
            return pm.getInt(this.address);
        }
        catch (ConcurrentModificationException e) {
            throw NoValueException.noValueException;
        }
    }

    @Override
    public String getLabel() {
        this.refreshIfNeeded();
        SymbolTable st = this.codeMgr.getSymbolTable();
        Symbol symbol = st.getPrimarySymbol(this.address);
        if (symbol != null) {
            try {
                return symbol.getName();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Address getMaxAddress() {
        this.refreshIfNeeded();
        if (this.endAddr == null) {
            this.endAddr = this.address.add(this.length - 1);
        }
        return this.endAddr;
    }

    @Override
    public Address getMinAddress() {
        this.refreshIfNeeded();
        return this.address;
    }

    @Override
    public Address getAddress() {
        this.refreshIfNeeded();
        return this.address;
    }

    @Override
    public Reference[] getMnemonicReferences() {
        this.refreshIfNeeded();
        return this.refMgr.getReferencesFrom(this.address, -1);
    }

    @Override
    public Saveable getObjectProperty(String name) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        ObjectPropertyMap pm = upm.getObjectPropertyMap(name);
        if (pm != null) {
            try {
                this.refreshIfNeeded();
                return (Saveable)pm.getObject(this.address);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Reference[] getOperandReferences(int opIndex) {
        this.refreshIfNeeded();
        return this.refMgr.getReferencesFrom(this.address, opIndex);
    }

    @Override
    public Reference getPrimaryReference(int index) {
        this.refreshIfNeeded();
        return this.refMgr.getPrimaryReferenceFrom(this.address, index);
    }

    @Override
    public Symbol getPrimarySymbol() {
        this.refreshIfNeeded();
        SymbolTable st = this.codeMgr.getSymbolTable();
        return st.getPrimarySymbol(this.address);
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public Reference[] getReferencesFrom() {
        this.refreshIfNeeded();
        return this.refMgr.getReferencesFrom(this.address);
    }

    @Override
    public ReferenceIterator getReferenceIteratorTo() {
        this.refreshIfNeeded();
        return this.program.getReferenceManager().getReferencesTo(this.address);
    }

    @Override
    public String getStringProperty(String name) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        StringPropertyMap pm = upm.getStringPropertyMap(name);
        if (pm != null) {
            try {
                this.refreshIfNeeded();
                return pm.getString(this.address);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Symbol[] getSymbols() {
        this.refreshIfNeeded();
        SymbolTable st = this.codeMgr.getSymbolTable();
        return st.getSymbols(this.address);
    }

    @Override
    public boolean getVoidProperty(String name) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        PropertyMap pm = upm.getPropertyMap(name);
        if (pm != null) {
            try {
                this.refreshIfNeeded();
                return pm.hasProperty(this.address);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean hasProperty(String name) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        PropertyMap pm = upm.getPropertyMap(name);
        if (pm != null) {
            try {
                this.refreshIfNeeded();
                return pm.hasProperty(this.address);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isSuccessor(CodeUnit codeUnit) {
        Address min = codeUnit.getMinAddress();
        return this.getMaxAddress().isSuccessor(min);
    }

    @Override
    public Iterator<String> propertyNames() {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        return upm.propertyManagers();
    }

    @Override
    public void removeExternalReference(int opIndex) {
        ExternalReference ref = this.getExternalReference(opIndex);
        if (ref != null) {
            this.program.getReferenceManager().delete(ref);
        }
    }

    @Override
    public void removeMnemonicReference(Address refAddr) {
        this.refreshIfNeeded();
        Reference ref = this.refMgr.getReference(this.address, refAddr, -1);
        if (ref != null) {
            this.program.getReferenceManager().delete(ref);
        }
    }

    @Override
    public void removeOperandReference(int opIndex, Address refAddr) {
        this.refreshIfNeeded();
        Reference ref = this.refMgr.getReference(this.address, refAddr, opIndex);
        if (ref != null) {
            this.program.getReferenceManager().delete(ref);
        }
    }

    @Override
    public void removeProperty(String name) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        PropertyMap pm = upm.getPropertyMap(name);
        if (pm != null) {
            try {
                this.refreshIfNeeded();
                pm.remove(this.address);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComment(int commentType, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (!this.checkedComments) {
                this.readComments();
            }
            if (this.commentRec == null) {
                if (comment == null) {
                    return;
                }
                try {
                    this.commentRec = this.codeMgr.getCommentAdapter().createRecord(this.addr, commentType, comment);
                }
                catch (IOException e) {
                    this.codeMgr.dbError(e);
                }
                this.codeMgr.sendNotification(this.address, commentType, null, comment);
                return;
            }
            String oldValue = this.commentRec.getString(commentType);
            this.commentRec.setString(commentType, comment);
            this.codeMgr.sendNotification(this.address, commentType, oldValue, comment);
            for (int i = 0; i < 5; ++i) {
                if (this.commentRec.getString(i) == null) continue;
                this.updateCommentRecord();
                return;
            }
            try {
                this.codeMgr.getCommentAdapter().deleteRecord(this.commentRec.getKey());
            }
            catch (IOException e) {
                this.codeMgr.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setCommentAsArray(int commentType, String[] comment) {
        this.setComment(commentType, StringUtils.join((Object[])comment, (char)'\n'));
    }

    @Override
    public void setPrimaryMemoryReference(Reference ref) {
        this.refMgr.setPrimary(ref, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, int value) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        this.lock.acquire();
        try {
            this.checkDeleted();
            IntPropertyMap pm = upm.getIntPropertyMap(name);
            if (pm == null) {
                try {
                    pm = upm.createIntPropertyMap(name);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Assert problem in CodeUnitImpl.setProperty(String,int)");
                }
            }
            pm.add(this.address, value);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, Saveable value) {
        PropertyMapManager mgr = this.codeMgr.getPropertyMapManager();
        this.lock.acquire();
        try {
            this.checkDeleted();
            ObjectPropertyMap pm = mgr.getObjectPropertyMap(name);
            if (pm == null) {
                try {
                    pm = mgr.createObjectPropertyMap(name, value.getClass());
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Assert problem in CodeUnitImpl.setProperty(Stirng,Object)");
                }
            }
            pm.add(this.address, value);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, String value) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        this.lock.acquire();
        try {
            this.checkDeleted();
            StringPropertyMap pm = upm.getStringPropertyMap(name);
            if (pm == null) {
                try {
                    pm = upm.createStringPropertyMap(name);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Assert problem in CodeUnitImpl.setProperty(String,String)");
                }
            }
            pm.add(this.address, value);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        this.lock.acquire();
        try {
            this.checkDeleted();
            VoidPropertyMap pm = upm.getVoidPropertyMap(name);
            if (pm == null) {
                try {
                    pm = upm.createVoidPropertyMap(name);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Assert problem in CodeUnitImpl.setProperty(Stirng)");
                }
            }
            pm.add(this.address);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setStackReference(int opIndex, int offset, SourceType sourceType, RefType refType) {
        this.refreshIfNeeded();
        this.validateOpIndex(opIndex);
        this.refMgr.addStackReference(this.address, opIndex, offset, refType, sourceType);
    }

    @Override
    public void setRegisterReference(int opIndex, Register reg, SourceType sourceType, RefType refType) {
        this.refreshIfNeeded();
        this.validateOpIndex(opIndex);
        this.refMgr.addRegisterReference(this.address, opIndex, reg, refType, sourceType);
    }

    @Override
    public void visitProperty(PropertyVisitor visitor, String propertyName) {
        PropertyMapManager upm = this.codeMgr.getPropertyMapManager();
        PropertyMap pm = upm.getPropertyMap(propertyName);
        if (pm != null) {
            try {
                this.refreshIfNeeded();
                pm.applyValue(visitor, this.address);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(byte[] b, int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.populateByteArray();
            if (offset < 0 || offset + b.length > this.bytes.length) {
                int n = this.program.getMemory().getBytes(this.address.add(offset), b);
                return n;
            }
            System.arraycopy(this.bytes, offset, b, 0, b.length);
            int n = b.length;
            return n;
        }
        catch (AddressOutOfBoundsException | MemoryAccessException e) {
            int n = 0;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public byte[] getBytes() throws MemoryAccessException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.populateByteArray();
            byte[] b = new byte[this.length];
            if (this.bytes.length < this.length) {
                if (this.program.getMemory().getBytes(this.address, b) != this.length) {
                    throw new MemoryAccessException("Couldn't get all bytes for CodeUnit");
                }
            } else {
                System.arraycopy(this.bytes, 0, b, 0, b.length);
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.populateByteArray();
            if (offset < 0 || offset >= this.bytes.length) {
                try {
                    byte by = this.program.getMemory().getByte(this.address.add(offset));
                    return by;
                }
                catch (AddressOutOfBoundsException e) {
                    throw new MemoryAccessException(e.getMessage());
                }
            }
            byte by = this.bytes[offset];
            return by;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Memory getMemory() {
        return this.program.getMemory();
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        this.refreshIfNeeded();
        return this.programContext.getValue(register, this.address, signed);
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        this.refreshIfNeeded();
        return this.programContext.getRegisterValue(register, this.address);
    }

    @Override
    public void setValue(Register register, BigInteger value) throws ContextChangeException {
        this.refreshIfNeeded();
        this.programContext.setValue(register, this.address, this.address, value);
    }

    @Override
    public void clearRegister(Register register) throws ContextChangeException {
        this.refreshIfNeeded();
        this.programContext.setValue(register, this.address, this.address, null);
    }

    @Override
    public void setRegisterValue(RegisterValue value) throws ContextChangeException {
        this.refreshIfNeeded();
        this.programContext.setRegisterValue(this.address, this.address, value);
    }

    @Override
    public Register getRegister(String name) {
        return this.programContext.getRegister(name);
    }

    @Override
    public Register getBaseContextRegister() {
        return this.programContext.getBaseContextRegister();
    }

    @Override
    public List<Register> getRegisters() {
        return this.programContext.getRegisters();
    }

    @Override
    public boolean hasValue(Register register) {
        this.refreshIfNeeded();
        return this.programContext.getValue(register, this.address, false) != null;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeUnitDB cu = (CodeUnitDB)obj;
        return this.addr == cu.addr && this.codeMgr == cu.codeMgr;
    }

    public abstract String toString();

    Record getCommentRecord() {
        return this.commentRec;
    }

    private void readComments() {
        try {
            this.commentRec = this.codeMgr.getCommentAdapter().getRecord(this.addr);
            this.checkedComments = true;
        }
        catch (IOException e) {
            this.codeMgr.dbError(e);
        }
    }

    private void populateByteArray() {
        if (this.bytes != null) {
            return;
        }
        int cacheLength = this.getPreferredCacheLength();
        this.bytes = new byte[cacheLength];
        if (cacheLength != 0) {
            int nbytes = 0;
            try {
                nbytes = this.program.getMemory().getBytes(this.address, this.bytes);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
            if (nbytes != this.bytes.length) {
                this.bytes = new byte[0];
            }
        }
    }

    protected int getPreferredCacheLength() {
        return this.length;
    }

    private void validateOpIndex(int opIndex) {
        if (opIndex >= this.getNumOperands()) {
            throw new IllegalArgumentException("Invalid operand index [" + opIndex + "] specified");
        }
    }

    private void updateCommentRecord() {
        try {
            this.codeMgr.getCommentAdapter().updateRecord(this.commentRec);
        }
        catch (IOException e) {
            this.codeMgr.dbError(e);
        }
    }

    @Override
    public void getBytesInCodeUnit(byte[] buffer, int bufferOffset) throws MemoryAccessException {
        this.refreshIfNeeded();
        byte[] codeUnitBytes = this.getBytes();
        System.arraycopy(codeUnitBytes, 0, buffer, bufferOffset, Math.min(buffer.length, this.getLength()));
    }
}

