/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.Field;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import db.util.ErrorHandler;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.framework.Application;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.options.Options;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.LockException;
import ghidra.program.database.IntRangeMap;
import ghidra.program.database.IntRangeMapDB;
import ghidra.program.database.ListingDB;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ObsoleteProgramPropertiesService;
import ghidra.program.database.OverlaySpaceAdapterDB;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramDBChangeSet;
import ghidra.program.database.ProgramUserDataDB;
import ghidra.program.database.bookmark.BookmarkDBManager;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.code.InstructionDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.module.TreeManager;
import ghidra.program.database.oldfunction.OldFunctionManager;
import ghidra.program.database.properties.DBPropertyMapManager;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.register.ProgramRegisterContextDB;
import ghidra.program.database.reloc.RelocationManager;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.database.util.AddressSetPropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.OldLanguageMappingService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.util.ChangeManager;
import ghidra.program.util.CodeUnitPropertyChangeRecord;
import ghidra.program.util.CodeUnitUserDataChangeRecord;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.LanguageTranslatorFactory;
import ghidra.program.util.OldLanguageFactory;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramUtilities;
import ghidra.program.util.UserDataChangeRecord;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.RollbackException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ProgramDB
extends DomainObjectAdapterDB
implements Program,
ChangeManager {
    public static final String CONTENT_TYPE = "Program";
    private static final String UNKNOWN = "unknown";
    static final int DB_VERSION = 21;
    private static final int UPGRADE_REQUIRED_BEFORE_VERSION = 19;
    public static final int ANALYSIS_OPTIONS_MOVED_VERSION = 9;
    public static final int ADDED_VARIABLE_STORAGE_MANAGER_VERSION = 10;
    public static final int METADATA_ADDED_VERSION = 11;
    public static final int EXTERNAL_FUNCTIONS_ADDED_VERSION = 17;
    public static final int COMPOUND_VARIABLE_STORAGE_ADDED_VERSION = 18;
    public static final int AUTO_PARAMETERS_ADDED_VERSION = 19;
    private static final String LANG_DEFAULT_VERSION = "1.0";
    private static final String PROGRAM_NAME = "Program Name";
    private static final String PROGRAM_DB_VERSION = "DB Version";
    private static final String LANGUAGE_VERSION = "Language Version";
    private static final String OLD_LANGUAGE_NAME = "Language Name";
    private static final String LANGUAGE_ID = "Language ID";
    private static final String COMPILER_SPEC_ID = "Compiler Spec ID";
    private static final String COMPILER = "Compiler";
    private static final String EXECUTABLE_PATH = "Executable Location";
    private static final String EXECUTABLE_FORMAT = "Executable Format";
    private static final String EXECUTABLE_MD5 = "Executable MD5";
    private static final String EXECUTABLE_SHA256 = "Executable SHA256";
    private static final String TABLE_NAME = "Program";
    private static final String EXECUTE_PATH = "Execute Path";
    private static final String EXECUTE_FORMAT = "Execute Format";
    private static final String IMAGE_OFFSET = "Image Offset";
    private static final Class<?>[] COL_CLASS = new Class[]{StringField.class};
    private static final String[] COL_TYPES = new String[]{"Value"};
    private static final Schema SCHEMA = new Schema(0, StringField.class, "Key", (Class[])COL_CLASS, COL_TYPES);
    private static final int MEMORY_MGR = 0;
    private static final int CODE_MGR = 1;
    private static final int SYMBOL_MGR = 2;
    private static final int NAMESPACE_MGR = 3;
    private static final int FUNCTION_MGR = 4;
    private static final int EXTERNAL_MGR = 5;
    private static final int REF_MGR = 6;
    private static final int DATA_MGR = 7;
    private static final int EQUATE_MGR = 8;
    private static final int BOOKMARK_MGR = 9;
    private static final int CONTEXT_MGR = 10;
    private static final int PROPERTY_MGR = 11;
    private static final int TREE_MGR = 12;
    private static final int RELOC_MGR = 13;
    private static final int NUM_MANAGERS = 14;
    private ManagerDB[] managers = new ManagerDB[14];
    private OldFunctionManager oldFunctionMgr;
    private MemoryMapDB memoryManager;
    private GlobalNamespace globalNamespace;
    private boolean changeable = true;
    private ProgramAddressFactory addressFactory;
    private AddressMapDB addrMap;
    private ListingDB listing;
    private ProgramUserDataDB programUserData;
    private Table table;
    private Language language;
    private CompilerSpec compilerSpec;
    private LanguageID languageID;
    private CompilerSpecID compilerSpecID;
    private int languageVersion;
    private int languageMinorVersion;
    private LanguageTranslator languageUpgradeTranslator;
    private Address storedImageBase;
    private boolean imageBaseOverride = false;
    private boolean recordChanges;
    private OverlaySpaceAdapterDB overlaySpaceAdapter;
    private Map<String, AddressSetPropertyMapDB> addrSetPropertyMap = new HashMap<String, AddressSetPropertyMapDB>();
    private Map<String, IntRangeMapDB> intRangePropertyMap = new HashMap<String, IntRangeMapDB>();

    public ProgramDB(String name, Language language, CompilerSpec compilerSpec, Object consumer) throws IOException {
        super(new DBHandle(), name, 500, 1000, consumer);
        this.language = language;
        this.compilerSpec = compilerSpec;
        this.languageID = language.getLanguageID();
        this.compilerSpecID = compilerSpec.getCompilerSpecID();
        this.languageVersion = language.getVersion();
        this.languageMinorVersion = language.getMinorVersion();
        this.addressFactory = new ProgramAddressFactory(language, compilerSpec);
        this.recordChanges = false;
        boolean success = false;
        try {
            int id = this.startTransaction("create program");
            this.createDatabase();
            if (this.createManagers(0, TaskMonitor.DUMMY) != null) {
                throw new AssertException("Unexpected version exception on create");
            }
            this.listing = new ListingDB();
            this.changeSet = new ProgramDBChangeSet(this.addrMap, 50);
            this.initManagers(0, TaskMonitor.DUMMY);
            this.propertiesCreate();
            this.programUserData = new ProgramUserDataDB(this);
            this.endTransaction(id, true);
            this.clearUndo(false);
            compilerSpec.registerProgramOptions(this);
            this.getCodeManager().activateContextLocking();
            success = true;
        }
        catch (CancelledException e) {
            throw new AssertException();
        }
        finally {
            this.dbh.closeScratchPad();
            if (!success) {
                this.release(consumer);
                this.dbh.close();
            }
        }
        ProgramUtilities.addTrackedProgram(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramDB(DBHandle dbh, int openMode, TaskMonitor monitor, Object consumer) throws IOException, VersionException, LanguageNotFoundException, CancelledException {
        super(dbh, "Untitled", 500, 1000, consumer);
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        boolean success = false;
        try {
            int id = this.startTransaction("create program");
            this.recordChanges = false;
            this.changeable = openMode != 2;
            VersionException dbVersionExc = this.initializeDatabase(openMode);
            VersionException languageVersionExc = null;
            try {
                this.language = DefaultLanguageService.getLanguageService().getLanguage(this.languageID);
                languageVersionExc = this.checkLanguageVersion(openMode);
            }
            catch (LanguageNotFoundException e) {
                languageVersionExc = this.checkForLanguageChange(e, openMode);
            }
            this.initCompilerSpec();
            this.addressFactory = new ProgramAddressFactory(this.language, this.compilerSpec);
            VersionException versionExc = this.createManagers(openMode, monitor);
            if (dbVersionExc != null) {
                versionExc = dbVersionExc.combine(versionExc);
            }
            if (languageVersionExc != null && openMode != 3) {
                versionExc = languageVersionExc.combine(versionExc);
            }
            if (versionExc != null) {
                throw versionExc;
            }
            this.listing = new ListingDB();
            this.changeSet = new ProgramDBChangeSet(this.addrMap, 50);
            this.initManagers(openMode, monitor);
            if (openMode == 3) {
                int oldVersion = this.getStoredVersion();
                this.upgradeDatabase(monitor);
                if (languageVersionExc != null) {
                    try {
                        this.setLanguage(this.languageUpgradeTranslator, null, false, monitor);
                    }
                    catch (IllegalStateException e) {
                        if (e.getCause() instanceof CancelledException) {
                            throw (CancelledException)e.getCause();
                        }
                        throw e;
                    }
                    catch (LockException e) {
                        throw new AssertException("Upgrade mode requires exclusive access");
                    }
                }
                this.postUpgrade(oldVersion, monitor);
                this.changed = true;
            }
            this.propertiesRestore();
            this.recordChanges = true;
            this.endTransaction(id, true);
            this.clearUndo(false);
            this.compilerSpec.registerProgramOptions(this);
            this.getCodeManager().activateContextLocking();
            success = true;
        }
        finally {
            dbh.closeScratchPad();
            if (!success) {
                this.release(consumer);
            }
        }
        ProgramUtilities.addTrackedProgram(this);
    }

    private void initCompilerSpec() throws CompilerSpecNotFoundException {
        try {
            this.compilerSpec = this.languageUpgradeTranslator != null ? this.languageUpgradeTranslator.getOldCompilerSpec(this.compilerSpecID) : this.language.getCompilerSpecByID(this.compilerSpecID);
        }
        catch (CompilerSpecNotFoundException e) {
            Msg.error((Object)this, (Object)("Compiler Spec " + this.compilerSpecID + " for Language " + this.language.getLanguageDescription().getDescription() + " Not Found, using default: " + e));
            this.compilerSpec = this.language.getDefaultCompilerSpec();
            if (this.compilerSpec == null) {
                throw e;
            }
            this.compilerSpecID = this.compilerSpec.getCompilerSpecID();
        }
    }

    private VersionException checkLanguageVersion(int openMode) throws LanguageNotFoundException {
        if (this.language.getVersion() > this.languageVersion) {
            Language newLanguage = this.language;
            Language oldLanguage = OldLanguageFactory.getOldLanguageFactory().getOldLanguage(this.languageID, this.languageVersion);
            if (oldLanguage == null) {
                Msg.error((Object)this, (Object)("Old language specification not found: " + this.languageID + " (Version " + this.languageVersion + ")"));
                return new VersionException(true);
            }
            this.languageUpgradeTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(oldLanguage, newLanguage);
            if (this.languageUpgradeTranslator == null) {
                throw new LanguageNotFoundException(this.language.getLanguageID(), "(Ver " + this.languageVersion + "." + this.languageMinorVersion + " -> " + newLanguage.getVersion() + "." + newLanguage.getMinorVersion() + ") language version translation not supported");
            }
            this.language = oldLanguage;
            return new VersionException(true);
        }
        if (this.language.getVersion() == this.languageVersion && this.language.getMinorVersion() > this.languageMinorVersion) {
            return new VersionException(true);
        }
        if (this.language.getMinorVersion() != this.languageMinorVersion || this.language.getVersion() != this.languageVersion) {
            throw new LanguageNotFoundException(this.language.getLanguageID(), this.languageVersion, this.languageMinorVersion);
        }
        return null;
    }

    private VersionException checkForLanguageChange(LanguageNotFoundException e, int openMode) throws LanguageNotFoundException {
        LanguageID newLangName;
        this.languageUpgradeTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(this.languageID, this.languageVersion);
        if (this.languageUpgradeTranslator == null) {
            throw e;
        }
        this.language = this.languageUpgradeTranslator.getOldLanguage();
        this.languageID = this.language.getLanguageID();
        VersionException ve = new VersionException(true);
        LanguageID oldLangName = this.languageUpgradeTranslator.getOldLanguage().getLanguageID();
        Object message = oldLangName.equals(newLangName = this.languageUpgradeTranslator.getNewLanguage().getLanguageID()) ? "Program requires a processor language version change" : "Program requires a processor language change to: " + newLangName;
        ve.setDetailMessage((String)message);
        return ve;
    }

    protected void setDomainFile(DomainFile df) {
        super.setDomainFile(df);
        this.recordChanges = true;
    }

    private void propertiesRestore() {
        Options pl = this.getOptions("Program Information");
        boolean origChangeState = this.changed;
        pl.registerOption(EXECUTABLE_PATH, (Object)UNKNOWN, null, "Original import path of program image");
        pl.registerOption(EXECUTABLE_FORMAT, (Object)UNKNOWN, null, "Original program image format");
        pl.registerOption("Created With Ghidra Version", (Object)"3.0 or earlier", null, "Version of Ghidra used to create this program.");
        pl.registerOption("Date Created", (Object)JANUARY_1_1970, null, "Date this program was created");
        this.changed = origChangeState;
    }

    private void propertiesCreate() {
        Options pl = this.getOptions("Program Information");
        boolean origChangeState = this.changed;
        pl.setString(EXECUTABLE_PATH, UNKNOWN);
        pl.setString(EXECUTABLE_FORMAT, UNKNOWN);
        pl.setString("Created With Ghidra Version", Application.getApplicationVersion());
        pl.setDate("Date Created", new Date());
        this.changed = origChangeState;
    }

    void setProgramUserData(ProgramUserDataDB programUserData) {
        this.programUserData = programUserData;
    }

    @Override
    public ProgramUserData getProgramUserData() {
        if (this.programUserData == null) {
            try {
                this.programUserData = new ProgramUserDataDB(this);
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        return this.programUserData;
    }

    protected FileSystem getAssociatedUserFilesystem() {
        return super.getAssociatedUserFilesystem();
    }

    protected DomainObjectAdapterDB getUserData() {
        return this.programUserData;
    }

    @Override
    public Listing getListing() {
        return this.listing;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return (SymbolTable)((Object)this.managers[2]);
    }

    @Override
    public ExternalManager getExternalManager() {
        return (ExternalManager)((Object)this.managers[5]);
    }

    @Override
    public EquateTable getEquateTable() {
        return (EquateTable)((Object)this.managers[8]);
    }

    @Override
    public Memory getMemory() {
        return this.memoryManager;
    }

    public NamespaceManager getNamespaceManager() {
        return (NamespaceManager)this.managers[3];
    }

    @Override
    public ReferenceManager getReferenceManager() {
        return (ReferenceManager)((Object)this.managers[6]);
    }

    public CodeManager getCodeManager() {
        return (CodeManager)this.managers[1];
    }

    public TreeManager getTreeManager() {
        return (TreeManager)this.managers[12];
    }

    @Override
    public ProgramDataTypeManager getDataTypeManager() {
        return (ProgramDataTypeManager)this.managers[7];
    }

    @Override
    public FunctionManager getFunctionManager() {
        return (FunctionManagerDB)this.managers[4];
    }

    @Override
    public BookmarkManager getBookmarkManager() {
        return (BookmarkManager)((Object)this.managers[9]);
    }

    @Override
    public RelocationTable getRelocationTable() {
        return (RelocationManager)this.managers[13];
    }

    @Override
    public String getCompiler() {
        String compiler = null;
        Options pl = this.getOptions("Program Information");
        compiler = pl.getString(COMPILER, UNKNOWN);
        return compiler == null ? UNKNOWN : compiler;
    }

    @Override
    public void setCompiler(String compiler) {
        Options pl = this.getOptions("Program Information");
        pl.setString(COMPILER, compiler);
        this.changed = true;
    }

    @Override
    public String getExecutablePath() {
        String path = null;
        Options pl = this.getOptions("Program Information");
        path = pl.getString(EXECUTABLE_PATH, UNKNOWN);
        return path == null ? UNKNOWN : path;
    }

    @Override
    public void setExecutablePath(String path) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_PATH, path);
        this.changed = true;
    }

    @Override
    public String getExecutableFormat() {
        String format = null;
        try {
            Options pl = this.getOptions("Program Information");
            format = pl.getString(EXECUTABLE_FORMAT, (String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format == null ? UNKNOWN : format;
    }

    @Override
    public void setExecutableFormat(String format) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_FORMAT, format);
        this.changed = true;
    }

    @Override
    public String getExecutableMD5() {
        String format = null;
        try {
            Options pl = this.getOptions("Program Information");
            format = pl.getString(EXECUTABLE_MD5, (String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format == null ? UNKNOWN : format;
    }

    @Override
    public void setExecutableMD5(String md5) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_MD5, md5);
        this.changed = true;
    }

    @Override
    public String getExecutableSHA256() {
        String format = null;
        try {
            Options pl = this.getOptions("Program Information");
            format = pl.getString(EXECUTABLE_SHA256, (String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format == null ? UNKNOWN : format;
    }

    @Override
    public void setExecutableSHA256(String sha256) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_SHA256, sha256);
        this.changed = true;
    }

    @Override
    public Date getCreationDate() {
        Options pl = this.getOptions("Program Information");
        return pl.getDate("Date Created", new Date(0L));
    }

    @Override
    public int getDefaultPointerSize() {
        return this.compilerSpec.getDataOrganization().getPointerSize();
    }

    @Override
    public LanguageID getLanguageID() {
        return this.languageID;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    @Override
    public PropertyMapManager getUsrPropertyManager() {
        return (PropertyMapManager)((Object)this.managers[11]);
    }

    @Override
    public ProgramContext getProgramContext() {
        return (ProgramContext)((Object)this.managers[10]);
    }

    @Override
    public Address getMinAddress() {
        return this.memoryManager.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        return this.memoryManager.getMaxAddress();
    }

    @Override
    public ProgramChangeSet getChanges() {
        return (ProgramChangeSet)this.changeSet;
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    @Override
    public AddressMap getAddressMap() {
        return this.addrMap;
    }

    @Override
    public Address[] parseAddress(String addrStr) {
        return this.parseAddress(addrStr, true);
    }

    @Override
    public Address[] parseAddress(String addrStr, boolean caseSensitive) {
        int pos = addrStr.lastIndexOf(":");
        if (pos >= 0) {
            MemoryBlock[] blocks;
            String spaceName = addrStr.substring(0, pos);
            if (spaceName.endsWith(":")) {
                spaceName = spaceName.substring(0, spaceName.length() - 1);
            }
            String offsetStr = addrStr.substring(pos + 1);
            for (MemoryBlock block : blocks = this.memoryManager.getBlocks()) {
                if (!StringUtilities.equals((String)spaceName, (String)block.getName(), (boolean)caseSensitive)) continue;
                try {
                    Address addr = block.getStart().getAddress(offsetStr);
                    if (addr == null || !block.contains(addr)) continue;
                    return new Address[]{addr};
                }
                catch (AddressFormatException e) {
                    return new Address[0];
                }
            }
        }
        if (addrStr.endsWith("h")) {
            addrStr = addrStr.substring(0, addrStr.length() - 1);
        }
        return this.addressFactory.getAllAddresses(addrStr, caseSensitive);
    }

    public void dataTypeChanged(long dataTypeID, int type, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).dataTypeChanged(dataTypeID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, null, oldValue, newValue));
        try {
            this.managers[2].invalidateCache(true);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    public void dataTypeAdded(long dataTypeID, int type, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).dataTypeAdded(dataTypeID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, null, oldValue, newValue));
    }

    public void categoryChanged(long categoryID, int type, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).categoryChanged(categoryID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, null, oldValue, newValue));
    }

    public void categoryAdded(long categoryID, int type, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).categoryAdded(categoryID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, null, oldValue, newValue));
    }

    public void sourceArchiveAdded(UniversalID sourceArchiveID, int type) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).sourceArchiveAdded(sourceArchiveID.getValue());
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, sourceArchiveID, null, null));
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID, int type) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).sourceArchiveChanged(sourceArchiveID.getValue());
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, sourceArchiveID, null, null));
    }

    public void programTreeAdded(long id, int type, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).programTreeAdded(id);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, null, oldValue, newValue));
    }

    public void programTreeChanged(long id, int type, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).programTreeChanged(id);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, affectedObj, oldValue, newValue));
    }

    public void tagChanged(FunctionTag tag, int type, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            long tagID = tag.getId();
            ((ProgramDBChangeSet)this.changeSet).tagChanged(tagID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, tag, oldValue, newValue));
    }

    public void tagCreated(FunctionTag tag, int type) {
        if (this.recordChanges) {
            long tagID = tag.getId();
            ((ProgramDBChangeSet)this.changeSet).tagCreated(tagID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, tag, null, null));
    }

    public void symbolChanged(Symbol symbol, int type, Address addr, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            Namespace parentNamespace;
            if (!symbol.isDynamic()) {
                long symbolID = symbol.getID();
                ((ProgramDBChangeSet)this.changeSet).symbolChanged(symbolID);
            }
            if (symbol instanceof VariableSymbolDB && (parentNamespace = symbol.getParentNamespace()) instanceof Function) {
                Function function = (Function)parentNamespace;
                Address entryPoint = function.getEntryPoint();
                this.updateChangeSet(entryPoint, entryPoint);
                this.fireEvent(new ProgramChangeRecord(152, entryPoint, entryPoint, function, null, null));
            }
            if (addr != null) {
                this.updateChangeSet(addr, addr);
            }
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, addr, addr, affectedObj, oldValue, newValue));
    }

    public void symbolAdded(Symbol symbol, int type, Address addr, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            if (!symbol.isDynamic()) {
                long symbolID = symbol.getID();
                ((ProgramDBChangeSet)this.changeSet).symbolAdded(symbolID);
            }
            if (symbol instanceof VariableSymbolDB) {
                long nameSpaceID = symbol.getParentNamespace().getID();
                Function function = this.getFunctionManager().getFunction(nameSpaceID);
                if (function != null) {
                    Address entryPoint = function.getEntryPoint();
                    this.updateChangeSet(entryPoint, entryPoint);
                    this.fireEvent(new ProgramChangeRecord(152, entryPoint, entryPoint, function, null, null));
                }
            }
            if (addr != null) {
                this.updateChangeSet(addr, addr);
            }
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, addr, addr, null, oldValue, newValue));
    }

    @Override
    public void setRegisterValuesChanged(Register register, Address start, Address end) {
        if (this.recordChanges) {
            if (register != null && register.isProcessorContext()) {
                this.updateChangeSet(start, end);
            } else {
                ((ProgramDBChangeSet)this.changeSet).addRegisterRange(start, end);
            }
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(131, start, end, null, null, null));
    }

    @Override
    public void setChanged(int type, Object oldValue, Object newValue) {
        this.setChanged(type, null, null, oldValue, newValue);
    }

    @Override
    public void setChanged(int type, Address start, Address end, Object oldValue, Object newValue) {
        Address newstart = null;
        Address newend = null;
        if (start != null) {
            newstart = start;
        }
        if (end != null) {
            newend = end;
        }
        if (this.recordChanges) {
            this.updateChangeSet(newstart, newend);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, newstart, newend, null, oldValue, newValue));
    }

    @Override
    public void setObjChanged(int type, Object affectedObj, Object oldValue, Object newValue) {
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, affectedObj, oldValue, newValue));
    }

    @Override
    public void setObjChanged(int type, int subType, Object affectedObj, Object oldValue, Object newValue) {
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, subType, null, null, affectedObj, oldValue, newValue));
    }

    @Override
    public void setObjChanged(int type, Address addr, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(addr, addr);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, addr, addr, affectedObj, oldValue, newValue));
    }

    @Override
    public void setObjChanged(int type, int subType, Address addr, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(addr, addr);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, subType, addr, addr, affectedObj, oldValue, newValue));
    }

    @Override
    public void setObjChanged(int type, AddressSetView addrSet, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(addrSet);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(type, null, null, affectedObj, oldValue, newValue));
    }

    private void updateChangeSet(Address start, Address end) {
        ProgramDBChangeSet pcs = (ProgramDBChangeSet)this.changeSet;
        if (start != null) {
            pcs.addRange(start, end != null ? end : start);
        } else if (end != null) {
            pcs.addRange(end, end);
        }
    }

    private void updateChangeSet(AddressSetView addrSet) {
        if (addrSet != null) {
            ((ProgramDBChangeSet)this.changeSet).add(addrSet);
        }
    }

    @Override
    public void setPropertyChanged(String propertyName, Address codeUnitAddr, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(codeUnitAddr, null);
        }
        this.changed = true;
        this.fireEvent(new CodeUnitPropertyChangeRecord(propertyName, codeUnitAddr, oldValue, newValue));
    }

    @Override
    public void setPropertyRangeRemoved(String propertyName, Address start, Address end) {
        if (this.recordChanges) {
            this.updateChangeSet(start, end);
        }
        this.changed = true;
        this.fireEvent(new CodeUnitPropertyChangeRecord(propertyName, start, end));
    }

    void userDataChanged(String propertyName, Address codeUnitAddr, Object oldValue, Object newValue) {
        this.fireEvent(new CodeUnitUserDataChangeRecord(propertyName, codeUnitAddr, oldValue, newValue));
    }

    protected void userDataChanged(String propertyName, Object oldValue, Object newValue) {
        this.fireEvent(new UserDataChangeRecord(propertyName, this.name, this.name));
    }

    public void setName(String newName) {
        this.lock.acquire();
        try {
            if (this.name.equals(newName)) {
                return;
            }
            Record record = this.table.getRecord((Field)new StringField(PROGRAM_NAME));
            record.setString(0, newName);
            this.table.putRecord(record);
            this.getTreeManager().setProgramName(this.name, newName);
            super.setName(newName);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void refreshName() throws IOException {
        Record record = this.table.getRecord((Field)new StringField(PROGRAM_NAME));
        this.name = record.getString(0);
    }

    private void refreshImageBase() throws IOException {
        Address currentImageBase;
        long baseOffset = this.getStoredBaseImageOffset();
        this.storedImageBase = this.addressFactory.getDefaultAddressSpace().getAddress(baseOffset);
        if (!this.imageBaseOverride && !(currentImageBase = this.getImageBase()).equals(this.storedImageBase)) {
            currentImageBase = this.storedImageBase;
            this.addrMap.setImageBase(currentImageBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSpace addOverlaySpace(String blockName, AddressSpace originalSpace, long minOffset, long maxOffset) throws LockException, MemoryConflictException {
        this.checkExclusiveAccess();
        if (this.imageBaseOverride) {
            throw new MemoryConflictException("Overlay spaces may not be created while an image-base override is active");
        }
        OverlayAddressSpace ovSpace = null;
        this.lock.acquire();
        try {
            ovSpace = this.addressFactory.addOverlayAddressSpace(blockName, false, originalSpace, minOffset, maxOffset);
            this.overlaySpaceAdapter.addOverlaySpace(ovSpace);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return ovSpace;
    }

    public void renameOverlaySpace(String oldOverlaySpaceName, String newName) throws LockException {
        this.checkExclusiveAccess();
        String revisedName = this.addressFactory.renameOverlaySpace(oldOverlaySpaceName, newName);
        if (!revisedName.equals(oldOverlaySpaceName)) {
            try {
                this.overlaySpaceAdapter.renameOverlaySpace(oldOverlaySpaceName, revisedName);
                this.addrMap.renameOverlaySpace(oldOverlaySpaceName, revisedName);
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOverlaySpace(AddressSpace overlaySpace) throws LockException {
        this.lock.acquire();
        try {
            MemoryBlock[] blocks;
            this.checkExclusiveAccess();
            for (MemoryBlock block : blocks = this.memoryManager.getBlocks()) {
                if (!block.getStart().getAddressSpace().equals(overlaySpace)) continue;
                boolean bl = false;
                return bl;
            }
            this.addressFactory.removeOverlaySpace(overlaySpace.getName());
            this.overlaySpaceAdapter.removeOverlaySpace(overlaySpace.getName());
            this.addrMap.deleteOverlaySpace(overlaySpace.getName());
            this.clearCache(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    private long getStoredBaseImageOffset() throws IOException {
        Record rec = this.table.getRecord((Field)new StringField(IMAGE_OFFSET));
        if (rec != null) {
            return new BigInteger(rec.getString(0), 16).longValue();
        }
        return 0L;
    }

    @Override
    public Address getImageBase() {
        return this.addrMap.getImageBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImageBase(Address base, boolean commit) throws AddressOverflowException, LockException, IllegalStateException {
        if (commit) {
            this.checkExclusiveAccess();
        }
        this.lock.acquire();
        try {
            MemoryBlock[] blocks;
            Address currentImageBase = this.getImageBase();
            if (!(commit && this.imageBaseOverride || !base.equals(currentImageBase))) {
                return;
            }
            if (!this.addressFactory.getDefaultAddressSpace().equals(base.getAddressSpace())) {
                throw new IllegalArgumentException("Base address must be default space");
            }
            for (MemoryBlock block : blocks = this.getMemory().getBlocks()) {
                if (!block.getStart().hasSameAddressSpace(base)) continue;
                try {
                    long distanceFromBase = block.getStart().subtract(currentImageBase);
                    Address newStart = base.addWrap(distanceFromBase);
                    newStart.addNoWrap(block.getSize() - 1L);
                }
                catch (AddressOverflowException e) {
                    throw new AddressOverflowException("wrapped memory block: " + block.getName());
                }
            }
            Address oldBase = currentImageBase;
            this.addrMap.setImageBase(base);
            if (commit) {
                try {
                    Record record = SCHEMA.createRecord((Field)new StringField(IMAGE_OFFSET));
                    record.setString(0, Long.toHexString(base.getOffset()));
                    this.table.putRecord(record);
                    this.storedImageBase = base;
                    this.imageBaseOverride = false;
                    this.setChanged(27, oldBase, base);
                    this.invalidate();
                    ((SymbolManager)this.managers[2]).imageBaseChanged(oldBase, base);
                    this.changed = true;
                }
                catch (IOException e) {
                    this.dbError(e);
                }
            } else {
                this.imageBaseOverride = true;
            }
            this.invalidate();
        }
        finally {
            this.lock.release();
        }
        ((TreeManager)this.managers[12]).imageBaseChanged(commit);
        this.flushEvents();
    }

    @Override
    public void restoreImageBase() {
        if (!this.imageBaseOverride) {
            return;
        }
        this.lock.acquire();
        try {
            this.imageBaseOverride = false;
            this.invalidate();
        }
        finally {
            this.lock.release();
        }
        ((TreeManager)this.managers[12]).imageBaseChanged(false);
        this.flushEvents();
    }

    public String getDescription() {
        return "Program";
    }

    private void createDatabase() throws IOException {
        this.table = this.dbh.createTable("Program", SCHEMA);
        Record record = SCHEMA.createRecord((Field)new StringField(PROGRAM_NAME));
        record.setString(0, this.name);
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(OLD_LANGUAGE_NAME));
        record.setString(0, this.languageID.getIdAsString());
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_ID));
        record.setString(0, this.languageID.getIdAsString());
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(COMPILER_SPEC_ID));
        record.setString(0, this.compilerSpecID.getIdAsString());
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_VERSION));
        record.setString(0, this.languageVersion + "." + this.languageMinorVersion);
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(PROGRAM_DB_VERSION));
        record.setString(0, Integer.toString(21));
        this.table.putRecord(record);
    }

    private VersionException initializeDatabase(int openMode) throws IOException, VersionException, LanguageNotFoundException {
        boolean requiresUpgrade = false;
        this.table = this.dbh.getTable("Program");
        if (this.table == null) {
            throw new IOException("Unsupported File Content");
        }
        Record record = this.table.getRecord((Field)new StringField(PROGRAM_NAME));
        this.name = record.getString(0);
        record = this.table.getRecord((Field)new StringField(LANGUAGE_ID));
        if (record == null) {
            record = this.table.getRecord((Field)new StringField(OLD_LANGUAGE_NAME));
            String oldLanguageName = record.getString(0);
            LanguageCompilerSpecPair languageCompilerSpecPair = OldLanguageMappingService.lookupMagicString(oldLanguageName, false);
            if (languageCompilerSpecPair == null) {
                throw new LanguageNotFoundException(oldLanguageName);
            }
            this.languageID = languageCompilerSpecPair.languageID;
            this.compilerSpecID = languageCompilerSpecPair.compilerSpecID;
            if (openMode != 3) {
                requiresUpgrade = true;
            } else {
                record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_ID));
                record.setString(0, this.languageID.getIdAsString());
                this.table.putRecord(record);
                record = SCHEMA.createRecord((Field)new StringField(COMPILER_SPEC_ID));
                record.setString(0, this.compilerSpecID.getIdAsString());
                this.table.putRecord(record);
            }
        } else {
            this.languageID = new LanguageID(record.getString(0));
            record = this.table.getRecord((Field)new StringField(COMPILER_SPEC_ID));
            this.compilerSpecID = new CompilerSpecID(record.getString(0));
        }
        record = this.table.getRecord((Field)new StringField(LANGUAGE_VERSION));
        String languageVersionStr = record == null ? LANG_DEFAULT_VERSION : record.getString(0);
        String[] vs = languageVersionStr.split("\\.");
        this.languageVersion = 1;
        this.languageMinorVersion = 0;
        try {
            this.languageVersion = Integer.parseInt(vs[0]);
            this.languageMinorVersion = Integer.parseInt(vs[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int storedVersion = this.getStoredVersion();
        if (storedVersion > 21) {
            throw new VersionException(2, false);
        }
        if (openMode != 3 && storedVersion < 19) {
            requiresUpgrade = true;
        }
        if (openMode == 1 && storedVersion < 21) {
            requiresUpgrade = true;
        }
        return requiresUpgrade ? new VersionException(true) : null;
    }

    private void upgradeDatabase(TaskMonitor monitor) throws IOException, CancelledException {
        this.performPropertyListAlterations(ObsoleteProgramPropertiesService.getObsoleteProgramProperties(), monitor);
        this.checkFunctionWrappedPointers(monitor);
        this.table = this.dbh.getTable("Program");
        StringField key = new StringField(PROGRAM_DB_VERSION);
        String versionStr = Integer.toString(21);
        Record record = this.table.getRecord((Field)key);
        if (record != null && versionStr.equals(record.getString(0))) {
            return;
        }
        record = SCHEMA.createRecord((Field)key);
        record.setString(0, versionStr);
        this.table.putRecord(record);
    }

    private void postUpgrade(int oldVersion, TaskMonitor monitor) throws CancelledException, IOException {
        if (oldVersion < 18) {
            ((FunctionManagerDB)this.getFunctionManager()).initSignatureSource(monitor);
        } else if (oldVersion < 19) {
            ((FunctionManagerDB)this.getFunctionManager()).removeExplicitThisParameters(monitor);
        }
    }

    public int getStoredVersion() throws IOException {
        Record record = this.table.getRecord((Field)new StringField(PROGRAM_DB_VERSION));
        if (record != null) {
            String s = record.getString(0);
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private void checkOldProperties(int openMode, TaskMonitor monitor) throws IOException, VersionException {
        int storedVersion;
        Record record = this.table.getRecord((Field)new StringField(EXECUTE_PATH));
        if (record != null) {
            if (openMode == 2) {
                return;
            }
            if (openMode != 3) {
                throw new VersionException(true);
            }
            Options pl = this.getOptions("Program Information");
            String value = record.getString(0);
            pl.setString(EXECUTABLE_PATH, value);
            this.table.deleteRecord(record.getKeyField());
            record = this.table.getRecord((Field)new StringField(EXECUTE_FORMAT));
            if (record != null) {
                pl.setString(EXECUTABLE_FORMAT, value);
                this.table.deleteRecord(record.getKeyField());
            }
        }
        if ((storedVersion = this.getStoredVersion()) < 9) {
            if (openMode == 2) {
                return;
            }
            if (openMode != 3) {
                throw new VersionException(true);
            }
            Options oldList = this.getOptions("Analysis");
            for (String propertyName : oldList.getOptionNames()) {
                oldList.removeOption(propertyName);
            }
        }
        if (storedVersion < 11) {
            if (openMode == 2) {
                return;
            }
            if (openMode != 3) {
                throw new VersionException(true);
            }
        }
    }

    private void checkFunctionWrappedPointers(TaskMonitor monitor) throws IOException, CancelledException {
        int storedVersion = this.getStoredVersion();
        if (storedVersion < 17) {
            FunctionManager functionManager = this.getFunctionManager();
            SymbolTable symbolTable = this.getSymbolTable();
            monitor.setProgress(0L);
            monitor.setMaximum((long)functionManager.getFunctionCount());
            int cnt = 0;
            for (Symbol functionSymbol : symbolTable.getSymbols(this.memoryManager, SymbolType.FUNCTION, true)) {
                monitor.checkCanceled();
                ProgramUtilities.convertFunctionWrappedExternalPointer(functionSymbol);
                monitor.setProgress((long)(++cnt));
            }
        } else {
            return;
        }
    }

    private VersionException createManagers(int openMode, TaskMonitor monitor) throws CancelledException, IOException {
        VersionException versionExc = null;
        this.overlaySpaceAdapter = new OverlaySpaceAdapterDB(this.dbh);
        this.overlaySpaceAdapter.initializeOverlaySpaces(this.addressFactory);
        monitor.checkCanceled();
        try {
            this.checkOldProperties(openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        long baseImageOffset = this.getStoredBaseImageOffset();
        try {
            this.addrMap = new AddressMapDB(this.dbh, openMode, this.addressFactory, baseImageOffset, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
            try {
                this.addrMap = new AddressMapDB(this.dbh, 2, this.addressFactory, baseImageOffset, monitor);
            }
            catch (VersionException e1) {
                if (e1.isUpgradable()) {
                    Msg.error((Object)this, (Object)"AddressMapDB is upgradeable but failed to support READ-ONLY mode!");
                }
                return versionExc;
            }
        }
        monitor.checkCanceled();
        try {
            this.memoryManager = new MemoryMapDB(this.dbh, this.addrMap, openMode, this.language.isBigEndian(), this.lock, monitor);
            this.managers[0] = this.memoryManager;
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[1] = new CodeManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[4] = new FunctionManagerDB(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            if (!e.isUpgradable()) {
                try {
                    this.oldFunctionMgr = new OldFunctionManager(this.dbh, (ErrorHandler)this, this.addrMap);
                    if (openMode != 3) {
                        this.oldFunctionMgr = null;
                        versionExc = new VersionException(true).combine(versionExc);
                    }
                    this.managers[4] = new FunctionManagerDB(this.dbh, this.addrMap, 0, this.lock, monitor);
                }
                catch (VersionException versionException) {}
            }
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[5] = new ExternalManagerDB(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[2] = new SymbolManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[3] = new NamespaceManager(this.dbh, (ErrorHandler)this, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[6] = new ReferenceDBManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[8] = new EquateManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[7] = new ProgramDataTypeManager(this.dbh, this.addrMap, openMode, (ErrorHandler)this, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[11] = new DBPropertyMapManager(this.dbh, this, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[9] = new BookmarkDBManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[12] = new TreeManager(this.dbh, (ErrorHandler)this, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[13] = new RelocationManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        try {
            this.managers[10] = new ProgramRegisterContextDB(this.dbh, (ErrorHandler)this, this.language, this.compilerSpec, this.addrMap, this.lock, openMode, (CodeManager)this.managers[1], monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCanceled();
        return versionExc;
    }

    private void initManagers(int openMode, TaskMonitor monitor) throws CancelledException, IOException {
        int i;
        this.globalNamespace = new GlobalNamespace(this.getMemory());
        for (i = 0; i < 14; ++i) {
            monitor.checkCanceled();
            this.managers[i].setProgram(this);
        }
        this.listing.setProgram(this);
        monitor.checkCanceled();
        if (openMode == 3 && this.oldFunctionMgr != null) {
            this.oldFunctionMgr.upgrade(this, monitor);
        }
        for (i = 0; i < 14; ++i) {
            monitor.checkCanceled();
            this.managers[i].programReady(openMode, this.getStoredVersion(), monitor);
        }
    }

    protected void clearCache(boolean all) {
        this.lock.acquire();
        try {
            super.clearCache(all);
            this.refreshName();
            this.overlaySpaceAdapter.updateOverlaySpaces(this.addressFactory);
            this.addrMap.invalidateCache();
            if (!this.imageBaseOverride) {
                this.refreshImageBase();
            }
            for (int i = 0; i < 14; ++i) {
                this.managers[i].invalidateCache(all);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void invalidate() {
        this.clearCache(false);
        this.fireEvent(new DomainObjectChangeRecord(4));
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    @Override
    public Register getRegister(Address addr) {
        return this.language.getRegister(this.getGlobalAddress(addr), 0);
    }

    @Override
    public Register[] getRegisters(Address addr) {
        return this.language.getRegisters(this.getGlobalAddress(addr));
    }

    @Override
    public Register getRegister(Address addr, int size) {
        return this.language.getRegister(this.getGlobalAddress(addr), size);
    }

    @Override
    public Register getRegister(Varnode varnode) {
        return this.language.getRegister(this.getGlobalAddress(varnode.getAddress()), varnode.getSize());
    }

    private Address getGlobalAddress(Address addr) {
        if (addr instanceof OldGenericNamespaceAddress) {
            return ((OldGenericNamespaceAddress)addr).getGlobalAddress();
        }
        return addr;
    }

    @Override
    public Register getRegister(String regName) {
        return this.language.getRegister(regName);
    }

    protected void setChanged(boolean b) {
        super.setChanged(b);
    }

    void setChangeSet(ProgramDBChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws RollbackException {
        this.lock.acquire();
        try {
            for (int i = 13; i >= 0; --i) {
                this.managers[i].deleteAddressRange(startAddr, endAddr, monitor);
            }
            this.clearCache(false);
            Iterator<String> iter = this.addrSetPropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                AddressSetPropertyMapDB pm = this.addrSetPropertyMap.get(iter.next());
                pm.remove(startAddr, endAddr);
            }
            iter = this.intRangePropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                IntRangeMap map = this.intRangePropertyMap.get(iter.next());
                map.clearValue(startAddr, endAddr);
            }
        }
        catch (CancelledException e) {
            throw new RollbackException("Operation cancelled");
        }
        finally {
            this.lock.release();
        }
    }

    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, RollbackException {
        this.lock.acquire();
        try {
            for (int i = 13; i >= 0; --i) {
                this.managers[i].moveAddressRange(fromAddr, toAddr, length, monitor);
            }
            this.clearCache(false);
            Iterator<String> iter = this.addrSetPropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                AddressSetPropertyMapDB pm = this.addrSetPropertyMap.get(iter.next());
                pm.moveAddressRange(fromAddr, toAddr, length, monitor);
            }
            iter = this.intRangePropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                IntRangeMap map = this.intRangePropertyMap.get(iter.next());
                map.moveAddressRange(fromAddr, toAddr, length, monitor);
            }
        }
        catch (CancelledException e) {
            throw new RollbackException("Operation cancelled");
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    @Override
    public void setLanguage(Language newLanguage, CompilerSpecID newCompilerSpecID, boolean forceRedisassembly, TaskMonitor monitor) throws IllegalStateException, IncompatibleLanguageException, LockException {
        if (newLanguage == this.language) {
            this.setLanguage((LanguageTranslator)null, newCompilerSpecID, forceRedisassembly, monitor);
            return;
        }
        LanguageTranslator languageTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(this.language, newLanguage);
        if (languageTranslator == null) {
            throw new IncompatibleLanguageException("Language translation not supported");
        }
        this.setLanguage(languageTranslator, newCompilerSpecID, forceRedisassembly, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguage(LanguageTranslator translator, CompilerSpecID newCompilerSpecID, boolean forceRedisassembly, TaskMonitor monitor) throws LockException {
        this.checkExclusiveAccess();
        this.lock.acquire();
        try {
            this.setEventsEnabled(false);
            try {
                boolean redisassemblyRequired = true;
                int oldLanguageVersion = this.languageVersion;
                int oldLanguageMinorVersion = this.languageMinorVersion;
                if (translator != null) {
                    this.language = translator.getNewLanguage();
                    this.languageID = this.language.getLanguageID();
                    if (newCompilerSpecID == null) {
                        newCompilerSpecID = translator.getNewCompilerSpecID(this.compilerSpecID);
                    }
                    Msg.info((Object)this, (Object)("Setting language for Program " + this.getName() + ": " + translator));
                    Msg.info((Object)this, (Object)("Setting compiler spec for Program " + this.getName() + ": " + this.compilerSpecID + " -> " + newCompilerSpecID));
                } else if (!forceRedisassembly && this.language.getVersion() == this.languageVersion && this.language.getMinorVersion() == this.languageMinorVersion) {
                    redisassemblyRequired = false;
                    Msg.info((Object)this, (Object)("Setting compiler spec for Program " + this.getName() + ": " + this.compilerSpecID + " -> " + newCompilerSpecID));
                } else {
                    Msg.info((Object)this, (Object)("Updating language version for Program " + this.getName() + ": " + this.language.getLanguageDescription() + " (Version " + this.language.getVersion() + ")"));
                }
                if (newCompilerSpecID != null) {
                    this.compilerSpec = this.language.getCompilerSpecByID(newCompilerSpecID);
                }
                this.compilerSpecID = this.compilerSpec.getCompilerSpecID();
                this.languageVersion = this.language.getVersion();
                this.languageMinorVersion = this.language.getMinorVersion();
                if (translator != null) {
                    this.addressFactory = new ProgramAddressFactory(this.language, this.compilerSpec);
                    this.addrMap.setLanguage(this.language, this.addressFactory, translator);
                    this.overlaySpaceAdapter.setLanguage(this.language, this.addressFactory, translator);
                    this.memoryManager.setLanguage(this.language);
                    this.addrMap.memoryMapChanged(this.memoryManager);
                    monitor.setMessage("Updating symbols...");
                    ((SymbolManager)this.getSymbolTable()).setLanguage(translator, monitor);
                    ((ExternalManagerDB)this.getExternalManager()).setLanguage(translator, monitor);
                    ((FunctionManagerDB)this.getFunctionManager()).setLanguage(translator, monitor);
                }
                this.clearCache(true);
                monitor.setMessage("Updating language...");
                monitor.setProgress(0L);
                ProgramRegisterContextDB contextMgr = (ProgramRegisterContextDB)this.getProgramContext();
                if (redisassemblyRequired) {
                    contextMgr.setLanguage(translator, this.compilerSpec, this.memoryManager, monitor);
                    this.repairContext(oldLanguageVersion, oldLanguageMinorVersion, translator, monitor);
                    this.getCodeManager().reDisassembleAllInstructions(monitor);
                } else {
                    contextMgr.initializeDefaultValues(this.language, this.compilerSpec);
                }
                this.managers[4].setProgram(this);
                this.managers[4].programReady(1, this.getStoredVersion(), monitor);
                if (translator != null) {
                    translator.fixupInstructions(this, translator.getOldLanguage(), monitor);
                }
                Record record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_ID));
                record.setString(0, this.languageID.getIdAsString());
                this.table.putRecord(record);
                record = SCHEMA.createRecord((Field)new StringField(COMPILER_SPEC_ID));
                record.setString(0, this.compilerSpecID.getIdAsString());
                this.table.putRecord(record);
                record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_VERSION));
                record.setString(0, this.languageVersion + "." + this.languageMinorVersion);
                this.table.putRecord(record);
                this.setChanged(true);
                this.clearCache(true);
                this.invalidate();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Set language aborted - program object is now in an unusable state!", t);
            }
            finally {
                this.setEventsEnabled(true);
            }
            this.fireEvent(new DomainObjectChangeRecord(130));
        }
        finally {
            this.lock.release();
        }
    }

    private void repairContext(int oldLanguageVersion, int oldLanguageMinorVersion, LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        String processorName = this.language.getProcessor().toString();
        if ("ARM".equalsIgnoreCase(processorName)) {
            this.repairARMContext(oldLanguageVersion, oldLanguageMinorVersion, translator, monitor);
        }
    }

    private void repairARMContext(int oldLanguageVersion, int oldLanguageMinorVersion, LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        if (!(this.language instanceof SleighLanguage)) {
            return;
        }
        if (oldLanguageVersion != 1 || oldLanguageMinorVersion >= 6) {
            return;
        }
        monitor.setMessage("Checking ARM Context...");
        CodeManager codeManager = this.getCodeManager();
        monitor.setMaximum((long)codeManager.getNumInstructions());
        monitor.setProgress(0L);
        int cnt = 0;
        int repairCnt = 0;
        ProgramContext context = this.getProgramContext();
        Register contextReg = context.getBaseContextRegister();
        if (contextReg == null) {
            return;
        }
        Register thumbBitReg = context.getRegister("TMode");
        if (thumbBitReg == null) {
            return;
        }
        Register oldContextReg = contextReg;
        if (translator != null) {
            oldContextReg = translator.getOldContextRegister();
        }
        AddressRange contextRange = null;
        BigInteger lastStoredTMode = null;
        InstructionIterator instructions = codeManager.getInstructions(this.memoryManager.getLoadedAndInitializedAddressSet(), true);
        while (instructions.hasNext()) {
            monitor.checkCanceled();
            if (++cnt % 100 == 0) {
                monitor.setProgress((long)cnt);
            }
            InstructionDB instr = (InstructionDB)instructions.next();
            RegisterValue protoContextValue = instr.getOriginalPrototypeContext(oldContextReg);
            if (translator != null) {
                protoContextValue = translator.getNewRegisterValue(protoContextValue);
            }
            RegisterValue protoTModeValue = protoContextValue.getRegisterValue(thumbBitReg);
            BigInteger protoTMode = protoTModeValue.getUnsignedValue();
            Address addr = instr.getMinAddress();
            if (contextRange == null || !contextRange.contains(addr)) {
                contextRange = context.getRegisterValueRangeContaining(contextReg, addr);
                RegisterValue storedValue = context.getNonDefaultValue(contextReg, instr.getMinAddress());
                if (storedValue == null) {
                    lastStoredTMode = BigInteger.valueOf(0L);
                } else {
                    RegisterValue storedTModeValue = storedValue.getRegisterValue(thumbBitReg);
                    lastStoredTMode = storedTModeValue.getUnsignedValueIgnoreMask();
                }
            }
            if (protoTMode.equals(lastStoredTMode)) continue;
            try {
                context.setRegisterValue(addr, addr.add(instr.getLength() - 1), protoTModeValue);
                ++repairCnt;
            }
            catch (ContextChangeException e) {
                Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)((Object)e));
            }
            catch (AddressOutOfBoundsException e) {
                Msg.error((Object)this, (Object)("Unexpected instruction memory error at " + instr.getMaxAddress()), (Throwable)e);
            }
        }
        if (repairCnt != 0) {
            Msg.warn((Object)this, (Object)("Repaired ARM Tmode context at " + repairCnt + " locations"));
        }
        this.clearCache(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetPropertyMap createAddressSetPropertyMap(String mapName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            AddressSetPropertyMapDB map = AddressSetPropertyMapDB.createPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            this.addrSetPropertyMap.put(mapName, map);
            this.setChanged(166, null, mapName);
            AddressSetPropertyMapDB addressSetPropertyMapDB = map;
            return addressSetPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetPropertyMap getAddressSetPropertyMap(String mapName) {
        this.lock.acquire();
        try {
            AddressSetPropertyMapDB map = this.addrSetPropertyMap.get(mapName);
            if (map != null) {
                AddressSetPropertyMapDB addressSetPropertyMapDB = map;
                return addressSetPropertyMapDB;
            }
            map = AddressSetPropertyMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            if (map != null) {
                this.addrSetPropertyMap.put(mapName, map);
            }
            AddressSetPropertyMapDB addressSetPropertyMapDB = map;
            return addressSetPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void deleteAddressSetPropertyMap(String mapName) {
        this.lock.acquire();
        try {
            AddressSetPropertyMapDB pm = this.addrSetPropertyMap.remove(mapName);
            if (pm == null) {
                pm = AddressSetPropertyMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            }
            if (pm != null) {
                pm.delete();
                this.setChanged(167, null, mapName);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntRangeMapDB createIntRangeMap(String mapName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            IntRangeMapDB map = IntRangeMapDB.createPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            this.intRangePropertyMap.put(mapName, map);
            this.setChanged(170, null, mapName);
            IntRangeMapDB intRangeMapDB = map;
            return intRangeMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntRangeMap getIntRangeMap(String mapName) {
        this.lock.acquire();
        try {
            IntRangeMapDB rangeMap = this.intRangePropertyMap.get(mapName);
            if (rangeMap != null) {
                IntRangeMapDB intRangeMapDB = rangeMap;
                return intRangeMapDB;
            }
            rangeMap = IntRangeMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            if (rangeMap != null) {
                this.intRangePropertyMap.put(mapName, rangeMap);
            }
            IntRangeMapDB intRangeMapDB = rangeMap;
            return intRangeMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void deleteIntRangeMap(String mapName) {
        this.lock.acquire();
        try {
            IntRangeMapDB rangeMap = this.intRangePropertyMap.remove(mapName);
            if (rangeMap == null) {
                rangeMap = IntRangeMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            }
            if (rangeMap != null) {
                rangeMap.delete();
                this.setChanged(171, null, mapName);
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void close() {
        super.close();
        this.intRangePropertyMap.clear();
        this.addrSetPropertyMap.clear();
    }

    public Map<String, String> getMetadata() {
        this.metadata.clear();
        this.metadata.put(PROGRAM_NAME, this.getName());
        this.metadata.put(LANGUAGE_ID, this.languageID + " (" + this.languageVersion + "." + this.languageMinorVersion + ")");
        this.metadata.put("Compiler ID", this.compilerSpecID.getIdAsString());
        this.metadata.put("Processor", this.language.getProcessor().toString());
        this.metadata.put("Endian", this.memoryManager.isBigEndian() ? "Big" : "Little");
        this.metadata.put("Address Size", "" + this.addressFactory.getDefaultAddressSpace().getSize());
        this.metadata.put("Minimum Address", ProgramDB.getString(this.getMinAddress()));
        this.metadata.put("Maximum Address", ProgramDB.getString(this.getMaxAddress()));
        this.metadata.put("# of Bytes", this.getNumberOfBytes());
        this.metadata.put("# of Memory Blocks", "" + this.memoryManager.getBlocks().length);
        this.metadata.put("# of Instructions", "" + this.listing.getNumInstructions());
        this.metadata.put("# of Defined Data", "" + this.listing.getNumDefinedData());
        this.metadata.put("# of Functions", "" + this.getFunctionManager().getFunctionCount());
        this.metadata.put("# of Symbols", "" + this.getSymbolTable().getNumSymbols());
        this.metadata.put("# of Data Types", "" + this.getDataTypeManager().getDataTypeCount(true));
        this.metadata.put("# of Data Type Categories", "" + this.getDataTypeManager().getCategoryCount());
        Options propList = this.getOptions("Program Information");
        List propNames = propList.getOptionNames();
        Collections.sort(propNames);
        for (String propName : propNames) {
            String valueAsString;
            if (propName.indexOf(46) >= 0 || (valueAsString = propList.getValueAsString(propName)) == null) continue;
            this.metadata.put(propName, propList.getValueAsString(propName));
        }
        return this.metadata;
    }

    private static String getString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    private String getNumberOfBytes() {
        MemoryBlock[] blocks;
        long size = 0L;
        for (MemoryBlock block : blocks = this.memoryManager.getBlocks()) {
            size += block.getSize();
        }
        return "" + size;
    }

    protected void updateMetadata() throws IOException {
        this.getMetadata();
        super.updateMetadata();
    }

    public boolean lock(String reason) {
        if (super.lock(reason)) {
            if (this.programUserData == null || this.programUserData.lock(reason)) {
                return true;
            }
            super.unlock();
        }
        return false;
    }

    public void forceLock(boolean rollback, String reason) {
        super.forceLock(rollback, reason);
        if (this.programUserData != null) {
            this.programUserData.forceLock(rollback, reason);
        }
    }

    public void unlock() {
        super.unlock();
        if (this.programUserData != null) {
            this.programUserData.unlock();
        }
    }

    @Override
    public long getUniqueProgramID() {
        return this.dbh.getDatabaseId();
    }

    public void invalidateWriteCache() {
        ProgramRegisterContextDB contextMgr = (ProgramRegisterContextDB)this.getProgramContext();
        contextMgr.invalidateProcessorContextWriteCache();
        super.invalidateWriteCache();
    }

    public void flushWriteCache() {
        ProgramRegisterContextDB contextMgr = (ProgramRegisterContextDB)this.getProgramContext();
        contextMgr.flushProcessorContextWriteCache();
        super.flushWriteCache();
    }
}

