/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import java.math.BigInteger;

public class OpBehaviorIntSlessEqual
extends BinaryOpBehavior {
    public OpBehaviorIntSlessEqual() {
        super(14);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        long res;
        if (sizein <= 0) {
            res = 0L;
        } else {
            long bit2;
            long mask = 128L;
            long bit1 = in1 & (mask <<= 8 * (sizein - 1));
            res = bit1 != (bit2 = in2 & mask) ? (bit1 != 0L ? 1L : 0L) : (in1 <= in2 ? 1L : 0L);
        }
        return res;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (sizein <= 0) {
            return BigInteger.ZERO;
        }
        return (in1 = Utils.convertToSignedValue(in1, sizein)).compareTo(in2 = Utils.convertToSignedValue(in2, sizein)) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }
}

