/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.SymbolPath;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NamespaceUtils {
    private NamespaceUtils() {
    }

    public static String getNamespacePathWithoutLibrary(Namespace namespace) {
        Object str = new String();
        while (namespace != null && !(namespace instanceof GlobalNamespace) && !(namespace instanceof Library)) {
            str = namespace.getName() + "::" + (String)str;
            namespace = namespace.getParentNamespace();
        }
        return str;
    }

    public static String getNamespaceQualifiedName(Namespace namespace, String symbolName, boolean excludeLibraryName) {
        Object str = "";
        if (excludeLibraryName && namespace.isExternal()) {
            str = NamespaceUtils.getNamespacePathWithoutLibrary(namespace);
        } else if (namespace != null && !(namespace instanceof GlobalNamespace)) {
            str = namespace.getName(true) + "::";
        }
        str = (String)str + symbolName;
        return str;
    }

    @Deprecated
    public static List<String> splitNamespacePath(String path) {
        return Arrays.asList(path.trim().split("::"));
    }

    public static Library getLibrary(Namespace namespace) {
        Namespace ns = namespace;
        while (ns.isExternal()) {
            if (ns instanceof Library) {
                return (Library)ns;
            }
            ns = ns.getParentNamespace();
        }
        return null;
    }

    public static List<Namespace> getNamespacesByName(Program program, Namespace parent, String namespaceName) {
        NamespaceUtils.validate(program, parent);
        ArrayList<Namespace> namespaceList = new ArrayList<Namespace>();
        List<Symbol> symbols = program.getSymbolTable().getSymbols(namespaceName, parent);
        for (Symbol symbol : symbols) {
            if (!symbol.getSymbolType().isNamespace()) continue;
            namespaceList.add((Namespace)symbol.getObject());
        }
        return namespaceList;
    }

    public static List<Namespace> getNamespaceByPath(Program program, Namespace parent, String pathString) {
        NamespaceUtils.validate(program, parent);
        parent = NamespaceUtils.adjustForNullRootNamespace(parent, pathString, program);
        SymbolPath path = new SymbolPath(parent.getSymbol());
        if (pathString != null) {
            path = path.append(new SymbolPath(pathString));
        }
        List<String> namespaceNames = path.asList();
        List<Namespace> namespaces = NamespaceUtils.doGetNamespaces(namespaceNames, parent, program);
        return namespaces;
    }

    private static List<Namespace> doGetNamespaces(List<String> namespaceNames, Namespace root, Program program) {
        if (root == null) {
            root = program.getGlobalNamespace();
        }
        List<Namespace> parents = Arrays.asList(root);
        for (String name : namespaceNames) {
            List<Namespace> matches = NamespaceUtils.getMatchingNamespaces(name, parents, program);
            parents = matches;
        }
        return parents;
    }

    public static List<Namespace> getMatchingNamespaces(String childName, List<Namespace> parents, Program program) {
        NamespaceUtils.validate(program, parents);
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        for (Namespace parent : parents) {
            list.addAll(NamespaceUtils.getNamespacesByName(program, parent, childName));
        }
        return list;
    }

    private static List<Symbol> searchForAllSymbolsInAnyOfTheseNamespaces(List<Namespace> parents, String symbolName, Program program) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (Namespace parent : parents) {
            list.addAll(program.getSymbolTable().getSymbols(symbolName, parent));
        }
        return list;
    }

    public static List<Symbol> getSymbols(String symbolPath, Program program) {
        List<String> namespaceNames = new SymbolPath(symbolPath).asList();
        if (namespaceNames.isEmpty()) {
            return Collections.emptyList();
        }
        String symbolName = namespaceNames.remove(namespaceNames.size() - 1);
        List<Namespace> parents = NamespaceUtils.doGetNamespaces(namespaceNames, program.getGlobalNamespace(), program);
        return NamespaceUtils.searchForAllSymbolsInAnyOfTheseNamespaces(parents, symbolName, program);
    }

    public static List<Symbol> getSymbols(SymbolPath symbolPath, Program program) {
        SymbolPath parentPath = symbolPath.getParent();
        if (parentPath == null) {
            return program.getSymbolTable().getGlobalSymbols(symbolPath.getName());
        }
        List<Namespace> parents = NamespaceUtils.doGetNamespaces(parentPath.asList(), null, program);
        return NamespaceUtils.searchForAllSymbolsInAnyOfTheseNamespaces(parents, symbolPath.getName(), program);
    }

    public static Namespace getFirstNonFunctionNamespace(Namespace parent, String namespaceName, Program program) {
        NamespaceUtils.validate(program, parent);
        List<Symbol> symbols = program.getSymbolTable().getSymbols(namespaceName, parent);
        for (Symbol symbol : symbols) {
            if (!symbol.getSymbolType().isNamespace() || symbol.getSymbolType() == SymbolType.FUNCTION) continue;
            return (Namespace)symbol.getObject();
        }
        return null;
    }

    public static Namespace createNamespaceHierarchy(String namespacePath, Namespace rootNamespace, Program program, SourceType source) throws InvalidInputException {
        return NamespaceUtils.createNamespaceHierarchy(namespacePath, rootNamespace, program, null, source);
    }

    public static Namespace createNamespaceHierarchy(String namespacePath, Namespace rootNamespace, Program program, Address address, SourceType source) throws InvalidInputException {
        NamespaceUtils.validate(program, rootNamespace);
        rootNamespace = NamespaceUtils.adjustForNullRootNamespace(rootNamespace, namespacePath, program);
        if (namespacePath == null) {
            return rootNamespace;
        }
        SymbolPath path = new SymbolPath(namespacePath);
        List<String> namespacesList = path.asList();
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = rootNamespace;
        for (String namespaceName : namespacesList) {
            Namespace ns = NamespaceUtils.getNamespace(program, namespace, namespaceName, address);
            if (ns == null) {
                try {
                    ns = symbolTable.createNameSpace(namespace, namespaceName, source);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Duplicate name exception should not be possible here since we checked first!");
                }
            }
            namespace = ns;
        }
        return namespace;
    }

    public static Namespace getFunctionNamespaceAt(Program program, SymbolPath symbolPath, Address address) {
        Symbol[] symbols;
        if (symbolPath == null || address == null) {
            return null;
        }
        for (Symbol symbol : symbols = program.getSymbolTable().getSymbols(address)) {
            if (symbol.getSymbolType() != SymbolType.FUNCTION || !symbolPath.matchesPathOf(symbol)) continue;
            return (Function)symbol.getObject();
        }
        return null;
    }

    public static Namespace getFunctionNamespaceContaining(Program program, SymbolPath symbolPath, Address address) {
        if (symbolPath == null || address == null) {
            return null;
        }
        FunctionManager fm = program.getFunctionManager();
        Function f = fm.getFunctionContaining(address);
        if (f != null && symbolPath.matchesPathOf(f.getSymbol())) {
            return f;
        }
        return null;
    }

    public static Namespace getNonFunctionNamespace(Program program, SymbolPath symbolPath) {
        if (symbolPath == null) {
            return program.getGlobalNamespace();
        }
        List<Symbol> symbols = NamespaceUtils.getSymbols(symbolPath, program);
        for (Symbol symbol : symbols) {
            if (symbol.getSymbolType() == SymbolType.FUNCTION || !symbol.getSymbolType().isNamespace()) continue;
            return (Namespace)symbol.getObject();
        }
        return null;
    }

    private static Namespace getNamespace(Program program, Namespace parent, String name, Address address) {
        if (parent == null) {
            return null;
        }
        List<Symbol> symbols = program.getSymbolTable().getSymbols(name, parent);
        if (address != null) {
            for (Symbol symbol : symbols) {
                Function function;
                if (symbol.getSymbolType() != SymbolType.FUNCTION || !(function = (Function)symbol.getObject()).getBody().contains(address)) continue;
                return function;
            }
        }
        for (Symbol symbol : symbols) {
            SymbolType type = symbol.getSymbolType();
            if (type == SymbolType.FUNCTION || !type.isNamespace()) continue;
            return (Namespace)symbol.getObject();
        }
        return null;
    }

    private static Namespace adjustForNullRootNamespace(Namespace parentNamespace, String namespacePath, Program program) {
        Namespace globalNamespace = program.getGlobalNamespace();
        if (namespacePath != null && namespacePath.startsWith(globalNamespace.getName())) {
            return globalNamespace;
        }
        if (parentNamespace != null) {
            return parentNamespace;
        }
        return globalNamespace;
    }

    private static void validate(Program program, Namespace namespace) {
        if (namespace != null && !namespace.isGlobal() && program != namespace.getSymbol().getProgram()) {
            throw new IllegalArgumentException("Given namespace does not belong to the given program");
        }
    }

    private static void validate(Program program, List<Namespace> parents) {
        for (Namespace namespace : parents) {
            NamespaceUtils.validate(program, namespace);
        }
    }

    public static GhidraClass convertNamespaceToClass(Namespace namespace) throws InvalidInputException {
        Symbol namespaceSymbol = namespace.getSymbol();
        String name = namespaceSymbol.getName();
        SourceType originalSource = namespaceSymbol.getSource();
        SymbolTable symbolTable = namespaceSymbol.getProgram().getSymbolTable();
        int count = 1;
        while (true) {
            String n = name + "_" + count++;
            try {
                namespaceSymbol.setName(n, SourceType.ANALYSIS);
            }
            catch (DuplicateNameException duplicateNameException) {
                continue;
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
            break;
        }
        GhidraClass classNamespace = null;
        try {
            classNamespace = symbolTable.createClass(namespace.getParentNamespace(), name, originalSource);
        }
        catch (DuplicateNameException e) {
            throw new AssertException((Throwable)e);
        }
        catch (InvalidInputException e) {
            throw new InvalidInputException("Namespace contained within Function may not be converted to a class: " + name);
        }
        try {
            for (Symbol s : symbolTable.getSymbols(namespace)) {
                s.setNamespace(classNamespace);
            }
            namespaceSymbol.delete();
        }
        catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        return classNamespace;
    }
}

