/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import java.util.List;
import java.util.Map;

public abstract class AssemblyResolution
implements Comparable<AssemblyResolution> {
    protected final String description;
    protected final List<? extends AssemblyResolution> children;
    private boolean hashed = false;
    private int hash;

    public int hashCode() {
        if (!this.hashed) {
            this.hash = this.computeHash();
            this.hashed = true;
        }
        return this.hash;
    }

    protected abstract int computeHash();

    AssemblyResolution(String description, List<? extends AssemblyResolution> children) {
        this.description = description;
        this.children = children == null ? List.of() : children;
    }

    public static AssemblyResolvedConstructor resolved(AssemblyPatternBlock ins, AssemblyPatternBlock ctx, String description, List<? extends AssemblyResolution> sel) {
        return new AssemblyResolvedConstructor(description, sel, ins, ctx, null, null);
    }

    public static AssemblyResolvedConstructor instrOnly(AssemblyPatternBlock ins, String description, List<AssemblyResolution> children) {
        return AssemblyResolution.resolved(ins, AssemblyPatternBlock.nop(), description, children);
    }

    public static AssemblyResolvedConstructor contextOnly(AssemblyPatternBlock ctx, String description, List<AssemblyResolution> children) {
        return AssemblyResolution.resolved(AssemblyPatternBlock.nop(), ctx, description, children);
    }

    public static AssemblyResolvedConstructor fromPattern(DisjointPattern pat, int minLen, String description) {
        AssemblyPatternBlock ins = AssemblyPatternBlock.fromPattern(pat, minLen, false);
        AssemblyPatternBlock ctx = AssemblyPatternBlock.fromPattern(pat, 0, true);
        return AssemblyResolution.resolved(ins, ctx, description, null);
    }

    public static AssemblyResolvedBackfill backfill(PatternExpression exp, MaskedLong goal, Map<Integer, Object> res, int inslen, String description) {
        return new AssemblyResolvedBackfill(description, exp, goal, res, inslen, 0);
    }

    public static AssemblyResolvedConstructor nop(String description, List<? extends AssemblyResolution> sel) {
        return AssemblyResolution.resolved(AssemblyPatternBlock.nop(), AssemblyPatternBlock.nop(), description, sel);
    }

    public static AssemblyResolvedError error(String error, String description, List<? extends AssemblyResolution> children) {
        return new AssemblyResolvedError(description, children, error);
    }

    public static AssemblyResolution error(String error, AssemblyResolvedConstructor res) {
        return AssemblyResolution.error(error, res.description, res.children);
    }

    public abstract boolean isError();

    public abstract boolean isBackfill();

    protected abstract String lineToString();

    protected String childrenToString(String indent) {
        StringBuilder sb = new StringBuilder();
        for (AssemblyResolution assemblyResolution : this.children) {
            sb.append(assemblyResolution.toString(indent) + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.lineToString());
        if (this.hasChildren()) {
            sb.append(":\n");
            String newIndent = indent + "  ";
            sb.append(this.childrenToString(newIndent));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int compareTo(AssemblyResolution that) {
        return this.toString().compareTo(that.toString());
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() != 0;
    }
}

