/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.languages.sleigh.SleighLanguages;
import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AssemblyConstructorSemantic
implements Comparable<AssemblyConstructorSemantic> {
    protected static final RecursiveDescentSolver solver = RecursiveDescentSolver.getSolver();
    protected static final DbgTimer dbg = AssemblyTreeResolver.dbg;
    protected final Set<AssemblyResolvedConstructor> patterns = new HashSet<AssemblyResolvedConstructor>();
    protected final Constructor cons;
    protected final List<Integer> indices;
    protected Set<AssemblyResolvedConstructor> upatterns;

    public AssemblyConstructorSemantic(Constructor cons, List<Integer> indices) {
        this.cons = cons;
        this.indices = Collections.unmodifiableList(indices);
    }

    public void addPattern(DisjointPattern pat) {
        this.addPattern(AssemblyResolution.fromPattern(pat, this.cons.getMinimumLength(), this.cons.toString()));
    }

    public void addPattern(AssemblyResolvedConstructor pat) {
        if (this.upatterns != null) {
            throw new IllegalStateException("Cannot add patterns after a call to getPatterns()");
        }
        this.patterns.add(pat);
    }

    public String toString() {
        return this.cons.toString() + ":" + this.patterns.toString();
    }

    public Constructor getConstructor() {
        return this.cons;
    }

    public Collection<AssemblyResolvedConstructor> getPatterns() {
        if (this.upatterns == null) {
            this.computeAllForbids();
        }
        return this.upatterns;
    }

    public int getOperandIndex(int printpos) {
        return this.indices.get(printpos);
    }

    public List<Integer> getOperandIndices() {
        return this.indices;
    }

    public Iterator<Integer> getOperandIndexIterator() {
        return Collections.unmodifiableList(this.indices).iterator();
    }

    protected void computeAllForbids() {
        if (this.upatterns != null) {
            throw new IllegalStateException("Already computed all forbidden patterns for this constructor");
        }
        HashSet<AssemblyResolvedConstructor> result = new HashSet<AssemblyResolvedConstructor>();
        for (AssemblyResolvedConstructor pat : this.patterns) {
            AssemblyResolvedConstructor fpat = this.withComputedForbids(pat);
            result.add(fpat);
        }
        this.upatterns = Collections.unmodifiableSet(result);
    }

    protected AssemblyResolvedConstructor withComputedForbids(final AssemblyResolvedConstructor pat) {
        final HashSet<AssemblyResolvedConstructor> forbids = new HashSet<AssemblyResolvedConstructor>();
        SubtableSymbol parent = this.cons.getParent();
        SleighLanguages.traverseConstructors(parent, new SubtableEntryVisitor(){

            @Override
            public int visit(DisjointPattern sibDP, Constructor sibcons) {
                if (sibcons == AssemblyConstructorSemantic.this.cons) {
                    return 0;
                }
                AssemblyResolvedConstructor sibpat = AssemblyResolution.fromPattern(sibDP, sibcons.getMinimumLength(), "For specialization check");
                AssemblyResolvedConstructor comb = pat.combine(sibpat);
                if (null == comb) {
                    return 0;
                }
                if (comb.bitsEqual(sibpat)) {
                    forbids.add(sibpat.withDescription(AssemblyConstructorSemantic.this.cons + " forbids " + sibcons + " by pattern specificity"));
                    return 0;
                }
                if (comb.bitsEqual(pat)) {
                    return 0;
                }
                if (sibcons.getId() < AssemblyConstructorSemantic.this.cons.getId()) {
                    forbids.add(sibpat.withDescription(AssemblyConstructorSemantic.this.cons + " forbids " + sibcons + " by rule position"));
                    return 0;
                }
                return 0;
            }
        });
        return pat.withForbids(forbids);
    }

    public AssemblyResolution solveContextChanges(AssemblyResolvedConstructor res, Map<String, Long> vals, Map<Integer, Object> opvals) {
        List<ContextChange> contextChanges = this.cons.getContextChanges();
        LinkedList<ContextChange> reversed = new LinkedList<ContextChange>();
        for (ContextChange chg : contextChanges) {
            reversed.add(0, chg);
        }
        for (ContextChange chg : reversed) {
            if (!(chg instanceof ContextOp)) continue;
            dbg.println("Current: " + res.lineToString());
            ContextOp cop = (ContextOp)chg;
            dbg.println("Handling context change: " + cop);
            MaskedLong reqval = res.readContextOp(cop);
            if (reqval.equals(MaskedLong.UNKS)) {
                dbg.println("Doesn't affect a current requirement");
                continue;
            }
            dbg.println("'read' " + reqval);
            res = res.maskOut(cop);
            dbg.println("Masked out: " + res.lineToString());
            AssemblyResolution sol = AssemblyTreeResolver.solveOrBackfill(cop.getPatternExpression(), reqval, vals, opvals, res, "Solution to " + cop);
            dbg.println("Solution: " + sol.lineToString());
            if (sol.isError()) {
                AssemblyResolvedError err = (AssemblyResolvedError)sol;
                return AssemblyResolution.error(err.getError(), res);
            }
            if (sol instanceof AssemblyResolvedConstructor) {
                AssemblyResolvedConstructor solcon = (AssemblyResolvedConstructor)sol;
                AssemblyResolvedConstructor check = res.combine(solcon);
                if (null == check) {
                    return AssemblyResolution.error("A context change caused a conflict: " + sol, res);
                }
                res = check;
            } else {
                AssemblyResolvedBackfill solbf = (AssemblyResolvedBackfill)sol;
                res = res.combine(solbf);
            }
            dbg.println("Combined: " + res.lineToString());
        }
        return res;
    }

    public AssemblyResolvedConstructor applyForward(AssemblyResolvedConstructor outer) {
        AssemblyResolvedConstructor res = outer;
        for (ContextChange chg : this.cons.getContextChanges()) {
            if (!(chg instanceof ContextOp)) continue;
            ContextOp cop = (ContextOp)chg;
            MaskedLong val = solver.valueForResolution(cop.getPatternExpression(), res);
            res = res.writeContextOp(cop, val);
        }
        return res;
    }

    @Override
    public int compareTo(AssemblyConstructorSemantic that) {
        return this.toString().compareTo(that.toString());
    }
}

