/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.CellEditor;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import util.CollectionUtils;

public class GTreeStartEditingTask
extends GTreeTask {
    private final GTreeNode parent;
    private final String childName;

    public GTreeStartEditingTask(GTree gTree, JTree jTree, GTreeNode parent, String childName) {
        super(gTree);
        this.parent = parent;
        this.childName = childName;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            this.edit();
        });
    }

    public long getPriority() {
        return Long.MAX_VALUE;
    }

    private void edit() {
        final GTreeNode editNode = this.parent.getChild(this.childName);
        if (editNode == null) {
            if (this.tree.isFiltered()) {
                Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.tree, (String)"Cannot Edit Tree Node", (Object)("Can't edit tree node \"" + this.childName + "\" while tree is filtered."));
            } else {
                Msg.debug((Object)((Object)this), (Object)("Can't find node \"" + this.childName + "\" to edit."));
            }
            return;
        }
        TreePath path = editNode.getTreePath();
        final HashSet<GTreeNode> childrenBeforeEdit = new HashSet<GTreeNode>(this.parent.getChildren());
        final CellEditor cellEditor = this.tree.getCellEditor();
        cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                cellEditor.removeCellEditorListener(this);
                SystemUtilities.runSwingLater(this::reselectNode);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                cellEditor.removeCellEditorListener(this);
                SystemUtilities.runSwingLater(this::reselectNodeHandlingPotentialChildChange);
            }

            private void reselectNode() {
                String newName = editNode.getName();
                GTreeNode newChild = GTreeStartEditingTask.this.parent.getChild(newName);
                if (newChild == null) {
                    throw new AssertException("Unable to find new node by name: " + newName);
                }
                GTreeStartEditingTask.this.tree.setSelectedNode(newChild);
            }

            private void reselectNodeHandlingPotentialChildChange() {
                SystemUtilities.runSwingLater(this::doReselectNodeHandlingPotentialChildChange);
            }

            private void doReselectNodeHandlingPotentialChildChange() {
                HashSet<GTreeNode> childrenAfterEdit = new HashSet<GTreeNode>(GTreeStartEditingTask.this.parent.getChildren());
                if (childrenAfterEdit.equals(childrenBeforeEdit)) {
                    this.reselectNode();
                    return;
                }
                childrenAfterEdit.removeAll(childrenBeforeEdit);
                if (childrenAfterEdit.size() != 1) {
                    return;
                }
                GTreeNode newChild = (GTreeNode)CollectionUtils.any(childrenAfterEdit);
                GTreeStartEditingTask.this.tree.setSelectedNode(newChild);
            }
        });
        this.tree.setNodeEditable(editNode);
        this.jTree.startEditingAtPath(path);
    }
}

