/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.internal;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.internal.InProgressGTreeNode;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GTreeModel
implements TreeModel {
    private volatile GTreeNode root;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private boolean isFiringNodeStructureChanged;
    private volatile boolean eventsEnabled = true;

    public GTreeModel(GTreeNode root) {
        this.root = root;
    }

    public void privateSwingSetRootNode(GTreeNode newRoot) {
        this.root = newRoot;
        this.swingFireRootChanged();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public GTreeNode getModelRoot() {
        return this.root;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        try {
            GTreeNode gTreeParent = (GTreeNode)parent;
            return gTreeParent.getChild(index);
        }
        catch (IndexOutOfBoundsException e) {
            Swing.runLater(() -> this.fireNodeStructureChanged((GTreeNode)parent));
            return new InProgressGTreeNode();
        }
    }

    @Override
    public int getChildCount(Object parent) {
        GTreeNode gTreeParent = (GTreeNode)parent;
        return gTreeParent.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        GTreeNode gTreeParent = (GTreeNode)parent;
        return gTreeParent.getIndexOfChild((GTreeNode)child);
    }

    @Override
    public boolean isLeaf(Object node) {
        GTreeNode gTreeNode = (GTreeNode)node;
        return gTreeNode.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        node.valueChanged(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeStructureChanged(GTreeNode changedNode) {
        if (!this.eventsEnabled || this.isFiringNodeStructureChanged) {
            return;
        }
        try {
            this.isFiringNodeStructureChanged = true;
            SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeStructuredChanged() must be called from the AWT thread");
            GTreeNode node = this.convertToViewNode(changedNode);
            if (node == null) {
                return;
            }
            if (node != changedNode) {
                node.setChildren(null);
                return;
            }
            TreeModelEvent event = new TreeModelEvent((Object)this, node.getTreePath());
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
        finally {
            this.isFiringNodeStructureChanged = false;
        }
    }

    private void swingFireRootChanged() {
        TreeModelEvent event = new TreeModelEvent((Object)this, (TreePath)null);
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    public void fireNodeDataChanged(GTreeNode changedNode) {
        if (!this.eventsEnabled) {
            return;
        }
        SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeDataChanged() must be called from the AWT thread");
        GTreeNode viewNode = this.convertToViewNode(changedNode);
        if (viewNode == null) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, viewNode.getTreePath());
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(event);
        }
    }

    public void fireNodeAdded(GTreeNode parentNode, GTreeNode newNode) {
        if (!this.eventsEnabled) {
            return;
        }
        SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeAdded() must be called from the AWT thread");
        GTreeNode parent = this.convertToViewNode(parentNode);
        if (parent == null) {
            return;
        }
        int index = parent.getIndexOfChild(newNode);
        if (index < 0) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{index}, new Object[]{newNode});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(event);
        }
    }

    public void fireNodeRemoved(GTreeNode parentNode, GTreeNode removedNode, int index) {
        SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeRemoved() must be called from the AWT thread");
        GTreeNode parent = this.convertToViewNode(parentNode);
        if (parent == null) {
            return;
        }
        if (parent != parentNode) {
            index = this.removeFromFiltered(parent, removedNode);
            return;
        }
        if (index < 0) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{index}, new Object[]{removedNode});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(event);
        }
    }

    public void dispose() {
        this.root = null;
    }

    public void setEventsEnabled(boolean b) {
        this.eventsEnabled = b;
    }

    private TreeModelEvent getChangedNodeEvent(GTreeNode changedNode) {
        GTreeNode parentNode = changedNode.getParent();
        if (parentNode == null) {
            return new TreeModelEvent((Object)this, this.root.getTreePath(), null, null);
        }
        GTreeNode node = this.convertToViewNode(changedNode);
        if (node == null) {
            return null;
        }
        int indexInParent = node.getIndexInParent();
        if (indexInParent < 0) {
            return null;
        }
        return new TreeModelEvent((Object)this, node.getParent().getTreePath(), new int[]{indexInParent}, new Object[]{changedNode});
    }

    private GTreeNode convertToViewNode(GTreeNode node) {
        if (node.getRoot() == this.root) {
            return node;
        }
        GTree tree = this.root.getTree();
        if (tree != null) {
            return tree.getViewNodeForPath(node.getTreePath());
        }
        return null;
    }

    private int removeFromFiltered(GTreeNode parent, GTreeNode removedNode) {
        int index = parent.getIndexOfChild(removedNode);
        if (index >= 0) {
            parent.removeNode(removedNode);
        }
        return index;
    }
}

