/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootParentNode;
import docking.widgets.tree.internal.InProgressGTreeNode;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

abstract class CoreGTreeNode
implements Cloneable {
    private volatile GTreeNode parent;
    private List<GTreeNode> children;

    CoreGTreeNode() {
    }

    public final GTreeNode getParent() {
        GTreeNode localParent = this.parent;
        if (localParent instanceof GTreeRootParentNode) {
            return null;
        }
        return localParent;
    }

    final synchronized void setParent(GTreeNode parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<GTreeNode> children() {
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            if (this.isLoaded()) {
                return this.children;
            }
        }
        List<GTreeNode> newChildren = this.generateChildren();
        CoreGTreeNode coreGTreeNode2 = this;
        synchronized (coreGTreeNode2) {
            if (newChildren == null) {
                return Collections.emptyList();
            }
            if (this.isInProgress(newChildren) && this.children != null) {
                return this.children;
            }
            this.doSetChildren(newChildren);
            return this.children;
        }
    }

    protected abstract List<GTreeNode> generateChildren();

    protected synchronized void doSetChildrenAndFireEvent(List<GTreeNode> childList) {
        this.doSetChildren(childList);
        this.doFireNodeStructureChanged();
    }

    protected synchronized void doSetChildren(List<GTreeNode> childList) {
        List<GTreeNode> oldChildren = this.children;
        this.children = null;
        if (oldChildren != null) {
            for (GTreeNode node : oldChildren) {
                node.setParent(null);
            }
        }
        if (childList != null) {
            for (GTreeNode node : childList) {
                node.setParent((GTreeNode)this);
            }
            this.children = new CopyOnWriteArrayList<GTreeNode>(childList);
        }
        if (oldChildren != null) {
            for (GTreeNode node : oldChildren) {
                if (node.getParent() != null) continue;
                node.dispose();
            }
        }
    }

    protected synchronized void doAddNode(GTreeNode node) {
        this.doAddNode(this.children().size(), node);
    }

    protected synchronized void doAddNode(int index, GTreeNode node) {
        List<GTreeNode> kids = this.children();
        if (kids.contains(node)) {
            return;
        }
        int insertIndex = Math.min(kids.size(), index);
        kids.add(insertIndex, node);
        node.setParent((GTreeNode)this);
        this.doFireNodeAdded(node);
    }

    protected synchronized void doRemoveNode(GTreeNode node) {
        List<GTreeNode> kids = this.children();
        int index = kids.indexOf(node);
        if (index >= 0) {
            kids.remove(index);
            node.setParent(null);
            this.doFireNodeRemoved(node, index);
        }
    }

    protected synchronized void doAddNodes(List<GTreeNode> nodes) {
        for (GTreeNode node : nodes) {
            node.setParent((GTreeNode)this);
        }
        this.children().addAll(nodes);
        this.doFireNodeStructureChanged();
    }

    public GTreeNode clone() throws CloneNotSupportedException {
        GTreeNode clone = (GTreeNode)super.clone();
        clone.parent = null;
        clone.children = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<GTreeNode> oldChildren;
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            oldChildren = this.children;
            this.children = null;
            this.parent = null;
        }
        if (oldChildren != null) {
            for (GTreeNode node : oldChildren) {
                node.dispose();
            }
            oldChildren.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disposeClones() {
        List<GTreeNode> oldChildren;
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            oldChildren = this.children;
            this.children = null;
            this.parent = null;
        }
        if (oldChildren != null) {
            for (GTreeNode node : oldChildren) {
                node.disposeClones();
            }
            oldChildren.clear();
        }
    }

    public final synchronized boolean isInProgress() {
        return this.isInProgress(this.children);
    }

    public synchronized boolean isLoaded() {
        if (this.children == null) {
            return false;
        }
        if (Swing.isSwingThread()) {
            return true;
        }
        return !this.isInProgress(this.children);
    }

    public GTree getTree() {
        if (this.parent != null) {
            return this.parent.getTree();
        }
        return null;
    }

    private boolean isInProgress(List<GTreeNode> childList) {
        return childList != null && childList.size() == 1 && childList.get(0) instanceof InProgressGTreeNode;
    }

    protected void doFireNodeAdded(GTreeNode newNode) {
        this.assertSwing();
        GTree tree = this.getTree();
        if (tree != null) {
            tree.getModel().fireNodeAdded((GTreeNode)this, newNode);
            tree.refilterLater(newNode);
        }
    }

    protected void doFireNodeRemoved(GTreeNode removedNode, int index) {
        this.assertSwing();
        GTree tree = this.getTree();
        if (tree != null) {
            tree.getModel().fireNodeRemoved((GTreeNode)this, removedNode, index);
        }
    }

    protected void doFireNodeStructureChanged() {
        this.assertSwing();
        GTree tree = this.getTree();
        if (tree != null) {
            tree.getModel().fireNodeStructureChanged((GTreeNode)this);
            tree.refilterLater();
        }
    }

    protected void doFireNodeChanged() {
        this.assertSwing();
        GTree tree = this.getTree();
        if (tree != null) {
            tree.getModel().fireNodeDataChanged((GTreeNode)this);
            tree.refilterLater();
        }
    }

    private void assertSwing() {
        SystemUtilities.assertThisIsTheSwingThread((String)"tree events must be called from the AWT thread");
    }
}

