/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import ghidra.util.classfinder.ExtensionPoint;
import java.util.List;
import java.util.Objects;
import utilities.util.reflection.ReflectionUtilities;

public abstract class ColumnTypeMapper<T, M>
implements ExtensionPoint {
    private Class<T> sourceType;
    private Class<M> destinationType;

    public ColumnTypeMapper() {
        this.sourceType = this.findSourceType();
        this.destinationType = this.findDestinationType();
    }

    protected ColumnTypeMapper(Class<T> sourceType, Class<M> destinationType) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
    }

    public int hashCode() {
        return Objects.hash(this.sourceType, this.destinationType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnTypeMapper other = (ColumnTypeMapper)obj;
        return this.destinationType == other.destinationType && this.sourceType == other.sourceType;
    }

    public abstract M convert(T var1);

    public final Class<T> getSourceType() {
        return this.sourceType;
    }

    public final Class<M> getDestinationType() {
        return this.destinationType;
    }

    private Class<T> findSourceType() {
        Class<?> implementationClass = this.getClass();
        List typeArguments = ReflectionUtilities.getTypeArguments(ColumnTypeMapper.class, implementationClass);
        return (Class)typeArguments.get(0);
    }

    private Class<M> findDestinationType() {
        Class<?> implementationClass = this.getClass();
        List typeArguments = ReflectionUtilities.getTypeArguments(ColumnTypeMapper.class, implementationClass);
        return (Class)typeArguments.get(1);
    }
}

