/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constrainteditor.BooleanConstraintEditor;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import java.util.Objects;

public class BooleanMatchColumnConstraint
implements ColumnConstraint<Boolean> {
    private Boolean matchValue;

    public BooleanMatchColumnConstraint(Boolean matchValue) {
        this.matchValue = matchValue;
    }

    @Override
    public String getGroup() {
        return "boolean";
    }

    @Override
    public String getName() {
        return "Is";
    }

    @Override
    public boolean accepts(Boolean value, TableFilterContext context) {
        if (value == null) {
            return false;
        }
        return value.equals(this.matchValue);
    }

    @Override
    public ColumnConstraintEditor<Boolean> getEditor(ColumnData<Boolean> columnDataSource) {
        return new BooleanConstraintEditor(this);
    }

    @Override
    public Class<Boolean> getColumnType() {
        return Boolean.class;
    }

    public Boolean getValue() {
        return this.matchValue;
    }

    @Override
    public String getConstraintValueString() {
        return this.matchValue.toString();
    }

    @Override
    public ColumnConstraint<Boolean> parseConstraintValue(String newValue, Object dataSource) {
        boolean b = Boolean.parseBoolean(newValue);
        return new BooleanMatchColumnConstraint(b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanMatchColumnConstraint other = (BooleanMatchColumnConstraint)obj;
        return Objects.equals(this.matchValue, other.matchValue);
    }
}

