/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class RowLayout
implements Layout {
    private Field[] fields;
    private int heightAbove;
    private int heightBelow;
    private int maxHeightAbove;
    private int lastCursorY;
    private int rowID;
    boolean isPrimary = false;

    public RowLayout(Field[] fields, int rowID) {
        this.fields = fields;
        this.rowID = rowID;
        for (Field element : fields) {
            this.heightAbove = Math.max(this.heightAbove, element.getHeightAbove());
            this.heightBelow = Math.max(this.heightBelow, element.getHeightBelow());
            if (!element.isPrimary()) continue;
            this.isPrimary = true;
        }
        this.maxHeightAbove = this.heightAbove;
        for (Field element : fields) {
            element.rowHeightChanged(this.heightAbove, this.heightBelow);
        }
    }

    @Override
    public int getHeight() {
        return this.heightAbove + this.heightBelow;
    }

    @Override
    public int getCompressableWidth() {
        int startX;
        int rowWidth = startX = this.fields[0].getStartX();
        for (int i = 0; i < this.fields.length - 1; ++i) {
            Field field = this.fields[i];
            int width = field.getWidth();
            rowWidth += width;
        }
        Field lastField = this.fields[this.fields.length - 1];
        int width = lastField.getWidth();
        int preferredWidth = lastField.getPreferredWidth();
        return rowWidth += Math.min(width, preferredWidth);
    }

    public int getHeightAbove() {
        return this.heightAbove;
    }

    public int getHeightBelow() {
        return this.heightBelow;
    }

    public int getRowID() {
        return this.rowID;
    }

    @Override
    public void insertSpaceAbove(int size) {
        this.heightAbove += size;
    }

    @Override
    public void insertSpaceBelow(int size) {
        this.heightBelow += size;
    }

    @Override
    public int getNumFields() {
        return this.fields.length;
    }

    @Override
    public Field getField(int index) {
        return this.fields[index];
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle rect, LayoutBackgroundColorManager colorManager, FieldLocation cursorLocation) {
        if (rect.y >= this.heightAbove + this.heightBelow || rect.y + rect.height < 0) {
            return;
        }
        g.translate(0, this.heightAbove);
        rect.y -= this.heightAbove;
        for (int i = 0; i < this.fields.length; ++i) {
            this.paintGapSelection(g, colorManager, rect, i);
            RowColLocation cursorLoc = null;
            if (cursorLocation != null && cursorLocation.fieldNum == i) {
                cursorLoc = new RowColLocation(cursorLocation.row, cursorLocation.col);
            }
            FieldBackgroundColorManager fieldColorManager = colorManager.getFieldBackgroundColorManager(i);
            this.paintFieldBackground(g, i, fieldColorManager);
            this.fields[i].paint(c, g, context, rect, fieldColorManager, cursorLoc, this.getHeight());
        }
        this.paintGapSelection(g, colorManager, rect, -1);
        g.translate(0, -this.heightAbove);
        rect.y += this.heightAbove;
    }

    private void paintFieldBackground(Graphics g, int fieldNum, FieldBackgroundColorManager colorManager) {
        Color fieldBackgroundColor = colorManager.getBackgroundColor();
        if (fieldBackgroundColor == null) {
            return;
        }
        g.setColor(fieldBackgroundColor);
        g.fillRect(this.fields[fieldNum].getStartX(), -this.getHeightAbove(), this.fields[fieldNum].getWidth(), this.getHeight());
    }

    private void paintGapSelection(Graphics g, LayoutBackgroundColorManager colorManager, Rectangle rect, int gapIndex) {
        int endX;
        Color gapColor = colorManager.getPaddingColor(gapIndex);
        if (gapColor == null) {
            return;
        }
        if (gapIndex == -1) {
            gapIndex = this.fields.length;
        }
        int startX = gapIndex == 0 ? rect.x : this.fields[gapIndex - 1].getStartX() + this.fields[gapIndex - 1].getWidth();
        int n = endX = gapIndex >= this.fields.length ? rect.x + rect.width : this.fields[gapIndex].getStartX();
        if (startX < endX) {
            g.setColor(gapColor);
            g.fillRect(startX, -this.heightAbove, endX - startX, this.heightAbove + this.heightBelow);
        }
    }

    @Override
    public int setCursor(FieldLocation cursorLoc, int x, int y) {
        int index = this.findAppropriateFieldIndex(x, y);
        if (index < 0) {
            index = 0;
        }
        Field field = this.fields[index];
        cursorLoc.fieldNum = index;
        cursorLoc.row = field.getRow(y - this.heightAbove);
        cursorLoc.col = field.getCol(cursorLoc.row, x);
        return field.getX(cursorLoc.row, cursorLoc.col);
    }

    @Override
    public Rectangle getCursorRect(int fieldNum, int row, int col) {
        if (fieldNum >= this.fields.length) {
            return null;
        }
        Field field = this.fields[fieldNum];
        if (field.isValid(row, col)) {
            Rectangle rect = field.getCursorBounds(row, col);
            rect.y += this.heightAbove;
            return rect;
        }
        return null;
    }

    @Override
    public boolean cursorUp(FieldLocation cursorLoc, int lastX) {
        if (cursorLoc.row > 0) {
            --cursorLoc.row;
            cursorLoc.col = this.fields[cursorLoc.fieldNum].getCol(cursorLoc.row, lastX);
            return true;
        }
        return false;
    }

    @Override
    public boolean cursorDown(FieldLocation cursorLoc, int lastX) {
        if (cursorLoc.row < this.fields[cursorLoc.fieldNum].getNumRows() - 1) {
            ++cursorLoc.row;
            cursorLoc.col = this.fields[cursorLoc.fieldNum].getCol(cursorLoc.row, lastX);
            return true;
        }
        return false;
    }

    @Override
    public int cursorBeginning(FieldLocation cursorLoc) {
        Field field = this.fields[0];
        cursorLoc.row = field.getRow(this.lastCursorY);
        cursorLoc.col = field.getCol(cursorLoc.row, field.getStartX());
        cursorLoc.fieldNum = 0;
        return field.getX(cursorLoc.row, cursorLoc.col);
    }

    @Override
    public int cursorEnd(FieldLocation cursorLoc) {
        Field field = this.fields[this.fields.length - 1];
        cursorLoc.row = field.getRow(this.lastCursorY);
        cursorLoc.col = field.getCol(cursorLoc.row, field.getStartX() + field.getWidth());
        cursorLoc.fieldNum = this.fields.length - 1;
        return field.getX(cursorLoc.row, cursorLoc.col);
    }

    @Override
    public int cursorLeft(FieldLocation cursorLoc) {
        if (cursorLoc.col > 0) {
            --cursorLoc.col;
        } else if (cursorLoc.fieldNum > 0) {
            --cursorLoc.fieldNum;
            Field field = this.fields[cursorLoc.fieldNum];
            int x = field.getStartX() + field.getWidth() - 1;
            cursorLoc.row = field.getRow(this.lastCursorY);
            cursorLoc.col = field.getCol(cursorLoc.row, x);
        } else if (cursorLoc.row > 0) {
            Field field = this.fields[cursorLoc.fieldNum];
            --cursorLoc.row;
            cursorLoc.col = field.getNumCols(cursorLoc.row) - 1;
        } else {
            return -1;
        }
        return this.fields[cursorLoc.fieldNum].getX(cursorLoc.row, cursorLoc.col);
    }

    @Override
    public int cursorRight(FieldLocation cursorLoc) {
        if (cursorLoc.col < this.fields[cursorLoc.fieldNum].getNumCols(cursorLoc.row) - 1) {
            ++cursorLoc.col;
        } else {
            Field field = this.fields[cursorLoc.fieldNum];
            if (cursorLoc.fieldNum < this.fields.length - 1) {
                ++cursorLoc.fieldNum;
                field = this.fields[cursorLoc.fieldNum];
                cursorLoc.row = field.getRow(this.lastCursorY);
                cursorLoc.col = field.getCol(cursorLoc.row, field.getStartX());
            } else if (cursorLoc.row < field.getNumRows() - 1) {
                ++cursorLoc.row;
                cursorLoc.col = 0;
            } else {
                return -1;
            }
        }
        return this.fields[cursorLoc.fieldNum].getX(cursorLoc.row, cursorLoc.col);
    }

    @Override
    public boolean enterLayout(FieldLocation cursorLoc, int lastX, boolean fromTop) {
        int y = fromTop ? 0 : this.heightAbove + this.heightBelow - 1;
        int index = this.findAppropriateFieldIndex(lastX, y);
        if (index < 0) {
            return false;
        }
        cursorLoc.fieldNum = index;
        Field field = this.fields[index];
        int x = lastX;
        y = fromTop ? -field.getHeightAbove() : field.getHeightBelow() - 1;
        cursorLoc.row = field.getRow(y);
        cursorLoc.col = field.getCol(cursorLoc.row, x);
        this.lastCursorY = y;
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction) {
        int max = 0;
        if (direction > 0) {
            if (topOfScreen < this.heightAbove - this.maxHeightAbove) {
                return this.heightAbove - this.maxHeightAbove - topOfScreen;
            }
            max = this.heightAbove + this.heightBelow - topOfScreen;
        } else {
            max = -topOfScreen;
        }
        int localTopOfScreen = topOfScreen - this.heightAbove;
        for (Field element : this.fields) {
            if (element == null) continue;
            int x = element.getScrollableUnitIncrement(localTopOfScreen, direction, max);
            if (direction > 0 && x > 0 && x < max) {
                max = x;
                continue;
            }
            if (direction >= 0 || x >= 0 || x <= max) continue;
            max = x;
        }
        return max;
    }

    @Override
    public boolean contains(int yPos) {
        return yPos >= 0 && yPos < this.heightAbove + this.heightBelow;
    }

    int findAppropriateFieldIndex(int x, int y) {
        int i;
        y -= this.heightAbove;
        for (i = this.fields.length - 1; i >= 0; --i) {
            if (this.fields[i] == null || y < -this.fields[i].getHeightAbove() || y >= this.fields[i].getHeightBelow() || this.fields[i].getStartX() > x) continue;
            return i;
        }
        for (i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == null || y < -this.fields[i].getHeightAbove() || y >= this.fields[i].getHeightBelow() || this.fields[i].getStartX() <= x) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getPrimaryOffset() {
        return 0;
    }

    boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public Rectangle getFieldBounds(int index) {
        Field f = this.fields[index];
        Rectangle rect = new Rectangle(f.getStartX(), -f.getHeightAbove(), f.getWidth(), f.getHeight());
        rect.y += this.heightAbove;
        return rect;
    }

    @Override
    public int getIndexSize() {
        return 1;
    }

    @Override
    public int getBeginRowFieldNum(int field1) {
        return 0;
    }

    @Override
    public int getEndRowFieldNum(int field2) {
        return this.getNumFields();
    }
}

