/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.EmptyFieldElement;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class VerticalLayoutTextField
implements TextField {
    protected FieldElement[] textElements;
    protected List<Field> subFields;
    protected int startX;
    protected int width;
    protected int preferredWidth;
    protected HighlightFactory hlFactory;
    private int height;
    private int heightAbove;
    private boolean isPrimary;
    private String text;
    protected boolean isClipped;
    private String lineDelimiter;

    public VerticalLayoutTextField(FieldElement[] textElements, int startX, int width, int maxLines, HighlightFactory hlFactory) {
        this(textElements, startX, width, maxLines, hlFactory, " ");
    }

    protected VerticalLayoutTextField(FieldElement[] textElements, int startX, int width, int maxLines, HighlightFactory hlFactory, String lineDelimiter) {
        this.textElements = textElements;
        this.startX = startX;
        this.width = width;
        this.hlFactory = hlFactory;
        this.lineDelimiter = lineDelimiter;
        this.subFields = this.layoutElements(maxLines);
        this.preferredWidth = this.calculatePreferredWidth();
        this.calculateHeight();
    }

    protected void calculateHeight() {
        this.heightAbove = this.subFields.get(0).getHeightAbove();
        for (Field field : this.subFields) {
            this.height += field.getHeight();
        }
    }

    private int calculatePreferredWidth() {
        int widest = 0;
        for (Field field : this.subFields) {
            widest = Math.max(widest, field.getPreferredWidth());
        }
        return widest;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.generateText();
        }
        return this.text;
    }

    @Override
    public String getTextWithLineSeparators() {
        return this.generateText("\n");
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getNumRows() {
        return this.subFields.size();
    }

    @Override
    public int getNumCols(int row) {
        Field f = this.subFields.get(row);
        return f.getNumCols(0);
    }

    @Override
    public int getRow(int y) {
        if (y < -this.heightAbove) {
            return 0;
        }
        int heightSoFar = -this.heightAbove;
        int n = this.subFields.size();
        for (int i = 0; i < n; ++i) {
            Field f = this.subFields.get(i);
            if ((heightSoFar += f.getHeight()) <= y) continue;
            return i;
        }
        return n - 1;
    }

    @Override
    public int getCol(int row, int x) {
        Field f = this.subFields.get(row);
        return f.getCol(0, x);
    }

    @Override
    public int getY(int row) {
        int y = -this.heightAbove;
        for (int i = 0; i < row; ++i) {
            Field f = this.subFields.get(row);
            y += f.getHeight();
        }
        return y;
    }

    @Override
    public int getX(int row, int col) {
        Field f = this.subFields.get(row);
        return f.getX(0, col);
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row < 0 || row >= this.subFields.size()) {
            return false;
        }
        Field f = this.subFields.get(row);
        return f.isValid(0, col);
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLoc, int rowHeight) {
        int startY;
        if (context.isPrinting()) {
            this.print(g, context);
            return;
        }
        int cursorTextOffset = -1;
        int cursorRow = -1;
        if (cursorLoc != null) {
            cursorTextOffset = this.screenLocationToTextOffset(cursorLoc.row(), cursorLoc.col());
            cursorRow = cursorLoc.row();
        }
        Highlight[] highlights = this.hlFactory.getHighlights(this, this.getText(), cursorTextOffset);
        int columns = 0;
        int n = this.subFields.size();
        int myStartY = -this.heightAbove;
        int myEndY = myStartY + rowHeight;
        int clipStartY = clip.y;
        int clipEndY = clip.y + clip.height;
        Color fieldBackgroundColor = colorManager.getBackgroundColor();
        if (fieldBackgroundColor != null) {
            g.setColor(fieldBackgroundColor);
            startY = Math.max(myStartY, clipStartY);
            int endY = Math.min(myEndY, clipEndY);
            int clippedHeight = endY - startY;
            g.fillRect(this.startX, startY, this.width, clippedHeight);
        }
        startY = myStartY;
        int translatedY = 0;
        for (int i = 0; i < n; ++i) {
            ClippingTextField subField = (ClippingTextField)this.subFields.get(i);
            int subFieldHeight = subField.getHeight();
            int endY = startY + subFieldHeight;
            if (startY > clipEndY) break;
            if (endY >= clipStartY) {
                for (Highlight highlight : highlights) {
                    highlight.setOffset(-columns);
                }
                subField.paintSelection(g, colorManager, i, rowHeight);
                subField.paintHighlights(g, highlights);
                subField.paintText(c, g, context);
                if (cursorRow == i) {
                    subField.paintCursor(g, context.getCursorColor(), cursorLoc);
                }
            }
            startY += subFieldHeight;
            g.translate(0, subFieldHeight);
            translatedY += subFieldHeight;
            columns += subField.getText().length() + this.lineDelimiter.length();
        }
        g.translate(0, -translatedY);
    }

    private void print(Graphics g, PaintContext context) {
        int n = this.subFields.size();
        for (int i = 0; i < n; ++i) {
            ClippingTextField clippingField = (ClippingTextField)this.subFields.get(i);
            clippingField.print(g, context);
            g.translate(0, clippingField.getHeight());
        }
        g.translate(0, -this.height);
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row < 0 || row >= this.subFields.size()) {
            return null;
        }
        Field f = this.subFields.get(row);
        Rectangle r = f.getCursorBounds(0, col);
        for (int i = 0; i < row; ++i) {
            f = this.subFields.get(row);
            r.y += f.getHeight();
        }
        return r;
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.heightAbove && y < this.height - this.heightAbove;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.heightAbove || topOfScreen > this.height - this.heightAbove) {
            return max;
        }
        int row = this.getRow(topOfScreen);
        int y = this.getY(row);
        int rowOffset = topOfScreen - y;
        int rowHeight = this.subFields.get(row).getHeight();
        if (direction > 0) {
            return rowHeight - rowOffset;
        }
        if (rowOffset == 0) {
            return -rowHeight;
        }
        return -rowOffset;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void setPrimary(boolean state) {
        this.isPrimary = state;
    }

    public List<Field> getSubfields() {
        return Collections.unmodifiableList(this.subFields);
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.height - this.heightAbove;
    }

    @Override
    public void rowHeightChanged(int heightAbove1, int heightBelow) {
    }

    @Override
    public FieldElement getFieldElement(int screenRow, int screenColumn) {
        FieldElement clickedField = this.textElements[screenRow];
        return clickedField.getFieldElement(screenColumn);
    }

    protected List<Field> layoutElements(int maxLines) {
        ArrayList<Field> newSubFields = new ArrayList<Field>();
        boolean tooManyLines = this.textElements.length > maxLines;
        for (int i = 0; i < this.textElements.length && i < maxLines; ++i) {
            FieldElement element = this.textElements[i];
            if (tooManyLines && i == maxLines - 1) {
                FieldElement[] elements = new FieldElement[]{element, new EmptyFieldElement(500)};
                element = new CompositeFieldElement(elements);
            }
            ClippingTextField field = new ClippingTextField(this.startX, this.width, element, this.hlFactory);
            newSubFields.add(field);
            this.isClipped |= field.isClipped();
        }
        this.isClipped |= tooManyLines;
        return newSubFields;
    }

    @Override
    public RowColLocation screenToDataLocation(int screenRow, int screenColumn) {
        screenRow = Math.min(screenRow, this.textElements.length - 1);
        screenRow = Math.max(screenRow, 0);
        screenColumn = Math.min(screenColumn, this.textElements[screenRow].length());
        screenColumn = Math.max(screenColumn, 0);
        return this.textElements[screenRow].getDataLocationForCharacterIndex(screenColumn);
    }

    @Override
    public RowColLocation dataToScreenLocation(int dataRow, int dataColumn) {
        for (int screenRow = this.textElements.length - 1; screenRow >= 0; --screenRow) {
            FieldElement element = this.textElements[screenRow];
            int screenColumn = element.getCharacterIndexForDataLocation(dataRow, dataColumn);
            if (screenColumn < 0) continue;
            return new RowColLocation(screenRow, screenColumn);
        }
        return new RowColLocation(0, 0);
    }

    protected String generateText() {
        return this.generateText(this.lineDelimiter);
    }

    protected String generateText(String delimiter) {
        StringBuffer buf = new StringBuffer();
        int n = this.textElements.length - 1;
        for (int i = 0; i < n; ++i) {
            buf.append(this.textElements[i].getText()).append(delimiter);
        }
        buf.append(this.textElements[n].getText());
        return buf.toString();
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        if (row >= this.textElements.length) {
            return this.getText().length();
        }
        int extraSpace = this.lineDelimiter.length();
        int len = 0;
        for (int i = 0; i < row; ++i) {
            len += this.textElements[i].getText().length() + extraSpace;
        }
        return len += Math.min(col, this.textElements[row].getText().length());
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        int extraSpace = this.lineDelimiter.length();
        int n = this.textElements.length;
        for (int i = 0; i < n; ++i) {
            int len = this.textElements[i].getText().length();
            if (textOffset < len + extraSpace) {
                return new RowColLocation(i, textOffset);
            }
            textOffset -= len + extraSpace;
        }
        return new RowColLocation(n - 1, this.textElements[n - 1].getText().length());
    }

    @Override
    public boolean isClipped() {
        return this.isClipped;
    }
}

