/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.InputDialogListener;
import docking.widgets.label.GLabel;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class InputDialog
extends DialogComponentProvider {
    private static final String DEFAULT_VALUE = "";
    private static final int MAX_SIZE = 256;
    private boolean isCanceled;
    private String[] inputLabels;
    private String[] inputValues;
    private String[] initialValues;
    private JTextField[] textFields;
    private KeyListener keyListener;
    private InputDialogListener listener;

    public InputDialog(String dialogTitle, String label) {
        this(dialogTitle, new String[]{label}, new String[]{DEFAULT_VALUE}, true, null);
    }

    public InputDialog(String dialogTitle, String label, String initialValue) {
        this(dialogTitle, new String[]{label}, new String[]{initialValue}, true, null);
    }

    public InputDialog(String dialogTitle, String label, String initialValue, InputDialogListener listener) {
        this(dialogTitle, new String[]{label}, new String[]{initialValue}, true, listener);
    }

    public InputDialog(String dialogTitle, String label, String initialValue, boolean isModal) {
        this(dialogTitle, new String[]{label}, new String[]{initialValue}, isModal, null);
    }

    public InputDialog(String dialogTitle, String[] labels, String[] initialValues) {
        this(dialogTitle, labels, initialValues, true, null);
    }

    public InputDialog(String dialogTitle, String[] labels, String[] initialValues, boolean isModal, InputDialogListener listener) {
        super(dialogTitle, isModal, listener != null, true, false);
        this.listener = listener;
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    InputDialog.this.okCallback();
                }
            }
        };
        this.inputLabels = labels;
        this.initialValues = initialValues;
        this.addOKButton();
        this.addCancelButton();
        this.buildMainPanel();
        if (initialValues != null && initialValues[0] != null && initialValues[0].length() > 0) {
            this.textFields[0].selectAll();
        }
        if (listener != null) {
            DocumentListener docListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    InputDialog.this.clearStatusText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    InputDialog.this.clearStatusText();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    InputDialog.this.clearStatusText();
                }
            };
            for (JTextField textField : this.textFields) {
                textField.getDocument().addDocumentListener(docListener);
            }
        }
        this.setFocusComponent(this.textFields[0]);
    }

    private void buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5, 120));
        this.inputValues = new String[this.inputLabels.length];
        this.textFields = new MyTextField[this.inputLabels.length];
        for (int i = 0; i < this.inputValues.length; ++i) {
            this.textFields[i] = new MyTextField(this.initialValues[i]);
            this.textFields[i].addKeyListener(this.keyListener);
            this.textFields[i].setName("input.dialog.text.field." + i);
            panel.add(new GLabel(this.inputLabels[i], 4));
            panel.add(this.textFields[i]);
        }
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addWorkPanel(panel);
    }

    @Override
    protected void okCallback() {
        this.isCanceled = false;
        for (int v = 0; v < this.inputValues.length; ++v) {
            this.inputValues[v] = this.textFields[v].getText();
        }
        if (this.listener != null && !this.listener.inputIsValid(this)) {
            return;
        }
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getValue() {
        return this.inputValues[0];
    }

    public void setValue(String text) {
        this.textFields[0].setText(text);
    }

    public String[] getValues() {
        return this.inputValues;
    }

    private class MyTextField
    extends JTextField {
        MyTextField(String str) {
            super(str, 20);
        }

        @Override
        protected Document createDefaultModel() {
            return new MyDocument(this);
        }

        private class MyDocument
        extends PlainDocument {
            private JTextField textField;

            private MyDocument(JTextField textField) {
                this.textField = textField;
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String text = this.textField.getText();
                if (text.length() + str.length() > 256) {
                    int nTooMany = text.length() + str.length() - 256;
                    int len = str.length() - nTooMany;
                    str = str.substring(0, len);
                }
                super.insertString(offs, str, a);
            }
        }
    }
}

