/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractNumberInputDialog
extends DialogComponentProvider {
    protected boolean wasCancelled = false;
    protected IntegerTextField numberInputField;
    protected BigInteger min;
    protected BigInteger max;
    protected JLabel label;
    protected String defaultMessage;

    public AbstractNumberInputDialog(String title, String prompt, Integer initialValue, int min, int max, boolean showAsHex) {
        this(title, prompt, AbstractNumberInputDialog.toBig(initialValue), AbstractNumberInputDialog.toBig(min), AbstractNumberInputDialog.toBig(max), showAsHex);
    }

    public AbstractNumberInputDialog(String title, String prompt, BigInteger initialValue, BigInteger min, BigInteger max, boolean showAsHex) {
        super(title, true, true, true, false);
        this.min = min;
        if (max.compareTo(min) < 0) {
            throw new IllegalArgumentException("'min' cannot be less than 'max'. 'min' = " + min + ", 'max' = " + max);
        }
        this.max = max;
        this.addWorkPanel(this.buildMainPanel(prompt, showAsHex));
        this.addOKButton();
        this.addCancelButton();
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.initializeDefaultValue(initialValue);
        this.selectAndFocusText();
    }

    private static String nonNull(String s) {
        if (s == null) {
            return "items";
        }
        return s;
    }

    protected JPanel buildMainPanel(String prompt, boolean showAsHex) {
        JPanel panel = this.createPanel(prompt);
        this.numberInputField.addActionListener(e -> this.okCallback());
        if (showAsHex) {
            this.numberInputField.setHexMode();
        }
        if (this.min.compareTo(BigInteger.valueOf(0L)) >= 0) {
            this.numberInputField.setAllowNegativeValues(false);
        }
        return panel;
    }

    @Override
    protected void okCallback() {
        if (this.checkInput()) {
            this.close();
        }
    }

    @Override
    protected void cancelCallback() {
        this.wasCancelled = true;
        this.close();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public BigInteger getBigIntegerValue() {
        if (this.wasCancelled()) {
            throw new IllegalStateException("User cancelled the dialog");
        }
        return this.numberInputField.getValue();
    }

    public long getLongValue() {
        if (this.wasCancelled()) {
            throw new IllegalStateException("User cancelled the dialog");
        }
        return this.numberInputField.getLongValue();
    }

    public int getIntValue() {
        if (this.wasCancelled()) {
            throw new IllegalStateException("User cancelled the dialog");
        }
        return this.numberInputField.getIntValue();
    }

    private void initializeDefaultValue(BigInteger initial) {
        if (initial == null) {
            return;
        }
        BigInteger value = initial;
        if (initial.compareTo(this.min) < 0) {
            value = this.min;
        } else if (initial.compareTo(this.max) > 0) {
            value = this.max;
        }
        this.numberInputField.setValue(value);
    }

    private void selectAndFocusText() {
        Swing.runLater(() -> {
            this.numberInputField.requestFocus();
            this.numberInputField.selectAll();
        });
    }

    public boolean show() {
        DockingWindowManager.showDialog(this);
        return !this.wasCancelled;
    }

    public void setInput(int value) {
        this.numberInputField.setValue(value);
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
        this.setStatusText(defaultMessage);
    }

    public int getMin() {
        return this.min.intValue();
    }

    public int getMax() {
        return this.max.intValue();
    }

    IntegerTextField getNumberInputField() {
        return this.numberInputField;
    }

    private JPanel createPanel(String prompt) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.label = new GDLabel(prompt);
        this.numberInputField = new IntegerTextField(12);
        this.numberInputField.addChangeListener(e -> this.updateOKButtonEnablement());
        panel.add((Component)this.label, "West");
        panel.add((Component)this.numberInputField.getComponent(), "Center");
        return panel;
    }

    protected void updateOKButtonEnablement() {
        this.clearStatusText();
        BigInteger value = this.numberInputField.getValue();
        if (value == null) {
            this.setOkEnabled(false);
            if (this.defaultMessage != null) {
                this.setStatusText(this.defaultMessage);
            } else {
                this.setStatusText("Enter a value between " + this.min + " and " + this.max);
            }
            return;
        }
        this.setOkEnabled(this.checkInput());
    }

    private boolean checkInput() {
        BigInteger value = this.numberInputField.getValue();
        if (value.compareTo(this.min) >= 0 && value.compareTo(this.max) <= 0) {
            if (this.defaultMessage != null) {
                this.setStatusText(this.defaultMessage);
            }
            return true;
        }
        this.setStatusText("Value must be between " + this.min + " and " + this.max);
        return false;
    }

    protected static String buildDefaultPrompt(String entryType, int min, int max) {
        String type = AbstractNumberInputDialog.nonNull(entryType);
        if (min == 0 && max == Integer.MAX_VALUE) {
            return "Enter number of " + type + ": ";
        }
        if (max == Integer.MAX_VALUE) {
            return "Enter number of " + type + " (minimum is " + min + ") : ";
        }
        return "Enter number of " + type + " (" + min + ", " + max + ") : ";
    }

    protected static BigInteger toBig(Integer i) {
        if (i == null) {
            return null;
        }
        return BigInteger.valueOf(i.intValue());
    }
}

