/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.options.Options;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

class OptionsTreeNode
extends GTreeLazyNode {
    private static final Icon OPEN_FOLDER_ICON = ResourceManager.loadImage((String)"images/openSmallFolder.png");
    private static final Icon CLOSED_FOLDER_ICON = ResourceManager.loadImage((String)"images/closedSmallFolder.png");
    private static final Icon PROPERTIES_ICON = ResourceManager.loadImage((String)"images/document-properties.png");
    private final Options options;
    private final String name;

    OptionsTreeNode(String name, Options options) {
        this.name = name;
        this.options = options;
    }

    OptionsTreeNode(Options options) {
        this(options.getName(), options);
    }

    @Override
    protected List<GTreeNode> generateChildren() {
        ArrayList<GTreeNode> childList = new ArrayList<GTreeNode>();
        if (this.options.getOptionsEditor() == null) {
            List childOptionsList = this.options.getChildOptions();
            for (Options childOptions : childOptionsList) {
                childList.add(new OptionsTreeNode(childOptions));
            }
        }
        Collections.sort(childList);
        return childList;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public Icon getIcon(boolean isExpanded) {
        if (this.isLeaf()) {
            return PROPERTIES_ICON;
        }
        return isExpanded ? OPEN_FOLDER_ICON : CLOSED_FOLDER_ICON;
    }

    @Override
    public int compareTo(OptionsTreeNode other) {
        return this.getName().compareTo(other.getName());
    }

    public String getGroupPathName() {
        return null;
    }

    public Options getOptions() {
        return this.options;
    }

    public List<String> getOptionNames() {
        if (this.options == null) {
            return new ArrayList<String>();
        }
        return this.options.getLeafOptionNames();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public int compareTo(GTreeNode other) {
        return this.getName().compareTo(other.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getName().equals(((OptionsTreeNode)obj).getName());
    }
}

