/*
 * Decompiled with CFR 0.152.
 */
package docking.framework;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationProperties;
import ghidra.util.SystemUtilities;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;
import utility.module.ModuleUtilities;

public class DockingApplicationLayout
extends ApplicationLayout {
    private static final String NO_RELEASE_NAME = "NO_RELEASE";

    public DockingApplicationLayout(String name) throws FileNotFoundException {
        this(name, "0.1");
    }

    public DockingApplicationLayout(String name, String version) throws FileNotFoundException {
        this(new ApplicationProperties(name, version, NO_RELEASE_NAME));
    }

    public DockingApplicationLayout(ApplicationProperties applicationProperties) throws FileNotFoundException {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        if (SystemUtilities.isInDevelopmentMode()) {
            this.applicationRootDirs = ApplicationUtilities.findDefaultApplicationRootDirs();
        } else {
            this.applicationRootDirs = new ArrayList();
            this.applicationRootDirs.add(new ResourceFile(System.getProperty("user.dir")));
        }
        this.applicationInstallationDir = ((ResourceFile)this.applicationRootDirs.iterator().next()).getParentFile();
        if (SystemUtilities.isInDevelopmentMode()) {
            this.applicationInstallationDir = this.applicationInstallationDir.getParentFile();
        }
        this.modules = SystemUtilities.isInDevelopmentMode() ? ModuleUtilities.findModules((Collection)this.applicationRootDirs, (Collection)ModuleUtilities.findModuleRootDirectories((Collection)this.applicationRootDirs, new ArrayList())) : ModuleUtilities.findModules((Collection)this.applicationRootDirs, (Collection)this.applicationRootDirs);
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir((ApplicationProperties)applicationProperties);
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir((ApplicationProperties)applicationProperties, (ResourceFile)this.applicationInstallationDir);
    }
}

