/*
 * Decompiled with CFR 0.152.
 */
package docking.framework;

import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.framework.Application;
import ghidra.framework.PluggableServiceRegistry;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import resources.ResourceManager;

public class ApplicationInformationDisplayFactory {
    public static String createSplashScreenTitle() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doCreateSplashScreenTitle();
    }

    public static String createAboutTitle() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doCreateAboutTitle();
    }

    public static List<Image> getWindowIcons() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doGetWindowIcons();
    }

    public static Image getLargestWindowIcon() {
        List<Image> windowIcons = ApplicationInformationDisplayFactory.getWindowIcons();
        Image bestImageSoFar = null;
        for (Image image : windowIcons) {
            int width = image.getWidth(null);
            if (bestImageSoFar == null) {
                bestImageSoFar = image;
                continue;
            }
            if (width <= bestImageSoFar.getWidth(null)) continue;
            bestImageSoFar = image;
        }
        return bestImageSoFar;
    }

    public static ImageIcon getHomeIcon() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doGetHomeIcon();
    }

    public static Runnable getHomeCallback() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doGetHomeCallback();
    }

    public static JComponent createSplashScreenComponent() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doCreateSplashScreenComponent();
    }

    public static JComponent createAboutComponent() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doCreateAboutComponent();
    }

    public static HelpLocation createHelpLocation() {
        ApplicationInformationDisplayFactory factory = (ApplicationInformationDisplayFactory)PluggableServiceRegistry.getPluggableService(ApplicationInformationDisplayFactory.class);
        return factory.doCreateHelpLocation();
    }

    protected String doCreateSplashScreenTitle() {
        return Application.getName() + " " + Application.getApplicationVersion();
    }

    protected String doCreateAboutTitle() {
        return "About " + Application.getName();
    }

    protected JComponent doCreateSplashScreenComponent() {
        ImageIcon icon = this.getSplashScreenIcon128();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(400, 400));
        Color background = Color.BLACK;
        panel.setBackground(background);
        GLabel nameLabel = new GLabel(Application.getName());
        nameLabel.setForeground(new Color(155, 155, 155));
        Font newFont = new Font("Garamond", 1, 35);
        nameLabel.setFont(newFont);
        nameLabel.setHorizontalAlignment(0);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)nameLabel, "North");
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setBackground(background);
        GIconLabel imageLabel = new GIconLabel(icon);
        imageLabel.setVerticalAlignment(0);
        imageLabel.setHorizontalAlignment(0);
        imagePanel.add(imageLabel);
        panel.add((Component)imagePanel, "Center");
        return panel;
    }

    protected ImageIcon getSplashScreenIcon128() {
        return ResourceManager.loadImage((String)"images/www_128.png");
    }

    protected List<Image> doGetWindowIcons() {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(ResourceManager.loadImage((String)"images/www_128.png").getImage());
        list.add(ResourceManager.loadImage((String)"images/www_16.png").getImage());
        return list;
    }

    protected JComponent doCreateAboutComponent() {
        return this.doCreateSplashScreenComponent();
    }

    protected HelpLocation doCreateHelpLocation() {
        return null;
    }

    protected ImageIcon doGetHomeIcon() {
        return ResourceManager.loadImage((String)"images/www_16.png");
    }

    protected Runnable doGetHomeCallback() {
        return () -> Msg.info((Object)this, (Object)"Home button pressed");
    }

    static {
        PluggableServiceRegistry.registerPluggableService(ApplicationInformationDisplayFactory.class, (Object)new ApplicationInformationDisplayFactory());
    }
}

